/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

@Configuration
@EnableWebSecurity
public class YogiSecurity
extends WebSecurityConfigurerAdapter {
    private final FileNode userProperties;

    public YogiSecurity(World world, @Value(value="${yogi.etc}") String etc) {
        this.userProperties = (FileNode)world.file(etc).join(new String[]{"user.properties"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/", "/static/**", "/webjars/**"})).permitAll().anyRequest()).authenticated().and()).formLogin().loginPage("/").successHandler((AuthenticationSuccessHandler)YogiSecurity.successHandler())).permitAll()).and()).logout().logoutSuccessUrl("/").permitAll();
    }

    private static SavedRequestAwareAuthenticationSuccessHandler successHandler() {
        SavedRequestAwareAuthenticationSuccessHandler result = new SavedRequestAwareAuthenticationSuccessHandler();
        result.setDefaultTargetUrl("/books");
        return result;
    }

    @Bean
    public UserDetailsService userDetailsService() {
        Properties p;
        try {
            p = this.userProperties.readProperties();
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot load user.properties", e);
        }
        InMemoryUserDetailsManager result = new InMemoryUserDetailsManager();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            result.createUser(YogiSecurity.user((String)entry.getKey(), (String)entry.getValue()));
        }
        return result;
    }

    private static UserDetails user(String name, String pw) {
        return User.withDefaultPasswordEncoder().username(name).password(pw).roles(new String[]{"USER"}).build();
    }

    public static String username() {
        User user = YogiSecurity.userOpt();
        return user == null ? "anonymous" : user.getUsername();
    }

    public static User userOpt() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        return (User)authentication.getPrincipal();
    }
}

