/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.desktop.impl;

import de.sciss.desktop.Desktop;
import de.sciss.desktop.Platform;
import de.sciss.file.package;
import de.sciss.file.package$;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LinuxPlatform$
implements Platform {
    public static LinuxPlatform$ MODULE$;
    private final String[] execDirs;

    static {
        new LinuxPlatform$();
    }

    public String toString() {
        return "LinuxPlatform";
    }

    private Option<File> findExec(String fileName) {
        String[] folders = this.execDirs;
        for (int i = 0; i < folders.length; ++i) {
            String folder = folders[i];
            File f = new File(folder, fileName);
            if (!f.canExecute()) continue;
            return new Some((Object)f);
        }
        return None$.MODULE$;
    }

    public void revealFile(File file) {
        File fileAbs = package.RichFile$.MODULE$.absolute$extension(package$.MODULE$.RichFile(file));
        Option<File> option = this.findExec("nautilus");
        if (option instanceof Some) {
            Some some = (Some)option;
            File cmd2 = (File)some.value();
            scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(cmd2)), (List)new .colon.colon((Object)package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(fileAbs)), (List)Nil$.MODULE$))).run();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.findExec("xdg-open").foreach((Function1 & Serializable & scala.Serializable)cmd -> {
                LinuxPlatform$.$anonfun$revealFile$1(fileAbs, cmd);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private File xdgDataHome() {
        return (File)scala.sys.package$.MODULE$.env().get((Object)"XDG_DATA_HOME").fold((Function0 & Serializable & scala.Serializable)() -> package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(package$.MODULE$.userHome()), ".local")), "share"), (Function1 & Serializable & scala.Serializable)path -> package$.MODULE$.file(path));
    }

    private File createUniqueFile(File parent, String base, String ext) {
        String ext1 = ext.isEmpty() || ext.charAt(0) == '.' ? ext : new StringBuilder(1).append(".").append(ext).toString();
        return this.loop$1(1, base, ext1, parent);
    }

    private String escapedPath(File f) {
        String u = f.toURI().toString();
        Predef$.MODULE$.assert(u.startsWith("file:"));
        return u.substring(5);
    }

    public void moveFileToTrash(File file) {
        block3: {
            File file2;
            File trash = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(this.xdgDataHome()), "Trash");
            Object object = !trash.exists() ? BoxesRunTime.boxToBoolean((boolean)trash.mkdirs()) : BoxedUnit.UNIT;
            File files = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(trash), "files");
            Object object2 = !files.exists() ? BoxesRunTime.boxToBoolean((boolean)files.mkdir()) : BoxedUnit.UNIT;
            File target0 = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(files), package.RichFile$.MODULE$.name$extension(package$.MODULE$.RichFile(file)));
            if (!target0.exists()) {
                file2 = target0;
            } else {
                Tuple2 tuple2 = package.RichFile$.MODULE$.baseAndExt$extension(package$.MODULE$.RichFile(file));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String base = (String)tuple2._1();
                String ext = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)base, (Object)ext);
                Tuple2 tuple23 = tuple22;
                String base2 = (String)tuple23._1();
                String ext2 = (String)tuple23._2();
                file2 = this.createUniqueFile(files, base2, ext2);
            }
            File targetFile = file2;
            File info = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(trash), "info");
            Object object3 = !info.exists() ? BoxesRunTime.boxToBoolean((boolean)info.mkdir()) : BoxedUnit.UNIT;
            File infoFile = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(info), new StringBuilder(10).append(package.RichFile$.MODULE$.name$extension(package$.MODULE$.RichFile(targetFile))).append(".trashinfo").toString());
            int mvRes = scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"mv", (List)new .colon.colon((Object)package.RichFile$.MODULE$.absolutePath$extension(package$.MODULE$.RichFile(file)), (List)new .colon.colon((Object)package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(targetFile)), (List)Nil$.MODULE$)))).$bang();
            if (mvRes != 0) break block3;
            String sourceEscape = this.escapedPath(package.RichFile$.MODULE$.absolute$extension(package$.MODULE$.RichFile(file)));
            String deletionDate = new SimpleDateFormat("YYYY-MM-DD'T'hh:mm:ss", Locale.US).format(new Date());
            String infoString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("[Trash Info]\n           |Path=").append(sourceEscape).append("\n           |DeletionDate=").append(deletionDate).append("\n           |").toString())).stripMargin();
            FileOutputStream infoS = new FileOutputStream(infoFile);
            infoS.write(infoString.getBytes("UTF-8"));
            infoS.close();
        }
    }

    public PartialFunction<Desktop.Update, BoxedUnit> addListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
        return pf;
    }

    public void removeListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
    }

    public void setDockImage(Image image) {
    }

    public void setDockBadge(Option<String> label) {
    }

    public void requestUserAttention(boolean repeat) {
    }

    public void requestForeground(boolean allWindows) {
    }

    public boolean setQuitHandler(Function0<Future<BoxedUnit>> test) {
        return false;
    }

    public boolean setAboutHandler(Function0<BoxedUnit> action) {
        return false;
    }

    public boolean setPreferencesHandler(Function0<BoxedUnit> action) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$revealFile$1(File fileAbs$1, File cmd) {
        package.RichFile$.MODULE$.parentOption$extension(package$.MODULE$.RichFile(fileAbs$1)).foreach((Function1 & Serializable & scala.Serializable)parent -> scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(cmd)), (List)new .colon.colon((Object)package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(parent)), (List)Nil$.MODULE$))).run());
    }

    private final File loop$1(int count, String base$1, String ext1$1, File parent$1) {
        File test;
        while (true) {
            String name = new StringBuilder(1).append(base$1).append("-").append(count).append(ext1$1).toString();
            test = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(parent$1), name);
            if (!test.exists()) break;
            ++count;
        }
        return test;
    }

    private LinuxPlatform$() {
        MODULE$ = this;
        this.execDirs = (String[])((Object[])new String[]{"/usr/local/bin", "/usr/bin"});
    }
}

