/*
 * Decompiled with CFR 0.152.
 */
package dotterweide.ide;

import dispatch.Http$;
import dispatch.Req;
import dispatch.as.xml.Elem$;
import dispatch.url$;
import dotterweide.build.Module;
import dotterweide.build.Version;
import dotterweide.build.Version$;
import dotterweide.ide.DocUtil;
import dotterweide.io.FileDownload;
import dotterweide.io.JarUtil$;
import dotterweide.io.impl.FileDownloadImpl;
import dotterweide.io.impl.FileDownloadImpl$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.xml.NodeSeq;

public final class DocUtil$ {
    public static final DocUtil$ MODULE$ = new DocUtil$();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyResource(String path, File out) {
        try (BufferedInputStream is = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(path));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
            byte[] arr = new byte[1024];
            while (true) {
                boolean bl;
                int sz;
                if ((sz = is.read(arr)) > 0) {
                    os.write(arr, 0, sz);
                    bl = true;
                } else {
                    bl = false;
                }
                if (!bl) return;
            }
        }
    }

    public void setScalaCssStyle(boolean dark, File baseDir) {
        String tpe = dark ? "dark" : "light";
        File styleDir = new File(baseDir, "lib");
        this.copyResource(new StringBuilder(22).append("dotterweide/index-").append(tpe).append(".css").toString(), new File(styleDir, "index.css"));
        this.copyResource(new StringBuilder(25).append("dotterweide/template-").append(tpe).append(".css").toString(), new File(styleDir, "template.css"));
    }

    public URL mavenCentral() {
        return new URL("https://repo1.maven.org/maven2");
    }

    private URL appendToURL(URL in, String child) {
        URI uri = in.toURI();
        String newPath = new StringBuilder(0).append(uri.getPath()).append(child).toString();
        URI newUri = uri.resolve(newPath);
        return newUri.toURL();
    }

    public URL mkJavadocDownloadUrl(Module docModule, URL repoBase) {
        String version = docModule.version().toString();
        String child = new StringBuilder(17).append("/").append(docModule.groupId().replace('.', '/')).append("/").append(docModule.artifactId()).append("/").append(version).append("/").append(docModule.artifactId()).append("-").append(version).append("-javadoc.jar").toString();
        return this.appendToURL(repoBase, child);
    }

    public URL mkJavadocDownloadUrl$default$2() {
        return this.mavenCentral();
    }

    public URL mkJavadocMetaDataUrl(Module docModule, URL repoBase) {
        String child = new StringBuilder(21).append("/").append(docModule.groupId().replace('.', '/')).append("/").append(docModule.artifactId()).append("/maven-metadata.xml").toString();
        return this.appendToURL(repoBase, child);
    }

    public URL mkJavadocMetaDataUrl$default$2() {
        return this.mavenCentral();
    }

    public Tuple2<FileDownload, Future<BoxedUnit>> downloadAndExtract(Module docModule, File target, boolean darkCss, URL repoBase, boolean deleteOnExit, ExecutionContext exec) {
        File jarFile = File.createTempFile("javadoc", ".jar");
        URL docUrl = this.mkJavadocDownloadUrl(docModule, repoBase);
        Req req = url$.MODULE$.apply(docUrl.toString());
        FileDownloadImpl dl = new FileDownloadImpl(req, jarFile, FileDownloadImpl$.MODULE$.$lessinit$greater$default$3());
        Future futRes = dl.status().map((Function1 & Serializable)x$1 -> {
            package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                target$1.mkdirs();
                Map<String, File> map = JarUtil$.MODULE$.unpackFiles(jarFile$1, target$1);
                if (deleteOnExit$1) {
                    map.valuesIterator().foreach((Function1 & Serializable)x$2 -> {
                        x$2.deleteOnExit();
                        return BoxedUnit.UNIT;
                    });
                }
                jarFile$1.delete();
                DocUtil$.MODULE$.setScalaCssStyle(darkCss$1, target$1);
            });
            return BoxedUnit.UNIT;
        }, exec);
        return new Tuple2((Object)dl, (Object)futRes);
    }

    public boolean downloadAndExtract$default$3() {
        return false;
    }

    public URL downloadAndExtract$default$4() {
        return this.mavenCentral();
    }

    public boolean downloadAndExtract$default$5() {
        return false;
    }

    public File defaultUnpackDirBase(File baseDir, String groupId, String artifactId) {
        return new File(new File(baseDir, groupId), artifactId);
    }

    public File defaultUnpackDir(File baseDir, Module docModule) {
        return new File(this.defaultUnpackDirBase(baseDir, docModule.groupId(), docModule.artifactId()), docModule.version().toString());
    }

    public Future<DocUtil.Metadata> findModuleVersions(Module docModule, URL repoBase, ExecutionContext exec) {
        URL metaDataURL = this.mkJavadocMetaDataUrl(docModule, repoBase);
        Req metaDataReq = url$.MODULE$.apply(metaDataURL.toString());
        Future metaDataFut = Http$.MODULE$.default().apply(dispatch.package$.MODULE$.implyRequestHandlerTuple(metaDataReq).OK((Function1)Elem$.MODULE$), exec);
        return metaDataFut.map((Function1 & Serializable)metaData -> {
            NodeSeq metaVersioning = metaData.$bslash("versioning");
            long lastUpdated = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(metaVersioning.$bslash("lastUpdated").text().trim()));
            Version latestVersion = (Version)Version$.MODULE$.parse(metaVersioning.$bslash("latest").text()).get();
            Seq metaVersions = (Seq)metaVersioning.$bslash("versions").$bslash("version").flatMap((Function1 & Serializable)n -> Version$.MODULE$.parse(n.text()).toOption());
            Seq res = (Seq)metaVersions.sorted(Version.ordering$.MODULE$.reverse());
            return new DocUtil.Metadata(lastUpdated, latestVersion, (Seq<Version>)res);
        }, exec);
    }

    public URL findModuleVersions$default$2() {
        return this.mavenCentral();
    }

    private DocUtil$() {
    }
}

