/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw;

import edu.cmu.lti.jawjaw.db.SynsetDefDAO;
import edu.cmu.lti.jawjaw.pobj.Lang;
import edu.cmu.lti.jawjaw.pobj.Link;
import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.jawjaw.pobj.Synset;
import edu.cmu.lti.jawjaw.pobj.SynsetDef;
import edu.cmu.lti.jawjaw.util.WordNetUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class JAWJAW {
    public static Set<String> findHypernyms(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.hype);
    }

    public static Set<String> findHyponyms(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.hypo);
    }

    public static Set<String> findMeronyms(String word, POS pos) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        results.addAll(WordNetUtil.findLinks(word, pos, Link.mmem));
        results.addAll(WordNetUtil.findLinks(word, pos, Link.msub));
        results.addAll(WordNetUtil.findLinks(word, pos, Link.mprt));
        return results;
    }

    public static Set<String> findHolonyms(String word, POS pos) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        results.addAll(WordNetUtil.findLinks(word, pos, Link.hmem));
        results.addAll(WordNetUtil.findLinks(word, pos, Link.hsub));
        results.addAll(WordNetUtil.findLinks(word, pos, Link.hprt));
        return results;
    }

    public static Set<String> findInstances(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.inst);
    }

    public static Set<String> findHasInstances(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.hasi);
    }

    public static Set<String> findAttributes(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.attr);
    }

    public static Set<String> findSimilarTo(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.sim);
    }

    public static Set<String> findEntailments(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.enta);
    }

    public static Set<String> findCauses(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.caus);
    }

    public static Set<String> findSeeAlso(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.also);
    }

    public static Set<String> findSynonyms(String word, POS pos) {
        return WordNetUtil.findSynonyms(word, pos, false);
    }

    public static Set<String> findAntonyms(String word, POS pos) {
        return WordNetUtil.findLinks(word, pos, Link.ants);
    }

    public static Set<String> findDomains(String word, POS pos) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        results.addAll(WordNetUtil.findLinks(word, pos, Link.dmnc));
        results.addAll(WordNetUtil.findLinks(word, pos, Link.dmnr));
        results.addAll(WordNetUtil.findLinks(word, pos, Link.dmnu));
        return results;
    }

    public static Set<String> findInDomains(String word, POS pos) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        results.addAll(WordNetUtil.findLinks(word, pos, Link.dmtc));
        results.addAll(WordNetUtil.findLinks(word, pos, Link.dmtr));
        results.addAll(WordNetUtil.findLinks(word, pos, Link.dmtu));
        return results;
    }

    public static Set<String> findTranslations(String word, POS pos) {
        return WordNetUtil.findSynonyms(word, pos, true);
    }

    public static Set<String> findDefinitions(String word, POS pos) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        List<Synset> synsets = WordNetUtil.wordToSynsets(word, pos);
        Lang lang = Lang.eng;
        for (Synset synset : synsets) {
            SynsetDef def = SynsetDefDAO.findSynsetDefBySynsetAndLang(synset.getSynset(), lang);
            results.add(def.getDef());
        }
        return results;
    }
}

