/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db;

import edu.cmu.lti.jawjaw.db.SQLQuery;
import edu.cmu.lti.jawjaw.db.datamover.DataMoverUtility;
import edu.cmu.lti.jawjaw.util.Configuration;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class SQL {
    private static Connection connection;
    private static final String DRIVER = "org.sqlite.JDBC";
    private static final SQL instance;
    private static final boolean BENCHMARK = false;
    private ConcurrentMap<SQLQuery, PreparedStatement> preparedStatements = null;

    private SQL() {
        try {
            this.createSQLConnection();
            this.prepareStatements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SQL getInstance() {
        return instance;
    }

    private synchronized void createSQLConnection() throws ClassNotFoundException, UnsupportedEncodingException, IOException, SQLException {
        Class.forName(DRIVER);
        String classpath = "/" + Configuration.getInstance().getWordnet();
        URL dbUrl = SQL.class.getResource(classpath);
        if (dbUrl == null) {
            System.err.println("ERROR: Make sure the NICT wordnet db is stored in classpath at: " + classpath);
        }
        String sqlUrl = "jdbc:sqlite::resource:" + Configuration.getInstance().getWordnet();
        connection = Configuration.getInstance().useMemoryDB() ? DataMoverUtility.getMemoryDBConnection(DRIVER, sqlUrl) : DriverManager.getConnection(sqlUrl);
        this.createIndexIfNotExists(connection);
        this.setPragmaCacheSize(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexIfNotExists(Connection connection) {
        long t0 = System.currentTimeMillis();
        Statement s = null;
        try {
            s = connection.createStatement();
            connection.setAutoCommit(false);
            s.addBatch("CREATE INDEX IF NOT EXISTS word_wordid_idx ON word (wordid);");
            s.addBatch("CREATE INDEX IF NOT EXISTS word_lemma_idx ON word (lemma,pos);");
            s.addBatch("CREATE INDEX IF NOT EXISTS sense_synset_idx ON sense (synset);");
            s.addBatch("CREATE INDEX IF NOT EXISTS sense_wordid_idx ON sense (wordid);");
            s.addBatch("CREATE INDEX IF NOT EXISTS synset_id_idx ON synset (synset);");
            s.addBatch("CREATE INDEX IF NOT EXISTS synset_name_idx ON synset (name);");
            s.addBatch("CREATE INDEX IF NOT EXISTS synset_def_id_idx ON synset_def (synset);");
            s.addBatch("CREATE INDEX IF NOT EXISTS synlink_idx ON synlink (synset1,link);");
            s.executeBatch();
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
        long t1 = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPragmaCacheSize(Connection connection) {
        if (Configuration.getInstance().useMemoryDB()) {
            return;
        }
        Statement s = null;
        try {
            s = connection.createStatement();
            s.execute("PRAGMA cache_size = " + Configuration.getInstance().getDbCacheSize() + ";");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
    }

    private synchronized void prepareStatements() throws SQLException {
        this.preparedStatements = new ConcurrentHashMap<SQLQuery, PreparedStatement>();
        for (SQLQuery query : SQLQuery.values()) {
            String queryText = query.getQueryText();
            PreparedStatement ps = connection.prepareStatement(queryText);
            this.preparedStatements.put(query, ps);
        }
    }

    private String extractDBIfJar(String pathToWordNet) throws IOException {
        File[] oldTempFiles;
        String tempPrefix = "wnja-temp-";
        if (pathToWordNet.indexOf("jar!") == -1) {
            return pathToWordNet;
        }
        System.out.print("Extracting wordnet database from jar file ... ");
        long t0 = System.currentTimeMillis();
        String wnName = Configuration.getInstance().getWordnet();
        String tempFolderPath = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        File tempFolder = new File(tempFolderPath);
        for (File f : oldTempFiles = tempFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("wnja-temp-");
            }
        })) {
            boolean deleted = f.delete();
            if (deleted) continue;
            System.out.print("Failed to delete old wn-ja files at " + f.getAbsolutePath());
        }
        File uncompressedDb = File.createTempFile("wnja-temp-", ".db");
        uncompressedDb.deleteOnExit();
        try {
            InputStream reader = SQL.class.getResourceAsStream("/" + wnName);
            FileOutputStream writer = new FileOutputStream(uncompressedDb);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            writer.close();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long t1 = System.currentTimeMillis();
        System.out.println("done in " + (double)(t1 - t0) / 1000.0 + " sec.");
        return uncompressedDb.getAbsolutePath();
    }

    public PreparedStatement getPreparedStatement(SQLQuery query) {
        return (PreparedStatement)this.preparedStatements.get((Object)query);
    }

    protected void finalize() throws Throwable {
        try {
            for (PreparedStatement ps : this.preparedStatements.values()) {
                if (ps == null) continue;
                ps.close();
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public Connection getConnection() {
        return connection;
    }

    static {
        instance = new SQL();
    }
}

