/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db;

import edu.cmu.lti.jawjaw.db.SQL;
import edu.cmu.lti.jawjaw.db.SQLQuery;
import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.jawjaw.pobj.Synset;
import edu.cmu.lti.jawjaw.util.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SynsetDAO {
    private static ConcurrentMap<String, List<Synset>> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Synset findSynsetBySynset(String synset) {
        List cachedObj;
        String key = synset;
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return SynsetDAO.clone(cachedObj).get(0);
        }
        Synset s = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SYNSET_BY_SYNSET);
            synchronized (preparedStatement) {
                ps.setString(1, synset);
                rs = ps.executeQuery();
                if (rs.next()) {
                    s = SynsetDAO.rsToObject(rs);
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            ArrayList<Synset> synsets = new ArrayList<Synset>(1);
            synsets.add(s);
            if (synsets != null) {
                cache.put(key, SynsetDAO.clone(synsets));
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static List<Synset> findSynsetsByName(String name) {
        List cachedObj;
        String key = name;
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return SynsetDAO.clone(cachedObj);
        }
        ArrayList<Synset> synsets = new ArrayList<Synset>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SYNSETS_BY_NAME);
            synchronized (preparedStatement) {
                ps.setString(1, name);
                rs = ps.executeQuery();
                while (rs.next()) {
                    synsets.add(SynsetDAO.rsToObject(rs));
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (synsets != null) {
                cache.put(key, SynsetDAO.clone(synsets));
            }
        }
        return synsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Synset> findSynsetsByNameAndPos(String name, POS pos) {
        List cachedObj;
        String key = name + " " + (Object)((Object)pos);
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return SynsetDAO.clone(cachedObj);
        }
        ArrayList<Synset> synsets = new ArrayList<Synset>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SYNSETS_BY_NAME_AND_POS);
            synchronized (preparedStatement) {
                ps.setString(1, name);
                ps.setString(2, pos.toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    synsets.add(SynsetDAO.rsToObject(rs));
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (synsets != null) {
                cache.put(key, SynsetDAO.clone(synsets));
            }
        }
        return synsets;
    }

    private static Synset rsToObject(ResultSet rs) throws SQLException {
        Synset synset = new Synset(rs.getString(1), POS.valueOf(rs.getString(2)), rs.getString(3), rs.getString(4));
        return synset;
    }

    private static List<Synset> clone(List<Synset> synsets) {
        ArrayList<Synset> cloned = new ArrayList<Synset>(synsets.size());
        for (Synset synset : synsets) {
            cloned.add(synset.clone());
        }
        return synsets;
    }

    static {
        if (Configuration.getInstance().useCache()) {
            cache = new ConcurrentHashMap<String, List<Synset>>(Configuration.getInstance().getMaxCacheSize());
        }
    }
}

