/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db;

import edu.cmu.lti.jawjaw.db.SQL;
import edu.cmu.lti.jawjaw.db.SQLQuery;
import edu.cmu.lti.jawjaw.db.datamover.DataMoverUtility;
import edu.cmu.lti.jawjaw.util.Configuration;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public final class UnpreparedSQL {
    private static Connection connection;
    private static final String DRIVER = "org.sqlite.JDBC";
    private static final UnpreparedSQL instance;
    private static final boolean BENCHMARK = false;

    private UnpreparedSQL() {
        try {
            this.createSQLConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static UnpreparedSQL getInstance() {
        return instance;
    }

    private synchronized void createSQLConnection() throws ClassNotFoundException, UnsupportedEncodingException, IOException, SQLException {
        Class.forName(DRIVER);
        String classpath = "/" + Configuration.getInstance().getWordnet();
        URL dbUrl = SQL.class.getResource(classpath);
        if (dbUrl == null) {
            System.err.println("ERROR: Make sure the NICT wordnet db is stored in classpath at: " + classpath);
        }
        String sqlUrl = "jdbc:sqlite::resource:" + Configuration.getInstance().getWordnet();
        connection = Configuration.getInstance().useMemoryDB() ? DataMoverUtility.getMemoryDBConnection(DRIVER, sqlUrl) : DriverManager.getConnection(sqlUrl);
        this.createIndexIfNotExists(connection);
        this.setPragmaCacheSize(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexIfNotExists(Connection connection) {
        long t0 = System.currentTimeMillis();
        Statement s = null;
        try {
            s = connection.createStatement();
            connection.setAutoCommit(false);
            s.addBatch("CREATE INDEX IF NOT EXISTS word_wordid_idx ON word (wordid);");
            s.addBatch("CREATE INDEX IF NOT EXISTS word_lemma_idx ON word (lemma,pos);");
            s.addBatch("CREATE INDEX IF NOT EXISTS sense_synset_idx ON sense (synset);");
            s.addBatch("CREATE INDEX IF NOT EXISTS sense_wordid_idx ON sense (wordid);");
            s.addBatch("CREATE INDEX IF NOT EXISTS synset_id_idx ON synset (synset);");
            s.addBatch("CREATE INDEX IF NOT EXISTS synset_name_idx ON synset (name);");
            s.addBatch("CREATE INDEX IF NOT EXISTS synset_def_id_idx ON synset_def (synset);");
            s.addBatch("CREATE INDEX IF NOT EXISTS synlink_idx ON synlink (synset1,link);");
            s.executeBatch();
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
        long t1 = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPragmaCacheSize(Connection connection) {
        if (Configuration.getInstance().useMemoryDB()) {
            return;
        }
        Statement s = null;
        try {
            s = connection.createStatement();
            s.execute("PRAGMA cache_size = " + Configuration.getInstance().getDbCacheSize() + ";");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
    }

    public PreparedStatement getPreparedStatement(SQLQuery query) throws SQLException {
        return connection.prepareStatement(query.getQueryText());
    }

    static {
        instance = new UnpreparedSQL();
    }
}

