/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db;

import edu.cmu.lti.jawjaw.db.SQL;
import edu.cmu.lti.jawjaw.db.SQLQuery;
import edu.cmu.lti.jawjaw.pobj.Lang;
import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.jawjaw.pobj.Word;
import edu.cmu.lti.jawjaw.util.Configuration;
import edu.cmu.lti.jawjaw.util.TextUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WordDAO {
    private static ConcurrentMap<String, List<Word>> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Word> findWordsByLemma(String lemma) {
        List cachedObj;
        String key = lemma;
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return WordDAO.clone(cachedObj);
        }
        lemma = TextUtil.canonicalize(lemma);
        ArrayList<Word> words = new ArrayList<Word>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_WORD_BY_LEMMA);
            synchronized (preparedStatement) {
                ps.setString(1, lemma);
                rs = ps.executeQuery();
                while (rs.next()) {
                    words.add(WordDAO.rsToObject(rs));
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (words != null) {
                cache.put(key, WordDAO.clone(words));
            }
        }
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Word> findWordsByLemmaAndPos(String lemma, POS pos) {
        List cachedObj;
        String key = lemma + " " + (Object)((Object)pos);
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return WordDAO.clone(cachedObj);
        }
        ArrayList<Word> words = new ArrayList<Word>();
        if (lemma == null) {
            return words;
        }
        lemma = lemma.toLowerCase();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_WORD_BY_LEMMA_AND_POS);
            synchronized (preparedStatement) {
                ps.setString(1, lemma);
                ps.setString(2, pos.toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    words.add(WordDAO.rsToObject(rs));
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (words != null) {
                cache.put(key, WordDAO.clone(words));
            }
        }
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Word findWordByWordid(int wordid) {
        List cachedObj;
        String key = wordid + "";
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return WordDAO.clone(cachedObj).get(0);
        }
        Word word = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_WORD_BY_WORDID);
            synchronized (preparedStatement) {
                ps.setInt(1, wordid);
                rs = ps.executeQuery();
                if (rs.next()) {
                    word = WordDAO.rsToObject(rs);
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            ArrayList<Word> words = new ArrayList<Word>(1);
            words.add(word);
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (word != null) {
                cache.put(key, WordDAO.clone(words));
            }
        }
        return word;
    }

    private static Word rsToObject(ResultSet rs) throws SQLException {
        Word word = new Word(rs.getInt(1), Lang.valueOf(rs.getString(2)), rs.getString(3), rs.getString(4), POS.valueOf(rs.getString(5)));
        return word;
    }

    private static List<Word> clone(List<Word> words) {
        ArrayList<Word> cloned = new ArrayList<Word>(words.size());
        for (Word word : words) {
            cloned.add(word.clone());
        }
        return words;
    }

    static {
        if (Configuration.getInstance().useCache()) {
            cache = new ConcurrentHashMap<String, List<Word>>(Configuration.getInstance().getMaxCacheSize());
        }
    }
}

