/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db.datamover;

import edu.cmu.lti.jawjaw.db.datamover.Database;
import edu.cmu.lti.jawjaw.db.datamover.DatabaseException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataMover {
    private Database source;
    private Database target;
    private List<String> tables = new ArrayList<String>();

    public Database getSource() {
        return this.source;
    }

    public void setSource(Database source) {
        this.source = source;
    }

    public Database getTarget() {
        return this.target;
    }

    public void setTarget(Database target) {
        this.target = target;
    }

    public synchronized void createTable(String table) throws DatabaseException {
        String sql;
        if (this.target.tableExists(table)) {
            sql = this.source.generateDrop(table);
            this.target.execute(sql);
        }
        sql = this.source.generateCreate(table);
        this.target.execute(sql);
    }

    private synchronized void createTables() throws DatabaseException {
        Collection<String> list = this.source.listTables();
        for (String table : list) {
            try {
                this.createTable(table);
                this.tables.add(table);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void copyTable(String table) throws DatabaseException {
        StringBuffer selectSQL = new StringBuffer();
        StringBuffer insertSQL = new StringBuffer();
        StringBuffer values = new StringBuffer();
        Collection<String> columns = this.source.listColumns(table);
        selectSQL.append("SELECT ");
        insertSQL.append("INSERT INTO ");
        insertSQL.append(table);
        insertSQL.append("(");
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                selectSQL.append(",");
                insertSQL.append(",");
                values.append(",");
            } else {
                first = false;
            }
            selectSQL.append(column);
            insertSQL.append(column);
            values.append("?");
        }
        selectSQL.append(" FROM ");
        selectSQL.append(table);
        insertSQL.append(") VALUES (");
        insertSQL.append(values);
        insertSQL.append(")");
        Statement statementSrc = null;
        PreparedStatement statementTrg = null;
        ResultSet rs = null;
        try {
            statementTrg = this.target.prepareStatement(insertSQL.toString());
            statementSrc = this.source.prepareStatement(selectSQL.toString());
            rs = statementSrc.executeQuery();
            while (rs.next()) {
                for (int i = 1; i <= columns.size(); ++i) {
                    statementTrg.setString(i, rs.getString(i));
                }
                statementTrg.execute();
            }
            rs.close();
            statementSrc.close();
            statementTrg.close();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
            try {
                if (statementSrc != null) {
                    statementSrc.close();
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
            try {
                if (statementTrg != null) {
                    statementTrg.close();
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    private void copyTableData() throws DatabaseException {
        for (String table : this.tables) {
            this.copyTable(table);
        }
    }

    public void exportDatabse() throws DatabaseException {
        this.createTables();
        this.copyTableData();
    }
}

