/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db.datamover;

import edu.cmu.lti.jawjaw.db.datamover.DataMover;
import edu.cmu.lti.jawjaw.db.datamover.DatabaseException;
import edu.cmu.lti.jawjaw.db.datamover.SQLite;
import java.sql.Connection;

public class DataMoverUtility {
    public static void copyDB(String sourceDriver, String sourceURL, String targetDriver, String targetURL) {
        try {
            DataMover mover = new DataMover();
            SQLite source = new SQLite();
            source.connect(sourceDriver, sourceURL);
            SQLite target = new SQLite();
            target.connect(targetDriver, targetURL);
            mover.setSource(source);
            mover.setTarget(target);
            mover.exportDatabse();
            source.close();
            target.close();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public static Connection getMemoryDBConnection(String sourceDriver, String sourceURL) {
        Connection connection = null;
        String targetURL = "jdbc:sqlite::memory:";
        try {
            DataMover mover = new DataMover();
            SQLite source = new SQLite();
            source.connect(sourceDriver, sourceURL);
            SQLite target = new SQLite();
            target.connect(sourceDriver, targetURL);
            mover.setSource(source);
            mover.setTarget(target);
            System.out.print("Loading WordNet DB into memory ... ");
            long t0 = System.currentTimeMillis();
            mover.exportDatabse();
            long t1 = System.currentTimeMillis();
            System.out.println("done in " + (double)(t1 - t0) / 1000.0 + " sec.");
            source.close();
            connection = target.getConnection();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return connection;
    }
}

