/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db.datamover;

import edu.cmu.lti.jawjaw.db.datamover.DatabaseException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public abstract class Database {
    protected Connection connection;

    public abstract String processType(String var1, int var2);

    public void connect(String driver, String url) throws DatabaseException {
        try {
            Class.forName(driver).newInstance();
            this.connection = DriverManager.getConnection(url);
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseException(e);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DatabaseException {
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public boolean isNumeric(int type) {
        return type == -5 || type == 3 || type == 8 || type == 6 || type == 4 || type == 2 || type == 5 || type == -6;
    }

    public String generateDrop(String table) {
        StringBuffer result = new StringBuffer();
        result.append("DROP TABLE ");
        result.append(table);
        result.append(";\n");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateCreate(String table) throws DatabaseException {
        StringBuffer result = new StringBuffer();
        ResultSetMetaData md = null;
        Statement stmt = null;
        ResultSet rs = null;
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT * FROM ");
                sql.append(table);
                stmt = this.connection.createStatement();
                rs = stmt.executeQuery(sql.toString());
                md = rs.getMetaData();
                result.append("CREATE TABLE ");
                result.append(table);
                result.append(" ( ");
                for (int i = 1; i <= md.getColumnCount(); ++i) {
                    if (i != 1) {
                        result.append(',');
                    }
                    result.append(md.getColumnName(i));
                    result.append(' ');
                    String type = this.processType(md.getColumnTypeName(i), md.getPrecision(i));
                    result.append(type);
                    if (md.isNullable(i) == 0) {
                        result.append("NOT NULL ");
                    }
                    if (!md.isAutoIncrement(i)) continue;
                    result.append(" auto_increment");
                }
                DatabaseMetaData dbm = this.connection.getMetaData();
                ResultSet primary = dbm.getPrimaryKeys(null, null, table);
                boolean first = true;
                while (primary.next()) {
                    if (first) {
                        first = false;
                        result.append(',');
                        result.append("PRIMARY KEY(");
                    } else {
                        result.append(",");
                    }
                    result.append(primary.getString("COLUMN_NAME"));
                }
                if (!first) {
                    result.append(')');
                }
                result.append(" ); ");
                rs.close();
                stmt.close();
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    throw new DatabaseException(e);
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    throw new DatabaseException(e);
                }
            }
        }
        return result.toString();
    }

    public void execute(String sql) throws DatabaseException {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.execute(sql);
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("Syntax error? in " + sql);
            throw new DatabaseException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Collection<String> listTables() throws DatabaseException {
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData dbm = this.connection.getMetaData();
            String[] types = new String[]{"TABLE"};
            rs = dbm.getTables(null, null, "", types);
            while (rs.next()) {
                String str = rs.getString("TABLE_NAME");
                result.add(str);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    public boolean tableExists(String table) throws DatabaseException {
        boolean result = false;
        ResultSet rs = null;
        try {
            DatabaseMetaData dbm = this.connection.getMetaData();
            String[] types = new String[]{"TABLE"};
            rs = dbm.getTables(null, null, table, types);
            result = rs.next();
            rs.close();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    public Collection<String> listColumns(String table) throws DatabaseException {
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData dbm = this.connection.getMetaData();
            rs = dbm.getColumns(null, null, table, null);
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    public PreparedStatement prepareStatement(String sql) throws DatabaseException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        return statement;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

