/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import javax.swing.JLabel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;

public class CaretMonitor
implements CaretListener {
    private JLabel label;
    private JTextComponent text;
    private String noSelectionFormat = "%d:%d (%d)";
    private String selectionFormat = "%d:%d - %d:%d (%d)";

    public CaretMonitor(JTextComponent jTextComponent, JLabel jLabel) {
        this.label = jLabel;
        this.text = jTextComponent;
        jTextComponent.addCaretListener(this);
        this.updateLabel(jTextComponent.getCaretPosition());
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updateLabel(caretEvent.getDot());
    }

    protected void updateLabel(int n) {
        block5: {
            if (this.text.getDocument() instanceof SyntaxDocument) {
                try {
                    if (this.text.getSelectionStart() == this.text.getSelectionEnd()) {
                        String string = String.format(this.noSelectionFormat, ActionUtils.getLineNumber(this.text, n) + 1, ActionUtils.getColumnNumber(this.text, n) + 1, n);
                        this.label.setText(string);
                        break block5;
                    }
                    int n2 = this.text.getSelectionStart();
                    int n3 = this.text.getSelectionEnd();
                    String string = String.format(this.selectionFormat, ActionUtils.getLineNumber(this.text, n2) + 1, ActionUtils.getColumnNumber(this.text, n2) + 1, ActionUtils.getLineNumber(this.text, n3) + 1, ActionUtils.getColumnNumber(this.text, n3) + 1, n3 - n2, n2, n3);
                    this.label.setText(string);
                }
                catch (BadLocationException badLocationException) {
                    this.label.setText("Ex: " + badLocationException.getMessage());
                }
            } else {
                this.label.setText(String.format(this.noSelectionFormat, 1, 1, 1));
            }
        }
    }

    protected void finalize() throws Throwable {
        this.text.removeCaretListener(this);
        super.finalize();
    }

    public String getNoSelectionFormat() {
        return this.noSelectionFormat;
    }

    public void setNoSelectionFormat(String string) {
        this.noSelectionFormat = string;
    }

    public String getSelectionFormat() {
        return this.selectionFormat;
    }

    public void setSelectionFormat(String string) {
        this.selectionFormat = string;
    }
}

