/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class SmartHomeAction
extends DefaultSyntaxAction {
    public SmartHomeAction() {
        super("smart-home");
    }

    @Override
    public void actionPerformed(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n, ActionEvent actionEvent) {
        try {
            jTextComponent.setCaretPosition(SmartHomeAction.getSmartHomeOffset(jTextComponent, syntaxDocument, n));
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(SmartHomeAction.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
    }

    static int getSmartHomeOffset(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n) throws BadLocationException {
        int n2;
        Element element = syntaxDocument.getParagraphElement(n);
        Segment segment = new Segment();
        syntaxDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset() - 1, segment);
        int n3 = 0;
        int n4 = n - element.getStartOffset();
        boolean bl = false;
        for (n2 = 0; n2 < n4; ++n2) {
            if (Character.isWhitespace(segment.charAt(n2))) continue;
            bl = true;
            break;
        }
        if (n4 == 0 || bl) {
            n2 = segment.first();
            while (n2 != 65535 && Character.isWhitespace((char)n2)) {
                ++n3;
                n2 = segment.next();
            }
        }
        return element.getStartOffset() + n3;
    }
}

