/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class ToggleCommentsAction
extends DefaultSyntaxAction {
    protected String lineCommentStart = "// ";
    protected Pattern lineCommentPattern = null;

    public ToggleCommentsAction() {
        super("toggle-comment");
    }

    @Override
    public void actionPerformed(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n, ActionEvent actionEvent) {
        if (this.lineCommentPattern == null) {
            this.lineCommentPattern = Pattern.compile("(^" + this.lineCommentStart + ")(.*)");
        }
        String[] stringArray = ActionUtils.getSelectedLines(jTextComponent);
        int n2 = jTextComponent.getSelectionStart();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            Matcher matcher = this.lineCommentPattern.matcher(stringArray[i]);
            if (matcher.find()) {
                stringBuffer.append(matcher.replaceFirst("$2"));
            } else {
                stringBuffer.append(this.lineCommentStart);
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append('\n');
        }
        jTextComponent.replaceSelection(stringBuffer.toString());
        jTextComponent.select(n2, n2 + stringBuffer.length());
    }

    public void setLineComments(String string) {
        this.lineCommentStart = string.replace("\"", "");
    }
}

