/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.util.StringUtils;
import jsyntaxpane.util.SwingUtils;

public class ComboCompletionDialog
extends JDialog
implements EscapeListener {
    private String result = null;
    private JTextComponent target;
    public String escapeChars = ";(= \t\n\r";
    public List<String> items;
    private JList jLstItems;
    private JScrollPane jScrollPane1;
    private JTextField jTxtItem;

    public ComboCompletionDialog(JTextComponent jTextComponent) {
        super(SwingUtilities.getWindowAncestor(jTextComponent), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.jTxtItem.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ComboCompletionDialog.this.refilterList();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ComboCompletionDialog.this.refilterList();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ComboCompletionDialog.this.refilterList();
            }
        });
        this.jTxtItem.setFocusTraversalKeysEnabled(false);
        this.target = jTextComponent;
        SwingUtils.addEscapeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFor(String string, List<String> list) {
        this.items = list;
        try {
            Serializable serializable = SwingUtilities.getWindowAncestor(this.target);
            Rectangle rectangle = this.target.modelToView(this.target.getSelectionStart());
            Point point = new Point(rectangle.x, rectangle.y);
            this.setLocationRelativeTo((Component)serializable);
            point = SwingUtilities.convertPoint(this.target, point, serializable);
            SwingUtilities.convertPointToScreen(point, serializable);
            this.setLocation(point);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(ComboCompletionDialog.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        finally {
            Font font = this.target.getFont();
            this.jTxtItem.setFont(font);
            this.jLstItems.setFont(font);
            this.doLayout();
            this.jTxtItem.setText(string);
            this.refilterList();
            this.setVisible(true);
        }
    }

    private void refilterList() {
        String string = this.jTxtItem.getText();
        Vector<String> vector = new Vector<String>();
        Object e = this.jLstItems.getSelectedValue();
        for (String string2 : this.items) {
            if (!StringUtils.camelCaseMatch(string2, string)) continue;
            vector.add(string2);
        }
        this.jLstItems.setListData(vector);
        if (e != null && vector.contains(e)) {
            this.jLstItems.setSelectedValue(e, true);
        } else {
            this.jLstItems.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jTxtItem = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jLstItems = new JList();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setUndecorated(true);
        this.jTxtItem.setBorder(null);
        this.jTxtItem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ComboCompletionDialog.this.jTxtItemKeyPressed(keyEvent);
            }
        });
        this.jLstItems.setSelectionMode(0);
        this.jLstItems.setFocusable(false);
        this.jLstItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ComboCompletionDialog.this.jLstItemsMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jLstItems);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTxtItem, -1, 375, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTxtItem, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 111, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTxtItemKeyPressed(KeyEvent keyEvent) {
        int n = this.jLstItems.getSelectedIndex();
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.result = this.jTxtItem.getText();
                this.target.replaceSelection(this.result);
                this.setVisible(false);
                return;
            }
            case 40: {
                if (n < this.jLstItems.getModel().getSize() - 1) {
                    ++n;
                }
                this.jLstItems.setSelectedIndex(n);
                this.jLstItems.ensureIndexIsVisible(n);
                break;
            }
            case 38: {
                if (n > 0) {
                    --n;
                }
                this.jLstItems.setSelectedIndex(n);
                this.jLstItems.ensureIndexIsVisible(n);
            }
        }
        if (this.escapeChars.indexOf(keyEvent.getKeyChar()) >= 0) {
            this.result = this.jLstItems.getSelectedIndex() >= 0 ? this.jLstItems.getSelectedValue().toString() : this.jTxtItem.getText();
            char c = keyEvent.getKeyChar();
            if (c != '\n') {
                this.result = this.result + (c == '\t' ? (char)' ' : (char)c);
            }
            this.target.replaceSelection(this.result);
            this.setVisible(false);
        }
    }

    private void jLstItemsMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            String string = this.jLstItems.getSelectedValue().toString();
            this.target.replaceSelection(string);
            this.setVisible(false);
        }
    }

    @Override
    public void escapePressed() {
        this.setVisible(false);
    }
}

