/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class HTMLPreviewFrame
extends JFrame
implements DocumentListener {
    Document doc;
    private JEditorPane jEdtHtml;
    private JScrollPane jScrollPane1;

    public HTMLPreviewFrame(Document document) {
        this.initComponents();
        this.doc = document;
        document.addDocumentListener(this);
        this.updateHTML();
    }

    private void updateHTML() {
        try {
            this.jEdtHtml.setText(this.doc.getText(0, this.doc.getLength()));
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(HTMLPreviewFrame.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jEdtHtml = new JEditorPane();
        this.setDefaultCloseOperation(2);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jsyntaxpane/Bundle");
        this.setTitle(resourceBundle.getString("HTMLPreviewFrame.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                HTMLPreviewFrame.this.onWindowClosed(windowEvent);
            }
        });
        this.jEdtHtml.setContentType(resourceBundle.getString("HTMLPreviewFrame.jEdtHtml.contentType"));
        this.jEdtHtml.setEditable(false);
        this.jScrollPane1.setViewportView(this.jEdtHtml);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 688, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 449, Short.MAX_VALUE));
        this.pack();
    }

    private void onWindowClosed(WindowEvent windowEvent) {
        this.doc.removeDocumentListener(this);
        this.doc.putProperty("html-preview-window", null);
        this.doc = null;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateHTML();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateHTML();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateHTML();
    }
}

