/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.DocumentSearchData;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.components.Markers;
import jsyntaxpane.util.SwingUtils;

public class QuickFindDialog
extends JDialog
implements DocumentListener,
ActionListener,
EscapeListener {
    private Markers.SimpleMarker marker = new Markers.SimpleMarker(Color.PINK);
    private WeakReference<JTextComponent> target;
    private WeakReference<DocumentSearchData> dsd;
    private int oldCaretPosition;
    private boolean escaped = false;
    private JButton jBtnNext;
    private JButton jBtnPrev;
    private JCheckBox jChkIgnoreCase;
    private JCheckBox jChkRegExp;
    private JCheckBox jChkWrap;
    private JLabel jLabel1;
    private JLabel jLblStatus;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar jToolBar1;
    private JTextField jTxtFind;

    public QuickFindDialog(JTextComponent jTextComponent, DocumentSearchData documentSearchData) {
        super(SwingUtilities.getWindowAncestor(jTextComponent), Dialog.ModalityType.MODELESS);
        this.initComponents();
        SwingUtils.addEscapeListener(this);
        this.dsd = new WeakReference<DocumentSearchData>(documentSearchData);
    }

    public void showFor(final JTextComponent jTextComponent) {
        this.oldCaretPosition = jTextComponent.getCaretPosition();
        Container container = jTextComponent.getParent();
        Dimension dimension = this.getSize();
        dimension.width = jTextComponent.getVisibleRect().width;
        Point point = new Point(0, container.getHeight());
        this.setSize(dimension);
        this.setLocationRelativeTo(container);
        SwingUtilities.convertPointToScreen(point, container);
        this.setLocation(point);
        this.jTxtFind.setFont(jTextComponent.getFont());
        this.jTxtFind.getDocument().addDocumentListener(this);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                jTextComponent.getDocument().removeDocumentListener(QuickFindDialog.this);
                Markers.removeMarkers(jTextComponent, QuickFindDialog.this.marker);
                if (QuickFindDialog.this.escaped) {
                    try {
                        Rectangle rectangle = jTextComponent.modelToView(QuickFindDialog.this.oldCaretPosition);
                        jTextComponent.setCaretPosition(QuickFindDialog.this.oldCaretPosition);
                        jTextComponent.scrollRectToVisible(rectangle);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                QuickFindDialog.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        this.target = new WeakReference<JTextComponent>(jTextComponent);
        Pattern pattern = ((DocumentSearchData)this.dsd.get()).getPattern();
        if (pattern != null) {
            this.jTxtFind.setText(pattern.pattern());
        }
        this.jChkWrap.setSelected(((DocumentSearchData)this.dsd.get()).isWrap());
        this.setVisible(true);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jSeparator1 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JToolBar.Separator();
        this.jTxtFind = new JTextField();
        this.jSeparator3 = new JToolBar.Separator();
        this.jBtnPrev = new JButton();
        this.jBtnNext = new JButton();
        this.jChkIgnoreCase = new JCheckBox();
        this.jChkRegExp = new JCheckBox();
        this.jChkWrap = new JCheckBox();
        this.jSeparator4 = new JToolBar.Separator();
        this.jLblStatus = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.darkGray);
        this.setName("QuickFindDialog");
        this.setResizable(false);
        this.setUndecorated(true);
        this.jToolBar1.setBorder(BorderFactory.createEtchedBorder());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.add(this.jSeparator1);
        this.jLabel1.setLabelFor(this.jTxtFind);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jsyntaxpane/Bundle");
        this.jLabel1.setText(resourceBundle.getString("QuickFindDialog.jLabel1.text"));
        this.jToolBar1.add(this.jLabel1);
        this.jToolBar1.add(this.jSeparator2);
        this.jTxtFind.setColumns(30);
        this.jTxtFind.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jTxtFind.setMaximumSize(new Dimension(200, 24));
        this.jTxtFind.setMinimumSize(new Dimension(60, 24));
        this.jToolBar1.add(this.jTxtFind);
        this.jToolBar1.add(this.jSeparator3);
        this.jBtnPrev.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/go-up.png")));
        this.jBtnPrev.setFocusable(false);
        this.jBtnPrev.setHorizontalTextPosition(0);
        this.jBtnPrev.setOpaque(false);
        this.jBtnPrev.setVerticalTextPosition(3);
        this.jBtnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuickFindDialog.this.jBtnPrevActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jBtnPrev);
        this.jBtnNext.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/go-down.png")));
        this.jBtnNext.setFocusable(false);
        this.jBtnNext.setHorizontalTextPosition(0);
        this.jBtnNext.setMargin(new Insets(2, 2, 2, 2));
        this.jBtnNext.setOpaque(false);
        this.jBtnNext.setVerticalTextPosition(3);
        this.jBtnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuickFindDialog.this.jBtnNextActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jBtnNext);
        this.jChkIgnoreCase.setMnemonic('C');
        this.jChkIgnoreCase.setText(resourceBundle.getString("QuickFindDialog.jChkIgnoreCase.text"));
        this.jChkIgnoreCase.setFocusable(false);
        this.jChkIgnoreCase.setOpaque(false);
        this.jChkIgnoreCase.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jChkIgnoreCase);
        this.jChkIgnoreCase.addActionListener(this);
        this.jChkRegExp.setMnemonic('R');
        this.jChkRegExp.setText(resourceBundle.getString("QuickFindDialog.jChkRegExp.text"));
        this.jChkRegExp.setFocusable(false);
        this.jChkRegExp.setOpaque(false);
        this.jChkRegExp.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jChkRegExp);
        this.jChkRegExp.addActionListener(this);
        this.jChkWrap.setMnemonic('W');
        this.jChkWrap.setText(resourceBundle.getString("QuickFindDialog.jChkWrap.text"));
        this.jChkWrap.setFocusable(false);
        this.jChkWrap.setOpaque(false);
        this.jChkWrap.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jChkWrap);
        this.jChkWrap.addActionListener(this);
        this.jToolBar1.add(this.jSeparator4);
        this.jLblStatus.setFont(this.jLblStatus.getFont().deriveFont(this.jLblStatus.getFont().getStyle() | 1, this.jLblStatus.getFont().getSize() - 2));
        this.jLblStatus.setForeground(Color.red);
        this.jToolBar1.add(this.jLblStatus);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 684, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -2, -1, -2));
        this.pack();
    }

    private void jBtnNextActionPerformed(ActionEvent actionEvent) {
        if (((DocumentSearchData)this.dsd.get()).doFindNext((JTextComponent)this.target.get())) {
            this.jLblStatus.setText(null);
        } else {
            this.jLblStatus.setText(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("QuickFindDialog.NotFound"));
        }
    }

    private void jBtnPrevActionPerformed(ActionEvent actionEvent) {
        if (((DocumentSearchData)this.dsd.get()).doFindPrev((JTextComponent)this.target.get())) {
            this.jLblStatus.setText(null);
        } else {
            this.jLblStatus.setText(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("QuickFindDialog.NotFound"));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateFind();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateFind();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateFind();
    }

    private void updateFind() {
        JTextComponent jTextComponent = (JTextComponent)this.target.get();
        DocumentSearchData documentSearchData = (DocumentSearchData)this.dsd.get();
        String string = this.jTxtFind.getText();
        if (string == null || string.isEmpty()) {
            this.jLblStatus.setText(null);
            return;
        }
        try {
            documentSearchData.setWrap(this.jChkWrap.isSelected());
            documentSearchData.setPattern(string, this.jChkRegExp.isSelected(), this.jChkIgnoreCase.isSelected());
            this.jLblStatus.setText(null);
            jTextComponent.setCaretPosition(this.oldCaretPosition);
            if (!documentSearchData.doFindNext(jTextComponent)) {
                this.jLblStatus.setText(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("QuickFindDialog.NotFound"));
            } else {
                this.jLblStatus.setText(null);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.jLblStatus.setText(patternSyntaxException.getDescription());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JCheckBox) {
            this.updateFind();
        }
    }

    @Override
    public void escapePressed() {
        this.escaped = true;
        this.setVisible(false);
    }
}

