/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.util;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Configuration
implements Map<String, String> {
    Configuration parent;
    Class clazz;
    Map<String, String> props;
    public static final String[] EMPTY_LIST = new String[0];
    public static final Pattern COMMA_SEPARATOR = Pattern.compile("\\s*,\\s*");
    private static Pattern PARENT_KEY = Pattern.compile("\\$\\{(\\w+)\\}");
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());

    public Configuration(Class clazz, Configuration configuration) {
        this(clazz);
        this.parent = configuration;
    }

    public Configuration(Class clazz) {
        this.clazz = clazz;
    }

    public String getString(String string) {
        String string2 = null;
        if (this.props != null) {
            string2 = this.props.get(string);
        }
        Object object = this.parent;
        while (string2 == null && object != null) {
            string2 = ((Configuration)object).get(string);
            object = ((Configuration)object).parent;
        }
        if (string2 != null) {
            object = PARENT_KEY.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (((Matcher)object).find()) {
                String string3 = ((Matcher)object).group(1);
                String string4 = this.getString(string3);
                if (string3.equals("class_path")) {
                    string4 = this.clazz.getName().replace(".", "/").toLowerCase();
                } else if (string3.equals("class_simpleName")) {
                    string4 = this.clazz.getSimpleName();
                } else {
                    string4 = this.getString(string3);
                    if (string4 == null) {
                        Logger.getLogger(this.getClass().getName()).warning("no value for ${" + string3 + "} is defined");
                    }
                }
                ((Matcher)object).appendReplacement(stringBuffer, string4);
            }
            ((Matcher)object).appendTail(stringBuffer);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public String getString(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("defaultValue cannot be null");
        }
        String string3 = this.getString(string);
        return string3 == null ? string2 : string3;
    }

    public int getInteger(String string, int n) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return n;
        }
        try {
            int n2 = Integer.decode(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            LOG.log(Level.WARNING, null, numberFormatException);
            return n;
        }
    }

    public String[] getPropertyList(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return EMPTY_LIST;
        }
        return COMMA_SEPARATOR.split(string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return bl;
        }
        return Boolean.parseBoolean(string2.trim());
    }

    public Color getColor(String string, Color color) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return color;
        }
        try {
            return Color.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return color;
        }
    }

    @Override
    public void putAll(Map map) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.putAll(map);
    }

    public Set<String> stringPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.parent != null) {
            hashSet.addAll(this.parent.stringPropertyNames());
        }
        if (this.props != null) {
            for (String string : this.props.keySet()) {
                hashSet.add(string.toString());
            }
        }
        return hashSet;
    }

    @Override
    public String put(String string, String string2) {
        String string3;
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        return (string3 = this.props.put(string, string2)) == null ? null : string3.toString();
    }

    @Override
    public int size() {
        return this.props == null ? 0 : this.props.size();
    }

    @Override
    public boolean isEmpty() {
        return this.props == null ? true : this.props.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.props == null ? false : this.props.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.props == null ? false : this.props.containsValue(object);
    }

    @Override
    public String get(Object object) {
        return this.props == null ? null : this.props.get(object);
    }

    @Override
    public String remove(Object object) {
        if (this.props == null) {
            return null;
        }
        String string = this.props.remove(object);
        return string == null ? null : string.toString();
    }

    @Override
    public void clear() {
        if (this.props != null) {
            this.props.clear();
        }
    }

    @Override
    public Set<String> keySet() {
        if (this.props == null) {
            return Collections.EMPTY_SET;
        }
        return this.props.keySet();
    }

    @Override
    public Collection<String> values() {
        if (this.props == null) {
            return Collections.EMPTY_SET;
        }
        return this.props.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.props == null) {
            return Collections.EMPTY_SET;
        }
        return this.props.entrySet();
    }

    public String toString() {
        return "Configuration " + this.clazz + " for " + this.parent;
    }

    public Set<StringKeyMatcher> getKeys(Pattern pattern) {
        HashSet<StringKeyMatcher> hashSet = new HashSet<StringKeyMatcher>();
        Set<String> set = this.stringPropertyNames();
        for (String string : set) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            StringKeyMatcher stringKeyMatcher = new StringKeyMatcher(string, matcher, matcher.groupCount() >= 1 ? matcher.group(1) : null, this.getString(string));
            hashSet.add(stringKeyMatcher);
        }
        return hashSet;
    }

    public static class StringKeyMatcher {
        public final String key;
        public final Matcher matcher;
        public final String group1;
        public final String value;

        private StringKeyMatcher(String string, Matcher matcher, String string2, String string3) {
            this.key = string;
            this.matcher = matcher;
            this.group1 = string2;
            this.value = string3;
        }
    }
}

