/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.test.NetUtilTest;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetUtil {
    private static final String VERSION = "1.1.0";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("NetUtilStrings");
    private static final Logger logger = Logger.getLogger("NetUtil");

    private NetUtil() {
    }

    public static void log(Level level, String string, Throwable throwable) {
        logger.log(level, string, throwable);
    }

    public static void log(Level level, String string) {
        logger.log(level, string);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length == 1) {
            if (stringArray[0].equals("--testTCPClient")) {
                bl = true;
                NetUtilTest.client("tcp");
            } else if (stringArray[0].equals("--testUDPClient")) {
                bl = true;
                NetUtilTest.client("udp");
            } else if (stringArray[0].equals("--testTCPServer")) {
                bl = true;
                NetUtilTest.server("tcp");
            } else if (stringArray[0].equals("--testUDPServer")) {
                bl = true;
                NetUtilTest.server("udp");
            } else if (stringArray[0].equals("--testCodecSpeed")) {
                bl = true;
                NetUtilTest.codecSpeed();
            } else if (stringArray[0].equals("--testPingPong")) {
                bl = true;
                NetUtilTest.pingPong();
            }
        }
        if (!bl) {
            System.err.println("\nNetUtil v1.1.0\n" + NetUtil.getCopyrightString() + "\n\n" + NetUtil.getCreditsString() + "\n\n  " + NetUtil.getResourceString("errIsALibrary"));
            System.out.println("\nThe following demos are available:\n  --testTCPClient\n  --testUDPClient\n  --testTCPServer\n  --testUDPServer\n  --testCodecSpeed\n  --testPingPong\n");
            System.exit(1);
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getCopyrightString() {
        return NetUtil.getResourceString("copyright");
    }

    public static String getCreditsString() {
        return NetUtil.getResourceString("credits");
    }

    public static String getResourceString(String string) {
        try {
            return resBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "[Missing Resource: " + string + "]";
        }
    }
}

