/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.neuralgas.sphere;

import de.sciss.neuralgas.sphere.Loc;
import de.sciss.neuralgas.sphere.Polar;
import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.ModuleSerializationProxy;

public final class Polar$
implements Serializable {
    public static final Polar$ MODULE$ = new Polar$();

    public double centralAngle(Loc n1, Loc n2) {
        return Math.acos(Math.cos(n1.theta()) * Math.cos(n2.theta()) + Math.sin(n1.theta()) * Math.sin(n2.theta()) * Math.cos(n1.phi() - n2.phi()));
    }

    public Polar interpolate(Loc n1, Loc n2, double f) {
        double PiH = 1.5707963267948966;
        double d = this.centralAngle(n1, n2);
        double lat1 = PiH - n1.theta();
        double lon1 = n1.phi();
        double lat2 = PiH - n2.theta();
        double lon2 = n2.phi();
        double sinD = Math.sin(d);
        double a = Math.sin((1.0 - f) * d) / sinD;
        double b = Math.sin(f * d) / sinD;
        double cosLat1 = Math.cos(lat1);
        double cosLon1 = Math.cos(lon1);
        double cosLat2 = Math.cos(lat2);
        double cosLon2 = Math.cos(lon2);
        double sinLat1 = Math.sin(lat1);
        double sinLon1 = Math.sin(lon1);
        double sinLat2 = Math.sin(lat2);
        double sinLon2 = Math.sin(lon2);
        double x = a * cosLat1 * cosLon1 + b * cosLat2 * cosLon2;
        double y = a * cosLat1 * sinLon1 + b * cosLat2 * sinLon2;
        double z = a * sinLat1 + b * sinLat2;
        double lat = Math.atan2(z, Math.sqrt(x * x + y * y));
        double lon = Math.atan2(y, x);
        double theta = PiH - lat;
        double phi = lon;
        return new Polar(theta, phi);
    }

    public Polar apply(double theta, double phi) {
        return new Polar(theta, phi);
    }

    public Option<Tuple2<Object, Object>> unapply(Polar x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2.mcDD.sp(x$0.theta(), x$0.phi()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Polar$.class);
    }

    private Polar$() {
    }
}

