/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.neuralgas.sphere.impl;

import de.sciss.neuralgas.sphere.Edge;
import de.sciss.neuralgas.sphere.Node;
import de.sciss.neuralgas.sphere.SphereGNG;
import de.sciss.neuralgas.sphere.impl.EdgeImpl;
import de.sciss.neuralgas.sphere.impl.LocImpl;
import de.sciss.neuralgas.sphere.impl.LocVarImpl;
import de.sciss.neuralgas.sphere.impl.NodeImpl;
import de.sciss.neuralgas.sphere.impl.SphereGNGImpl$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\ter!B\u0015+\u0011\u0003)d!B\u001c+\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005\"B!\u0002\t\u0003\u0011\u0005bB.\u0002\u0005\u0004%i\u0001\u0018\u0005\u0007?\u0006\u0001\u000bQB/\u0007\t\u0001\fa!\u0019\u0005\t\u0011\u001a\u0011)\u0019!C\u0001E\"A1M\u0002B\u0001B\u0003%\u0011\nC\u0003@\r\u0011\u0005A\r\u0003\u0004i\r\u0001\u0006I!\u001b\u0005\u0007Y\u001a\u0001\u000b\u0015B7\t\rA4\u0001\u0015)\u0003n\u0011\u0019\th\u0001)A\u0005e\"1\u0001P\u0002Q\u0001\neD\u0001\"a\u0004\u0007A\u0003%\u0011\u0011\u0003\u0005\t\u0003/1\u0001\u0015!\u0003\u0002\u001a!9\u0011Q\u0005\u0004!B\u0013i\u0007bBA\u0014\r\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003W1A\u0011AA\u0017\u0011\u001d\tID\u0002C\u0001\u0003wAq!!\u0010\u0007\t\u0003\ty\u0004C\u0004\u0002V\u0019!\t!a\u0016\t\u000f\u0005mc\u0001\"\u0001\u0002^!9\u0011\u0011\u000e\u0004\u0005\u0002\u0005-\u0004bBA<\r\u0011%\u0011\u0011\u0010\u0005\b\u0003w2A\u0011BA=\u0011\u001d\tiH\u0002C\u0001\u0003wAq!a \u0007\t\u0003\t\t\tC\u0004\u0002\u001c\u001a!\t!!(\t\u000f\u0005\u001df\u0001\"\u0003\u0002*\"9\u0011q\u0016\u0004\u0005\n\u0005E\u0006bBA^\r\u0011%\u0011Q\u0018\u0005\b\u0003\u000f4A\u0011BAe\u0011\u001d\tiM\u0002C\u0005\u0003\u001fDq!!6\u0007\t\u0013\t9\u000eC\u0004\u0003\u0004\u0019!IA!\u0002\t\u000f\t-a\u0001\"\u0003\u0003\u000e!A!1\u0003\u0004!\u0002\u001b\u0011)\u0002C\u0004\u0003\u001a\u0019!IAa\u0007\t\u000f\t=b\u0001\"\u0003\u00032\u0005i1\u000b\u001d5fe\u0016<ejR%na2T!a\u000b\u0017\u0002\t%l\u0007\u000f\u001c\u0006\u0003[9\naa\u001d9iKJ,'BA\u00181\u0003%qW-\u001e:bY\u001e\f7O\u0003\u00022e\u0005)1oY5tg*\t1'\u0001\u0002eK\u000e\u0001\u0001C\u0001\u001c\u0002\u001b\u0005Q#!D*qQ\u0016\u0014Xm\u0012(H\u00136\u0004Hn\u0005\u0002\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005\r;\u0005C\u0001#F\u001b\u0005a\u0013B\u0001$-\u0005%\u0019\u0006\u000f[3sK\u001esu\tC\u0003I\u0007\u0001\u0007\u0011*\u0001\u0004d_:4\u0017n\u001a\t\u0003\u0015bs!a\u0013,\u000f\u00051+fBA'U\u001d\tq5K\u0004\u0002P%6\t\u0001K\u0003\u0002Ri\u00051AH]8pizJ\u0011aM\u0005\u0003cIJ!a\f\u0019\n\u00055r\u0013BA,-\u0003%\u0019\u0006\u000f[3sK\u001esu)\u0003\u0002Z5\n11i\u001c8gS\u001eT!a\u0016\u0017\u0002\u001bM\u0003\u0006*\u0012*F?\u000e{ujS%F+\u0005iv\"\u00010\u001e\tM;ejR\u0001\u000f'BCUIU#`\u0007>{5*S#!\u0005\u0011IU\u000e\u001d7\u0014\u0007\u0019I4)F\u0001J\u0003\u001d\u0019wN\u001c4jO\u0002\"\"!Z4\u0011\u0005\u00194Q\"A\u0001\t\u000b!K\u0001\u0019A%\u0002\u00071|7\r\u0005\u00027U&\u00111N\u000b\u0002\u000b\u0019>\u001cg+\u0019:J[Bd\u0017a\u00038pI\u0016LEmQ8v]R\u0004\"A\u000f8\n\u0005=\\$aA%oi\u0006Aa.^7O_\u0012,7/A\u0003o_\u0012,7\u000fE\u0002;gVL!\u0001^\u001e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Y2\u0018BA<+\u0005!qu\u000eZ3J[Bd\u0017aB3eO\u0016l\u0015\r\u001d\t\u0006u~l\u00171A\u0007\u0002w*\u0011A0`\u0001\b[V$\u0018M\u00197f\u0015\tq8(\u0001\u0006d_2dWm\u0019;j_:L1!!\u0001|\u0005\ri\u0015\r\u001d\t\u0006u\u0006\u0015\u0011\u0011B\u0005\u0004\u0003\u000fY(A\u0002\"vM\u001a,'\u000fE\u00027\u0003\u0017I1!!\u0004+\u0005!)EmZ3J[Bd\u0017!\u00023fG\u0006L\bc\u0001\u001e\u0002\u0014%\u0019\u0011QC\u001e\u0003\r\u0011{WO\u00197f\u0003\r\u0011h\u000e\u001a\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\tiB\u0001\u0004SC:$w.\\\u0001\n?6\f\u0007PT8eKN\f\u0001\"\\1y\u001d>$Wm]\u000b\u0002[\u0006aQ.\u0019=O_\u0012,7o\u0018\u0013fcR!\u0011qFA\u001b!\rQ\u0014\u0011G\u0005\u0004\u0003gY$\u0001B+oSRDa!a\u000e\u0014\u0001\u0004i\u0017!\u0002<bYV,\u0017\u0001B5oSR$\"!a\f\u0002\u0013M\fg/Z*uCR,G\u0003BA\u0018\u0003\u0003Bq!a\u0011\u0016\u0001\u0004\t)%A\u0001g!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n!![8\u000b\u0005\u0005=\u0013\u0001\u00026bm\u0006LA!a\u0015\u0002J\t!a)\u001b7f\u0003%aw.\u00193Ti\u0006$X\r\u0006\u0003\u00020\u0005e\u0003bBA\"-\u0001\u0007\u0011QI\u0001\u000boJLG/Z*uCR,G\u0003BA\u0018\u0003?Bq!!\u0019\u0018\u0001\u0004\t\u0019'A\u0002pkR\u0004B!a\u0012\u0002f%!\u0011qMA%\u00051yU\u000f\u001e9viN#(/Z1n\u0003%\u0011X-\u00193Ti\u0006$X\r\u0006\u0003\u00020\u00055\u0004bBA81\u0001\u0007\u0011\u0011O\u0001\u0003S:\u0004B!a\u0012\u0002t%!\u0011QOA%\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\r5\\gj\u001c3f)\u0005)\u0018\u0001D7l%\u0006tGm\\7O_\u0012,\u0017\u0001B:uKB\fAB\\8eK&#XM]1u_J,\"!a!\u0011\r\u0005\u0015\u0015qRAK\u001d\u0011\t9)a#\u000f\u0007=\u000bI)C\u0001=\u0013\r\tiiO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t*a%\u0003\u0011%#XM]1u_JT1!!$<!\r!\u0015qS\u0005\u0004\u00033c#\u0001\u0002(pI\u0016\fA\"\u001a3hK&#XM]1u_J,\"!a(\u0011\r\u0005\u0015\u0015qRAQ!\r!\u00151U\u0005\u0004\u0003Kc#\u0001B#eO\u0016\f\u0001#\\1y\u000bJ\u0014xN\u001d(fS\u001eD'm\u001c:\u0015\u0007U\fY\u000b\u0003\u0004\u0002.z\u0001\r!^\u0001\u0002]\u0006q\u0011\r\u001a3FI\u001e,\u0017I\u001c3GSJ,GCBA\u0018\u0003g\u000b9\f\u0003\u0004\u00026~\u0001\r!^\u0001\u0005MJ|W\u000e\u0003\u0004\u0002:~\u0001\r!^\u0001\u0003i>\f\u0001$\u001b8tKJ$hj\u001c3f\u0005\u0016$x/Z3o\u0003:$g)\u001b:f)\u0019\ty#a0\u0002D\"1\u0011\u0011\u0019\u0011A\u0002U\f!A\\\u0019\t\r\u0005\u0015\u0007\u00051\u0001v\u0003\tq''A\u000bbO\u0016,EmZ3t\u001f\u001atu\u000eZ3B]\u00124\u0015N]3\u0015\t\u0005=\u00121\u001a\u0005\b\u0003[\u000b\u0003\u0019AAK\u0003E!W\r\\3uK:{G-Z!oI\u001aK'/\u001a\u000b\u0005\u0003_\t\t\u000e\u0003\u0004\u0002T\n\u0002\r!\\\u0001\u0003]&\faA]3n_Z,W\u0003BAm\u0003K$b!a\f\u0002\\\u0006]\bbBAoG\u0001\u0007\u0011q\\\u0001\u0003qN\u0004RA_A\u0003\u0003C\u0004B!a9\u0002f2\u0001AaBAtG\t\u0007\u0011\u0011\u001e\u0002\u0002\u0003F!\u00111^Ay!\rQ\u0014Q^\u0005\u0004\u0003_\\$a\u0002(pi\"Lgn\u001a\t\u0004u\u0005M\u0018bAA{w\t\u0019\u0011I\\=\t\u000f\u0005e8\u00051\u0001\u0002b\u0006!Q\r\\3nQ\r\u0019\u0013Q \t\u0004u\u0005}\u0018b\u0001B\u0001w\t1\u0011N\u001c7j]\u0016\f\u0011\u0003Z3mKR,W\tZ4f\u0003:$g)\u001b:f)\u0011\tyCa\u0002\t\u000f\t%A\u00051\u0001\u0002\n\u0005\tQ-\u0001\reK2,G/Z#eO\u0016\u0014U\r^<fK:\fe\u000e\u001a$je\u0016$b!a\f\u0003\u0010\tE\u0001bBA[K\u0001\u0007\u0011Q\u0013\u0005\b\u0003s+\u0003\u0019AAK\u0003\r\u0001\u0016\u000eS\b\u0003\u0005/\u0001\u0003bP}\"wT#U\u0006G\u0001\nC\u0012\f\u0007\u000f\u001e(pI\u0016$B\"a\f\u0003\u001e\t}!q\u0005B\u0015\u0005[Aa!!,(\u0001\u0004)\bbBAaO\u0001\u0007!\u0011\u0005\t\u0004m\t\r\u0012b\u0001B\u0013U\t9Aj\\2J[Bd\u0007bBAcO\u0001\u0007!\u0011\u0005\u0005\b\u0005W9\u0003\u0019AA\t\u0003\u0005!\u0007bBA\"O\u0001\u0007\u0011\u0011C\u0001\rG\u0016tGO]1m\u0003:<G.\u001a\u000b\u0007\u0003#\u0011\u0019D!\u000e\t\u000f\u0005\u0005\u0007\u00061\u0001\u0003\"!9\u0011Q\u0019\u0015A\u0002\t\u0005\u0002f\u0001\u0015\u0002~\u0002")
public final class SphereGNGImpl {
    public static SphereGNG apply(SphereGNG.Config config) {
        return SphereGNGImpl$.MODULE$.apply(config);
    }

    public static final class Impl
    implements SphereGNG {
        private final SphereGNG.Config config;
        private final LocVarImpl loc;
        private int nodeIdCount;
        private int numNodes;
        private final NodeImpl[] nodes;
        private final Map<Object, Buffer<EdgeImpl>> edgeMap;
        private final double decay;
        private final Random rnd;
        private int _maxNodes;

        @Override
        public SphereGNG.Config config() {
            return this.config;
        }

        @Override
        public int maxNodes() {
            return this._maxNodes;
        }

        @Override
        public void maxNodes_$eq(int value) {
            this._maxNodes = value;
        }

        public void init() {
            NodeImpl n1 = this.mkRandomNode();
            NodeImpl n2 = this.mkRandomNode();
            this.nodes[0] = n1;
            this.nodes[1] = n2;
            this.numNodes = 2;
            this.config().observer().gngNodeInserted(n1);
            this.config().observer().gngNodeInserted(n2);
            this.addEdgeAndFire(n1, n2);
        }

        @Override
        public void saveState(File f) {
            try (FileOutputStream fOut = new FileOutputStream(f);){
                this.writeState(fOut);
            }
        }

        @Override
        public void loadState(File f) {
            try (FileInputStream fIn = new FileInputStream(f);){
                this.readState(fIn);
            }
        }

        @Override
        public void writeState(OutputStream out) {
            DataOutputStream dOut = new DataOutputStream(new BufferedOutputStream(out));
            dOut.writeInt(1397182023);
            dOut.writeInt(this.nodeIdCount);
            dOut.writeInt(this.numNodes);
            for (int i = 0; i < this.numNodes; ++i) {
                NodeImpl n = this.nodes[i];
                dOut.writeInt(n.id());
                dOut.writeDouble(n.theta());
                dOut.writeDouble(n.phi());
                dOut.writeDouble(n.utility());
                dOut.writeDouble(n.error());
                dOut.writeShort(n.numNeighbors());
                for (int j = 0; j < n.numNeighbors(); ++j) {
                    NodeImpl nb = n.neighbor(j);
                    dOut.writeInt(nb.id());
                }
            }
            dOut.writeInt(this.edgeMap.size());
            this.edgeMap.foreach((Function1 & Serializable)x0$1 -> {
                Impl.$anonfun$writeState$1(dOut, x0$1);
                return BoxedUnit.UNIT;
            });
            dOut.flush();
        }

        @Override
        public void readState(InputStream in) {
            int i;
            DataInputStream dIn = new DataInputStream(new BufferedInputStream(in));
            int cookie = dIn.readInt();
            Predef$.MODULE$.require(cookie == 1397182023, (Function0 & Serializable)() -> new StringBuilder(37).append("Unexpected cookie, found ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(cookie))).append(" instead of ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(1397182023))).toString());
            this.nodeIdCount = dIn.readInt();
            this.numNodes = dIn.readInt();
            int[][] neighborData = new int[this.numNodes][];
            Map nodeMap = (Map)Map$.MODULE$.empty();
            for (i = 0; i < this.numNodes; ++i) {
                int id = dIn.readInt();
                NodeImpl n = new NodeImpl(id, this.config().maxNeighbors());
                n.theta_$eq(dIn.readDouble());
                n.phi_$eq(dIn.readDouble());
                n.utility_$eq(dIn.readDouble());
                n.error_$eq(dIn.readDouble());
                this.nodes[i] = n;
                nodeMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n.id())), (Object)n));
                int numNeighbors = dIn.readShort();
                int[] neighbors = new int[numNeighbors];
                neighborData[i] = neighbors;
                for (int j = 0; j < numNeighbors; ++j) {
                    int nbId;
                    neighbors[j] = nbId = dIn.readInt();
                }
            }
            for (i = 0; i < this.numNodes; ++i) {
                int[] neighbors = neighborData[i];
                NodeImpl n = this.nodes[i];
                for (int j = 0; j < neighbors.length; ++j) {
                    int nbId = neighbors[j];
                    NodeImpl nb = (NodeImpl)nodeMap.apply((Object)BoxesRunTime.boxToInteger((int)nbId));
                    n.addNeighbor(nb);
                }
            }
            int edgeMapSz = dIn.readInt();
            this.edgeMap.clear();
            for (i = 0; i < edgeMapSz; ++i) {
                int key = dIn.readInt();
                int numEdges = dIn.readInt();
                Buffer buf = (Buffer)Buffer$.MODULE$.empty();
                for (int j = 0; j < numEdges; ++j) {
                    int fromId = dIn.readInt();
                    int toId = dIn.readInt();
                    int age = dIn.readInt();
                    NodeImpl from = (NodeImpl)nodeMap.apply((Object)BoxesRunTime.boxToInteger((int)fromId));
                    NodeImpl to = (NodeImpl)nodeMap.apply((Object)BoxesRunTime.boxToInteger((int)toId));
                    EdgeImpl e = new EdgeImpl(from, to);
                    e.age_$eq(age);
                    buf.$plus$eq((Object)e);
                }
                this.edgeMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)buf));
            }
        }

        private NodeImpl mkNode() {
            int id = this.nodeIdCount++;
            return new NodeImpl(id, this.config().maxNeighbors());
        }

        /*
         * WARNING - void declaration
         */
        private NodeImpl mkRandomNode() {
            void var1_1;
            NodeImpl res = this.mkNode();
            this.config().pd().poll(this.loc);
            res.updateTri(this.loc.theta(), this.loc.phi());
            return var1_1;
        }

        @Override
        public void step() {
            block9: {
                int i;
                double maxError = Double.NEGATIVE_INFINITY;
                NodeImpl maxErrorN = null;
                double minUtility = Double.POSITIVE_INFINITY;
                int minUtilityIdx = -1;
                double minDist = Double.POSITIVE_INFINITY;
                NodeImpl minDistN = null;
                double nextMinDist = Double.POSITIVE_INFINITY;
                NodeImpl nextMinDistN = null;
                int toDelete = -1;
                this.config().pd().poll(this.loc);
                this.loc.updateTri();
                for (i = 0; i < this.numNodes; ++i) {
                    NodeImpl n = this.nodes[i];
                    if (n.numNeighbors() == 0) {
                        toDelete = i;
                    }
                    double d = this.centralAngle(n, this.loc);
                    n.distance_$eq(d);
                    n.error_$eq(n.error() * this.decay);
                    n.utility_$eq(n.utility() * this.decay);
                    if (d < minDist) {
                        nextMinDist = minDist;
                        nextMinDistN = minDistN;
                        minDist = d;
                        minDistN = n;
                    } else if (d < nextMinDist) {
                        nextMinDist = d;
                        nextMinDistN = n;
                    }
                    if (n.error() > maxError) {
                        maxError = n.error();
                        maxErrorN = n;
                    }
                    if (!(n.utility() < minUtility)) continue;
                    minUtility = n.utility();
                    minUtilityIdx = i;
                }
                NodeImpl winner = minDistN;
                this.adaptNode(winner, winner, this.loc, winner.distance(), this.config().epsilon());
                winner.error_$eq(winner.error() + minDist);
                winner.utility_$eq(winner.utility() + (nextMinDist - minDist));
                this.config().observer().gngNodeUpdated(winner);
                int numNb = winner.numNeighbors();
                for (i = 0; i < numNb; ++i) {
                    NodeImpl nb = winner.neighbor(i);
                    Predef$.MODULE$.assert(nb != null);
                    this.adaptNode(nb, nb, this.loc, nb.distance(), this.config().epsilon2());
                    this.config().observer().gngNodeUpdated(nb);
                }
                NodeImpl nodeImpl = minDistN;
                NodeImpl nodeImpl2 = nextMinDistN;
                if (nodeImpl == null ? nodeImpl2 != null : !nodeImpl.equals(nodeImpl2)) {
                    this.addEdgeAndFire(minDistN, nextMinDistN);
                }
                this.ageEdgesOfNodeAndFire(minDistN);
                if (this.rnd.nextDouble() < this.config().lambda() && this.numNodes < this._maxNodes) {
                    this.insertNodeBetweenAndFire(maxErrorN, this.maxErrorNeighbor(maxErrorN));
                }
                if (this.numNodes <= 2 || this.numNodes <= this._maxNodes && !(maxError > minUtility * this.config().utility())) break block9;
                this.deleteNodeAndFire(minUtilityIdx);
            }
        }

        @Override
        public Iterator<Node> nodeIterator() {
            return ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])this.nodes)).take(this.numNodes);
        }

        @Override
        public Iterator<Edge> edgeIterator() {
            return this.edgeMap.valuesIterator().flatMap((Function1 & Serializable)buf -> buf.iterator().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends EdgeImpl, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1.from().id() < A1.to().id() ? A1 : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(EdgeImpl x1) {
                    EdgeImpl edgeImpl = x1;
                    boolean bl = edgeImpl.from().id() < edgeImpl.to().id();
                    return bl;
                }
            }));
        }

        private NodeImpl maxErrorNeighbor(NodeImpl n) {
            double resErr = Double.NEGATIVE_INFINITY;
            NodeImpl res = n;
            int nNb = n.numNeighbors();
            for (int i = 0; i < nNb; ++i) {
                NodeImpl nb = n.neighbor(i);
                if (!(nb.error() > resErr)) continue;
                resErr = nb.error();
                res = nb;
            }
            return res;
        }

        private void addEdgeAndFire(NodeImpl from, NodeImpl to) {
            block1: {
                block0: {
                    if (!from.isNeighbor(to)) break block0;
                    int fromId = from.id();
                    Buffer buf = (Buffer)this.edgeMap.apply((Object)BoxesRunTime.boxToInteger((int)fromId));
                    EdgeImpl e2 = (EdgeImpl)buf.find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)Impl.$anonfun$addEdgeAndFire$1(fromId, e))).get();
                    if (e2.age() == 0) break block1;
                    e2.age_$eq(0);
                    this.config().observer().gngEdgeUpdated(e2);
                    break block1;
                }
                if (!from.canAddNeighbor() || !to.canAddNeighbor()) break block1;
                from.addNeighbor(to);
                to.addNeighbor(from);
                Buffer bufFrom = (Buffer)this.edgeMap.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)from.id()), (Function0 & Serializable)() -> (Buffer)Buffer$.MODULE$.empty());
                Buffer bufTo = (Buffer)this.edgeMap.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)to.id()), (Function0 & Serializable)() -> (Buffer)Buffer$.MODULE$.empty());
                EdgeImpl e3 = new EdgeImpl(from, to);
                bufFrom.$plus$eq((Object)e3);
                bufTo.$plus$eq((Object)e3);
                this.config().observer().gngEdgeInserted(e3);
            }
        }

        private void insertNodeBetweenAndFire(NodeImpl n1, NodeImpl n2) {
            NodeImpl n = this.mkNode();
            double alphaDecay = 1.0 - this.config().alpha();
            n1.error_$eq(n1.error() * alphaDecay);
            n2.error_$eq(n2.error() * alphaDecay);
            n.error_$eq((n1.error() + n2.error()) / 2.0);
            n.utility_$eq((n1.utility() + n2.utility()) / 2.0);
            double d = this.centralAngle(n1, n2);
            this.adaptNode(n, n1, n2, d, 0.5);
            this.deleteEdgeBetweenAndFire(n1, n2);
            int numOld = this.numNodes;
            this.nodes[numOld] = n;
            this.numNodes = numOld + 1;
            this.config().observer().gngNodeInserted(n);
            this.addEdgeAndFire(n1, n);
            this.addEdgeAndFire(n2, n);
        }

        private void ageEdgesOfNodeAndFire(Node n) {
            Buffer edges = (Buffer)this.edgeMap.apply((Object)BoxesRunTime.boxToInteger((int)n.id()));
            edges.foreach((Function1 & Serializable)e -> {
                Impl.$anonfun$ageEdgesOfNodeAndFire$1(this, e);
                return BoxedUnit.UNIT;
            });
        }

        private void deleteNodeAndFire(int ni) {
            int numNew;
            NodeImpl n = this.nodes[ni];
            int nNb = n.numNeighbors();
            for (int i = 0; i < nNb; ++i) {
                this.deleteEdgeBetweenAndFire(n, n.neighbor(0));
            }
            this.numNodes = numNew = this.numNodes - 1;
            this.nodes[ni] = this.nodes[numNew];
            this.nodes[numNew] = null;
            this.edgeMap.remove((Object)BoxesRunTime.boxToInteger((int)n.id()));
            this.config().observer().gngNodeRemoved(n);
        }

        private <A> void remove(Buffer<A> xs, A elem) {
            xs.remove(xs.indexOf(elem));
        }

        private void deleteEdgeAndFire(EdgeImpl e) {
            e.from().removeNeighbor(e.to());
            e.to().removeNeighbor(e.from());
            int fromId = e.from().id();
            int toId = e.to().id();
            this.remove((Buffer)this.edgeMap.apply((Object)BoxesRunTime.boxToInteger((int)fromId)), e);
            this.remove((Buffer)this.edgeMap.apply((Object)BoxesRunTime.boxToInteger((int)toId)), e);
            this.config().observer().gngEdgeRemoved(e);
        }

        private void deleteEdgeBetweenAndFire(Node from, Node to) {
            int fromId = from.id();
            Buffer buf = (Buffer)this.edgeMap.apply((Object)BoxesRunTime.boxToInteger((int)from.id()));
            Option eOpt = buf.find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)Impl.$anonfun$deleteEdgeBetweenAndFire$1(fromId, e)));
            eOpt.foreach((Function1 & Serializable)e -> {
                this.deleteEdgeAndFire(e);
                return BoxedUnit.UNIT;
            });
        }

        private void adaptNode(NodeImpl n, LocImpl n1, LocImpl n2, double d, double f) {
            if (d == 0.0) {
                n.updateTri(n1.theta(), n1.phi());
                return;
            }
            double lon1 = n1.phi();
            double lon2 = n2.phi();
            double sinD = Math.sin(d);
            double a = Math.sin((1.0 - f) * d) / sinD;
            double b = f == 0.5 ? a : Math.sin(f * d) / sinD;
            double cosLat1 = n1.sinTheta();
            double cosLon1 = Math.cos(lon1);
            double cosLat2 = n2.sinTheta();
            double cosLon2 = Math.cos(lon2);
            double sinLat1 = n1.cosTheta();
            double sinLon1 = Math.sin(lon1);
            double sinLat2 = n2.cosTheta();
            double sinLon2 = Math.sin(lon2);
            double aCosLat1 = a * cosLat1;
            double bCosLat2 = b * cosLat2;
            double x = aCosLat1 * cosLon1 + bCosLat2 * cosLon2;
            double y = aCosLat1 * sinLon1 + bCosLat2 * sinLon2;
            double z = a * sinLat1 + b * sinLat2;
            double lat = Math.atan2(z, Math.sqrt(x * x + y * y));
            double lon = Math.atan2(y, x);
            double theta = 1.5707963267948966 - lat;
            double phi = lon;
            n.updateTri(theta, phi);
        }

        private double centralAngle(LocImpl n1, LocImpl n2) {
            return Math.acos(n1.cosTheta() * n2.cosTheta() + n1.sinTheta() * n2.sinTheta() * Math.cos(n1.phi() - n2.phi()));
        }

        public static final /* synthetic */ void $anonfun$writeState$2(DataOutputStream dOut$1, EdgeImpl e) {
            dOut$1.writeInt(e.from().id());
            dOut$1.writeInt(e.to().id());
            dOut$1.writeInt(e.age());
        }

        public static final /* synthetic */ void $anonfun$writeState$1(DataOutputStream dOut$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            Buffer buf = (Buffer)tuple2._2();
            dOut$1.writeInt(id);
            dOut$1.writeInt(buf.size());
            buf.foreach((Function1 & Serializable)e -> {
                Impl.$anonfun$writeState$2(dOut$1, e);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ boolean $anonfun$addEdgeAndFire$1(int fromId$1, EdgeImpl e) {
            return e.from().id() == fromId$1 || e.to().id() == fromId$1;
        }

        public static final /* synthetic */ void $anonfun$ageEdgesOfNodeAndFire$1(Impl $this, EdgeImpl e) {
            e.age_$eq(e.age() + 1);
            if (e.age() <= $this.config().maxEdgeAge()) {
                $this.config().observer().gngEdgeUpdated(e);
            } else {
                $this.deleteEdgeAndFire(e);
            }
        }

        public static final /* synthetic */ boolean $anonfun$deleteEdgeBetweenAndFire$1(int fromId$2, EdgeImpl e) {
            return e.from().id() == fromId$2 || e.to().id() == fromId$2;
        }

        public Impl(SphereGNG.Config config) {
            this.config = config;
            this.loc = new LocVarImpl();
            this.nodeIdCount = 0;
            this.numNodes = 0;
            this.nodes = new NodeImpl[config.maxNodes0()];
            this.edgeMap = (Map)Map$.MODULE$.empty();
            this.decay = 1.0 - config.beta();
            this.rnd = new Random(config.seed());
            this._maxNodes = config.maxNodes0();
        }
    }
}

