/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.virtualkeyboard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class VirtualKeyboard
extends JPanel {
    private final Key CAPS_LOCK_KEY = new Key(20, "\u21ea", true);
    private final Key SHIFT_KEY = new Key(16, "\u21e7", true);
    private final Key ACUTE_KEY = new Key(129, "\u00b4", "\u00b4", false, 0);
    private final Key GRAVE_KEY = new Key(128, "`", "`", false, 0);
    private final Key TILDE_KEY = new Key(131, "~", "~", false, 0);
    private final Key CIRCUMFLEX_KEY = new Key(130, "^", "^", false, 0);
    private final Key DIAERESIS_KEY = new Key(135, "\"", "\"", false, 0);
    private Key[] row1 = new Key[]{new Key(192, "`", "~"), new Key(49, "1", "!"), new Key(50, "2", "@"), new Key(51, "3", "#"), new Key(52, "4", "$"), new Key(53, "5", "%"), new Key(54, "6", "^"), new Key(55, "7", "&"), new Key(56, "8", "*"), new Key(57, "9", "("), new Key(48, "0", ")"), new Key(45, "-", "_")};
    private Key[] row2 = new Key[]{new Key(81, "q", "Q"), new Key(87, "w", "W"), new Key(69, "e", "E"), new Key(82, "r", "R"), new Key(84, "t", "T"), new Key(89, "y", "Y"), new Key(85, "u", "U"), new Key(73, "i", "I"), new Key(79, "o", "O"), new Key(80, "p", "P"), new Key(161, "[", "{"), new Key(162, "]", "}")};
    private Key[] row3 = new Key[]{new Key(65, "a", "A"), new Key(83, "s", "S"), new Key(68, "d", "D"), new Key(70, "f", "F"), new Key(71, "g", "G"), new Key(72, "h", "H"), new Key(74, "j", "J"), new Key(75, "k", "K"), new Key(76, "l", "L"), new Key(59, ";", ":"), new Key(222, "'", "\""), new Key(61, "=", "+")};
    private Key[] row4 = new Key[]{new Key(90, "z", "Z"), new Key(88, "x", "X"), new Key(67, "c", "C"), new Key(86, "v", "V"), new Key(66, "b", "B"), new Key(78, "n", "N"), new Key(77, "m", "M"), new Key(44, ",", "<"), new Key(46, ".", ">"), new Key(59, ";", ":"), new Key(47, "/", "?"), new Key(92, "\\", "|")};
    private Key[] row5 = new Key[]{this.SHIFT_KEY, this.CAPS_LOCK_KEY, new Key(32, " ", " ", false, 4), new Key(8, "\u232b"), this.ACUTE_KEY, this.GRAVE_KEY, this.TILDE_KEY, this.CIRCUMFLEX_KEY, this.DIAERESIS_KEY};
    private final Map<Key, AbstractButton> buttons = new HashMap<Key, AbstractButton>();
    private Component currentComponent;
    private boolean isCapsLockPressed = false;
    private boolean isShiftPressed = false;
    private Key accentuationBuffer;

    public VirtualKeyboard() {
        super(new GridLayout(5, 1));
        this.add(this.initRow(this.row1));
        this.add(this.initRow(this.row2));
        this.add(this.initRow(this.row3));
        this.add(this.initRow(this.row4));
        this.add(this.initRow(this.row5));
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(e -> {
            String prop = e.getPropertyName();
            if ("focusOwner".equals(prop)) {
                this.currentComponent = (Component)e.getNewValue();
            }
        });
        this.currentComponent = focusManager.getFocusOwner();
    }

    private JPanel initRow(Key[] keys) {
        boolean sizeVaries = false;
        for (Key key : keys) {
            if (key.width <= 1) continue;
            sizeVaries = true;
            break;
        }
        GridBagConstraints cons = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        LayoutManager lay = sizeVaries ? gbl : new GridLayout(1, keys.length);
        cons.ipadx = 0;
        cons.ipady = 0;
        cons.insets.top = 0;
        cons.insets.left = 0;
        cons.insets.bottom = 0;
        cons.insets.right = 0;
        cons.weighty = 1.0;
        cons.fill = 1;
        JPanel p = new JPanel(lay);
        int widthSum = 0;
        for (Key key : keys) {
            widthSum += key.width;
        }
        for (Key key : keys) {
            AbstractButton b;
            if (this.buttons.containsKey(key)) {
                b = this.buttons.get(key);
            } else {
                b = key.isModifier ? new JToggleButton(key.value) : new JButton(key.value);
                b.setFocusable(false);
                b.setFocusPainted(false);
                b.setBorderPainted(false);
                this.buttons.put(key, b);
                b.addActionListener(e -> this.actionListener(key));
            }
            cons.gridwidth = Math.max(1, key.width);
            cons.weightx = (double)key.width / (double)widthSum;
            gbl.setConstraints(b, cons);
            p.add(b);
        }
        return p;
    }

    private void actionListener(Key key) {
        if (!(this.currentComponent instanceof JComponent)) {
            return;
        }
        this.currentComponent.requestFocus();
        JTextComponent currentTextComponent = this.getCurrentTextComponent();
        switch (key.keyCode) {
            case 20: {
                this.capsLockPressed();
                break;
            }
            case 16: {
                this.shiftPressed();
                break;
            }
            case 8: {
                if (currentTextComponent == null) {
                    return;
                }
                this.backspacePressed(currentTextComponent);
                break;
            }
            case 9: {
                this.tabPressed();
                break;
            }
            default: {
                if (currentTextComponent == null) {
                    return;
                }
                this.otherKeyPressed(key, currentTextComponent);
            }
        }
    }

    private void capsLockPressed() {
        this.isCapsLockPressed = !this.isCapsLockPressed;
        this.buttons.forEach((k, b) -> {
            if (k.isLetter() && k.hasShiftValue()) {
                if (this.isCapsLockPressed) {
                    b.setText(k.shiftValue);
                } else {
                    b.setText(k.value);
                }
            }
        });
        AbstractButton b2 = this.buttons.get(this.CAPS_LOCK_KEY);
        b2.setSelected(this.isCapsLockPressed);
    }

    private void shiftPressed() {
        this.isShiftPressed = !this.isShiftPressed;
        this.buttons.forEach((k, b) -> {
            if (k.hasShiftValue()) {
                if (this.isShiftPressed) {
                    b.setText(k.shiftValue);
                } else {
                    b.setText(k.value);
                }
            }
        });
        AbstractButton b2 = this.buttons.get(this.SHIFT_KEY);
        b2.setSelected(this.isShiftPressed);
    }

    private void backspacePressed(JTextComponent component) {
        if (this.currentComponent instanceof JTextComponent) {
            int caretPosition = component.getCaretPosition();
            if (!component.getText().isEmpty() && caretPosition > 0) {
                try {
                    component.setText(component.getText(0, caretPosition - 1) + component.getText(caretPosition, component.getText().length() - caretPosition));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                component.setCaretPosition(caretPosition - 1);
            }
        }
    }

    private void tabPressed() {
        Component nextComponent;
        if (this.currentComponent instanceof JComponent && (nextComponent = ((JComponent)this.currentComponent).getNextFocusableComponent()) != null) {
            nextComponent.requestFocus();
            this.currentComponent = nextComponent;
        }
    }

    private void otherKeyPressed(Key key, JTextComponent currentTextComponent) {
        if (key.isLetter()) {
            String keyString;
            if (this.accentuationBuffer == null) {
                keyString = key.value;
            } else {
                switch (key.keyCode) {
                    case 65: {
                        keyString = this.accentuationBuffer == this.ACUTE_KEY ? "\u00e1" : (this.accentuationBuffer == this.GRAVE_KEY ? "\u00e0" : (this.accentuationBuffer == this.TILDE_KEY ? "\u00e3" : (this.accentuationBuffer == this.CIRCUMFLEX_KEY ? "\u00e2" : (this.accentuationBuffer == this.DIAERESIS_KEY ? "\u00e4" : key.value))));
                        break;
                    }
                    case 69: {
                        keyString = this.accentuationBuffer == this.ACUTE_KEY ? "\u00e9" : (this.accentuationBuffer == this.GRAVE_KEY ? "\u00e8" : (this.accentuationBuffer == this.TILDE_KEY ? "\u1ebd" : (this.accentuationBuffer == this.CIRCUMFLEX_KEY ? "\u00ea" : (this.accentuationBuffer == this.DIAERESIS_KEY ? "\u00eb" : key.value))));
                        break;
                    }
                    case 73: {
                        keyString = this.accentuationBuffer == this.ACUTE_KEY ? "\u00ed" : (this.accentuationBuffer == this.GRAVE_KEY ? "\u00ec" : (this.accentuationBuffer == this.TILDE_KEY ? "\u0129" : (this.accentuationBuffer == this.CIRCUMFLEX_KEY ? "\u00ee" : (this.accentuationBuffer == this.DIAERESIS_KEY ? "\u00ef" : key.value))));
                        break;
                    }
                    case 79: {
                        keyString = this.accentuationBuffer == this.ACUTE_KEY ? "\u00f3" : (this.accentuationBuffer == this.GRAVE_KEY ? "\u00f2" : (this.accentuationBuffer == this.TILDE_KEY ? "\u00f5" : (this.accentuationBuffer == this.CIRCUMFLEX_KEY ? "\u00f4" : (this.accentuationBuffer == this.DIAERESIS_KEY ? "\u00f6" : key.value))));
                        break;
                    }
                    case 85: {
                        keyString = this.accentuationBuffer == this.ACUTE_KEY ? "\u00fa" : (this.accentuationBuffer == this.GRAVE_KEY ? "\u00f9" : (this.accentuationBuffer == this.TILDE_KEY ? "\u0169" : (this.accentuationBuffer == this.CIRCUMFLEX_KEY ? "\u00fb" : (this.accentuationBuffer == this.DIAERESIS_KEY ? "\u00fc" : key.value))));
                        break;
                    }
                    default: {
                        keyString = key.value;
                    }
                }
                this.accentuationBuffer = null;
            }
            if (this.isCapsLockPressed) {
                keyString = keyString.toUpperCase();
                if (this.isShiftPressed) {
                    this.shiftPressed();
                }
            } else if (this.isShiftPressed) {
                keyString = keyString.toUpperCase();
                this.shiftPressed();
            }
            this.addText(currentTextComponent, keyString);
        } else if (key.isDead()) {
            this.accentuationBuffer = key;
        } else {
            String keyString;
            if (this.isCapsLockPressed) {
                keyString = key.value.toUpperCase();
                if (this.isShiftPressed) {
                    this.shiftPressed();
                }
            } else if (this.isShiftPressed) {
                keyString = key.shiftValue;
                this.shiftPressed();
            } else {
                keyString = key.value;
            }
            this.addText(currentTextComponent, keyString);
        }
    }

    private JTextComponent getCurrentTextComponent() {
        if (this.currentComponent instanceof JTextComponent) {
            return (JTextComponent)this.currentComponent;
        }
        return null;
    }

    private void addText(JTextComponent component, String text) {
        int caretPosition = component.getCaretPosition();
        try {
            component.setText(component.getText(0, caretPosition) + text + component.getText(caretPosition, component.getText().length() - caretPosition));
            component.setCaretPosition(caretPosition + 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private class Key {
        public final int keyCode;
        public final String value;
        public final String shiftValue;
        public final boolean isModifier;
        public final int width;

        public Key(int keyCode, String value, String shiftValue, boolean isModifier, int width) {
            this.keyCode = keyCode;
            this.value = value;
            this.shiftValue = shiftValue;
            this.isModifier = isModifier;
            this.width = width;
        }

        public Key(int keyCode, String value, String shiftValue, boolean isModifier) {
            this(keyCode, value, shiftValue, isModifier, 1);
        }

        public Key(int keyCode, String value, String shiftValue) {
            this(keyCode, value, shiftValue, false);
        }

        public Key(int keyCode, String value, boolean isModifier) {
            this(keyCode, value, value, isModifier);
        }

        public Key(int keyCode, String value) {
            this(keyCode, value, value);
        }

        public boolean hasShiftValue() {
            return !this.value.equals(this.shiftValue);
        }

        public boolean isLetter() {
            return this.value.length() == 1 && Character.isLetter(this.value.toCharArray()[0]);
        }

        public boolean isDead() {
            return this.keyCode >= 128 && this.keyCode <= 143;
        }
    }
}

