/*
 * This file is part of WebLookAndFeel library.
 *
 * WebLookAndFeel library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * WebLookAndFeel library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WebLookAndFeel library.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.alee.extended.window;

/**
 * This enumeration represents possible WebPopOver default display locations on the screen.
 *
 * @author Mikle Garin
 * @see WebPopOver
 */

public enum PopOverLocation
{
    /**
     * Center of the screen.
     */
    center,

    /**
     * Top-left corner of the screen.
     */
    topLeft,

    /**
     * Top-right corner of the screen.
     */
    topRight,

    /**
     * Bottom-left corner of the screen.
     */
    bottomLeft,

    /**
     * Bottom-right corner of the screen.
     */
    bottomRight,

    /**
     * Top center of the screen.
     */
    topCenter,

    /**
     * Bottom center of the screen.
     */
    bottomCenter,

    /**
     * Left center of the screen.
     */
    leftCenter,

    /**
     * Right center of the screen.
     */
    rightCenter,
}