/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.checkbox;

import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;

@XStreamAlias(value="MixedIcon")
public class MixedIcon<E extends WebTristateCheckBox, D extends IDecoration<E, D>, I extends MixedIcon<E, D, I>>
extends AbstractContent<E, D, I> {
    @XStreamAsAttribute
    protected Integer round;
    @XStreamAsAttribute
    protected Color leftColor;
    @XStreamAsAttribute
    protected Color rightColor;

    public String getId() {
        return "mixed";
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d) {
        int x = bounds.x + 2;
        int y = bounds.y + 2;
        int w = bounds.width - 4;
        int h = bounds.height - 4;
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(x, y, w, h, this.round.intValue(), this.round.intValue());
        GradientPaint paint = new GradientPaint(x, 0.0f, this.leftColor, x + w, 0.0f, this.rightColor);
        Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)paint);
        g2d.fill(shape);
        GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
    }

    public I merge(I icon) {
        if (((MixedIcon)icon).round != null) {
            this.round = ((MixedIcon)icon).round;
        }
        if (((MixedIcon)icon).leftColor != null) {
            this.leftColor = ((MixedIcon)icon).leftColor;
        }
        if (((MixedIcon)icon).rightColor != null) {
            this.rightColor = ((MixedIcon)icon).rightColor;
        }
        return (I)this;
    }
}

