/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.extended.date.AdaptiveDateFieldPainter;
import com.alee.extended.date.DateFieldPainter;
import com.alee.extended.date.DateFieldUI;
import com.alee.extended.date.DateListener;
import com.alee.extended.date.IDateFieldPainter;
import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateField;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.button.WebButton;
import com.alee.laf.text.WebFormattedTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CompareUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.DataRunnable;
import com.alee.utils.swing.FocusEventRunnable;
import com.alee.utils.swing.KeyEventRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebDateFieldUI
extends DateFieldUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport,
PropertyChangeListener {
    @DefaultPainter(value=DateFieldPainter.class)
    protected IDateFieldPainter painter;
    protected WebFormattedTextField field;
    protected WebButton button;
    protected WebPopOver popup;
    protected WebCalendar calendar;
    protected WebDateField dateField;
    protected Insets margin = null;
    protected Insets padding = null;
    protected boolean updating = false;

    public static ComponentUI createUI(JComponent c) {
        return new WebDateFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.dateField = (WebDateField)c;
        this.installComponents();
        this.installActions();
        StyleManager.installSkin(this.dateField);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.dateField);
        this.uninstallActions();
        this.uninstallComponents();
        this.dateField.removePropertyChangeListener(this);
        this.dateField = null;
        super.uninstallUI(c);
    }

    protected void installComponents() {
        SwingUtils.setHandlesEnableStateMark(this.dateField);
        this.dateField.setLayout(new BorderLayout(0, 0));
        this.field = new WebFormattedTextField(StyleId.datefieldField.at(this.dateField));
        this.dateField.add((Component)this.field, "Center");
        ImageIcon icon = ImageUtils.getImageIcon((URL)WebDateFieldUI.class.getResource("icons/date.png"));
        this.button = new WebButton(StyleId.datefieldButton.at(this.dateField), (Icon)icon);
        this.dateField.add((Component)this.button, "After");
    }

    protected void uninstallComponents() {
        this.dateField.removeAll();
        this.dateField.revalidate();
        this.dateField.repaint();
        this.calendar = null;
        this.popup = null;
        this.button = null;
        this.field = null;
        SwingUtils.removeHandlesEnableStateMark(this.dateField);
    }

    protected void installActions() {
        this.dateField.addPropertyChangeListener(this);
        this.updateExpectedFieldLength();
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDateFieldUI.this.setDate(WebDateFieldUI.this.getDate(WebDateFieldUI.this.field.getText()), UpdateSource.field);
            }
        });
        this.field.onFocusLoss(new FocusEventRunnable(){

            @Override
            public void run(FocusEvent e) {
                Date date = WebDateFieldUI.this.getDate(WebDateFieldUI.this.field.getText());
                if (!CompareUtils.equals((Object)date, (Object[])new Object[]{WebDateFieldUI.this.dateField.getDate()})) {
                    WebDateFieldUI.this.setDate(date, UpdateSource.field);
                } else {
                    WebDateFieldUI.this.field.setText(WebDateFieldUI.this.getText(date));
                }
            }
        });
        this.field.onKeyPress(Hotkey.DOWN, new KeyEventRunnable(){

            @Override
            public void run(KeyEvent e) {
                WebDateFieldUI.this.showDateChooserPopup();
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDateFieldUI.this.showDateChooserPopup();
            }
        });
    }

    protected void uninstallActions() {
        this.dateField.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"allowUserInput"})) {
            this.field.setEditable((Boolean)evt.getNewValue());
        }
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"enabled"})) {
            this.updateEnabledState();
        }
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"dateFormat"})) {
            this.updateExpectedFieldLength();
        } else if (CompareUtils.equals((Object)property, (Object[])new Object[]{"date"})) {
            this.setDate(this.dateField.getDate(), UpdateSource.datefield);
        } else if (CompareUtils.equals((Object)property, (Object[])new Object[]{"calendarCustomizer"})) {
            this.customizeCalendar();
        }
    }

    protected void updateEnabledState() {
        this.field.setEnabled(this.dateField.isEnabled());
        this.button.setEnabled(this.dateField.isEnabled());
    }

    protected void updateExpectedFieldLength() {
        DateFormat dateFormat = this.dateField.getDateFormat();
        this.field.setColumns(dateFormat.format(new Date()).length());
    }

    protected void showDateChooserPopup() {
        if (this.popup == null) {
            this.popup = new WebPopOver(StyleId.datefieldPopup.at(this.dateField), this.dateField);
            this.popup.setCloseOnFocusLoss(true);
            this.popup.setMovable(false);
            this.calendar = new WebCalendar(StyleId.datefieldCalendar.at(this.popup), this.dateField.getDate());
            this.calendar.addDateSelectionListener(new DateListener(){

                @Override
                public void dateChanged(Date date) {
                    WebDateFieldUI.this.setDate(date, UpdateSource.calendar);
                    WebDateFieldUI.this.popup.setVisible(false);
                }
            });
            this.popup.add(this.calendar);
            this.customizeCalendar();
        }
        this.popup.show((Component)this.dateField, PopOverDirection.down, PopOverAlignment.centered);
        this.popup.requestFocusInWindow();
    }

    protected void customizeCalendar() {
        if (this.calendar != null && this.dateField.getCalendarCustomizer() != null) {
            this.dateField.getCalendarCustomizer().customize((Object)this.calendar);
        }
    }

    protected void setDate(Date date, UpdateSource source) {
        if (!this.updating) {
            this.updating = true;
            if (source != UpdateSource.datefield) {
                this.dateField.setDate(date);
            }
            if (source != UpdateSource.field) {
                this.field.setText(this.getText(date));
                this.field.setCaretPosition(0);
            } else {
                int pos = this.field.getCaretPosition();
                String text = this.getText(date);
                this.field.setText(text);
                this.field.setCaretPosition(pos <= text.length() ? pos : text.length());
            }
            if (source != UpdateSource.calendar && this.calendar != null) {
                this.calendar.setDate(date);
            }
            this.updating = false;
        }
    }

    protected Date getDate(String text) {
        try {
            DateFormat format = this.dateField.getDateFormat();
            if (text != null && !text.trim().equals("")) {
                return format.parse(text);
            }
            return null;
        }
        catch (Throwable ex) {
            return this.dateField.getDate();
        }
    }

    protected String getText(Date date) {
        return date != null ? this.dateField.getDateFormat().format(date) : "";
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.dateField);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.dateField, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.dateField, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.dateField, new DataRunnable<IDateFieldPainter>(){

            public void run(IDateFieldPainter newPainter) {
                WebDateFieldUI.this.painter = newPainter;
            }
        }, this.painter, painter, IDateFieldPainter.class, AdaptiveDateFieldPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, this.painter);
    }

    protected static enum UpdateSource {
        datefield,
        field,
        calendar;

    }
}

