/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.extended.image.WebDecoratedImageStyle;
import com.alee.managers.style.ShapeProvider;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageFilterUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShadeType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebDecoratedImage
extends JComponent
implements SwingConstants,
ShapeProvider {
    private ImageIcon icon;
    private ImageIcon previewIcon;
    private int horizontalAlignment = WebDecoratedImageStyle.horizontalAlignment;
    private int verticalAlignment = WebDecoratedImageStyle.verticalAlignment;
    private boolean drawBorder = WebDecoratedImageStyle.drawBorder;
    private Color borderColor = WebDecoratedImageStyle.borderColor;
    private boolean drawGlassLayer = WebDecoratedImageStyle.drawGlassLayer;
    private int shadeWidth = WebDecoratedImageStyle.shadeWidth;
    private int round = WebDecoratedImageStyle.round;
    private float blurAlignX = WebDecoratedImageStyle.blurAlignX;
    private float blurAlignY = WebDecoratedImageStyle.blurAlignY;
    private boolean grayscale = WebDecoratedImageStyle.grayscale;
    private boolean blur = WebDecoratedImageStyle.blur;
    private float blurFactor = WebDecoratedImageStyle.blurFactor;
    private boolean zoomBlur = WebDecoratedImageStyle.zoomBlur;
    private float zoomBlurFactor = WebDecoratedImageStyle.zoomBlurFactor;
    private boolean rotationBlur = WebDecoratedImageStyle.rotationBlur;
    private float rotationBlurFactor = WebDecoratedImageStyle.rotationBlurFactor;

    public WebDecoratedImage() {
        this((ImageIcon)null);
    }

    public WebDecoratedImage(String src) {
        this(ImageUtils.loadImage((String)src));
    }

    public WebDecoratedImage(Class nearClass, String src) {
        this(ImageUtils.loadImage((Class)nearClass, (String)src));
    }

    public WebDecoratedImage(Image image) {
        SwingUtils.setOrientation(this);
        this.setImage(image);
    }

    public WebDecoratedImage(ImageIcon icon) {
        SwingUtils.setOrientation(this);
        this.setIcon(icon);
    }

    public ImageIcon getPreviewIcon() {
        return this.previewIcon;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setImage(Image image) {
        this.setImage(image, true);
    }

    public void setImage(Image image, boolean update) {
        this.setIcon(new ImageIcon(image), update);
    }

    public void setIcon(ImageIcon icon) {
        this.setIcon(icon, true);
    }

    public void setIcon(ImageIcon icon, boolean update) {
        this.icon = icon;
        if (update) {
            this.updatePreview();
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.repaint();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.setDrawBorder(drawBorder, true);
    }

    public void setDrawBorder(boolean drawBorder, boolean update) {
        this.drawBorder = drawBorder;
        if (update) {
            this.updatePreview();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.setBorderColor(borderColor, true);
    }

    public void setBorderColor(Color borderColor, boolean update) {
        this.borderColor = borderColor;
        if (update) {
            this.updatePreview();
        }
    }

    public boolean isDrawGlassLayer() {
        return this.drawGlassLayer;
    }

    public void setDrawGlassLayer(boolean drawGlassLayer) {
        this.setDrawGlassLayer(drawGlassLayer, true);
    }

    public void setDrawGlassLayer(boolean drawGlassLayer, boolean update) {
        this.drawGlassLayer = drawGlassLayer;
        if (update) {
            this.updatePreview();
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.setShadeWidth(shadeWidth, true);
    }

    public void setShadeWidth(int shadeWidth, boolean update) {
        this.shadeWidth = shadeWidth;
        if (update) {
            this.updatePreview();
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.setRound(round, true);
    }

    public void setRound(int round, boolean update) {
        this.round = round;
        if (update) {
            this.updatePreview();
        }
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public void setGrayscale(boolean grayscale) {
        this.setGrayscale(grayscale, true);
    }

    public void setGrayscale(boolean grayscale, boolean update) {
        this.grayscale = grayscale;
        if (update) {
            this.updatePreview();
        }
    }

    public boolean isBlur() {
        return this.blur;
    }

    public void setBlur(boolean blur) {
        this.setBlur(blur, true);
    }

    public void setBlur(boolean blur, boolean update) {
        this.blur = blur;
        if (update) {
            this.updatePreview();
        }
    }

    public float getBlurFactor() {
        return this.blurFactor;
    }

    public void setBlurFactor(float blurFactor) {
        this.setBlurFactor(blurFactor, true);
    }

    public void setBlurFactor(float blurFactor, boolean update) {
        this.blurFactor = blurFactor;
        if (update) {
            this.updatePreview();
        }
    }

    public boolean isZoomBlur() {
        return this.zoomBlur;
    }

    public void setZoomBlur(boolean zoomBlur) {
        this.setZoomBlur(zoomBlur, true);
    }

    public void setZoomBlur(boolean zoomBlur, boolean update) {
        this.zoomBlur = zoomBlur;
        if (update) {
            this.updatePreview();
        }
    }

    public float getZoomBlurFactor() {
        return this.zoomBlurFactor;
    }

    public void setZoomBlurFactor(float zoomBlurFactor) {
        this.setZoomBlurFactor(zoomBlurFactor, true);
    }

    public void setZoomBlurFactor(float zoomBlurFactor, boolean update) {
        this.zoomBlurFactor = zoomBlurFactor;
        if (update) {
            this.updatePreview();
        }
    }

    public boolean isRotationBlur() {
        return this.rotationBlur;
    }

    public void setRotationBlur(boolean rotationBlur) {
        this.setRotationBlur(rotationBlur, true);
    }

    public void setRotationBlur(boolean rotationBlur, boolean update) {
        this.rotationBlur = rotationBlur;
        if (update) {
            this.updatePreview();
        }
    }

    public float getRotationBlurFactor() {
        return this.rotationBlurFactor;
    }

    public void setRotationBlurFactor(float rotationBlurFactor) {
        this.setRotationBlurFactor(rotationBlurFactor, true);
    }

    public void setRotationBlurFactor(float rotationBlurFactor, boolean update) {
        this.rotationBlurFactor = rotationBlurFactor;
        if (update) {
            this.updatePreview();
        }
    }

    public float getBlurAlignX() {
        return this.blurAlignX;
    }

    public void setBlurAlignX(float blurAlignX) {
        this.setBlurAlignX(blurAlignX, true);
    }

    public void setBlurAlignX(float blurAlignX, boolean update) {
        this.blurAlignX = blurAlignX;
        if (update) {
            this.updatePreview();
        }
    }

    public float getBlurAlignY() {
        return this.blurAlignY;
    }

    public void setBlurAlignY(float blurAlignY) {
        this.setBlurAlignY(blurAlignY, true);
    }

    public void setBlurAlignY(float blurAlignY, boolean update) {
        this.blurAlignY = blurAlignY;
        if (update) {
            this.updatePreview();
        }
    }

    public void updatePreview() {
        if (this.icon == null) {
            this.previewIcon = null;
            this.repaint();
            return;
        }
        BufferedImage image = ImageUtils.copy((Image)this.icon.getImage());
        if (this.grayscale) {
            ImageFilterUtils.applyGrayscaleFilter((Image)image, (Image)image);
        }
        if (this.blur) {
            ImageFilterUtils.applyGaussianFilter((Image)image, (Image)image, (float)this.blurFactor);
        }
        if (this.zoomBlur && this.rotationBlur) {
            ImageFilterUtils.applyMotionBlurFilter((Image)image, (Image)image, (float)0.0f, (float)0.0f, (float)this.rotationBlurFactor, (float)this.zoomBlurFactor, (float)this.blurAlignX, (float)this.blurAlignY);
        } else if (this.zoomBlur) {
            ImageFilterUtils.applyZoomBlurFilter((Image)image, (Image)image, (float)this.zoomBlurFactor, (float)this.blurAlignX, (float)this.blurAlignY);
        } else if (this.rotationBlur) {
            ImageFilterUtils.applyRotationBlurFilter((Image)image, (Image)image, (float)this.rotationBlurFactor, (float)this.blurAlignX, (float)this.blurAlignY);
        }
        if (this.round > 0) {
            image = ImageUtils.cutImage((Shape)new RoundRectangle2D.Double(0.0, 0.0, this.icon.getIconWidth(), this.icon.getIconHeight(), this.round * 2, this.round * 2), (Image)image);
        }
        if (this.shadeWidth > 0 || this.drawGlassLayer || this.drawBorder) {
            Dimension ps = this.getPreferredSize();
            BufferedImage img = ImageUtils.createCompatibleImage((int)ps.width, (int)ps.height, (int)3);
            Graphics2D g2d = img.createGraphics();
            GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Shape bs = this.getBorderShape();
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)bs, (ShadeType)WebDecoratedImageStyle.shadeType, (Color)new Color(90, 90, 90), (int)this.shadeWidth);
            g2d.drawImage((Image)image, this.shadeWidth, this.shadeWidth, null);
            if (this.drawGlassLayer) {
                g2d.setPaint(new GradientPaint(0.0f, this.shadeWidth, new Color(255, 255, 255, 160), 0.0f, this.shadeWidth + (ps.height - this.shadeWidth * 2) / 2, new Color(255, 255, 255, 32)));
                g2d.fill(this.getGlanceShape());
            }
            if (this.drawBorder) {
                g2d.setPaint(this.borderColor);
                g2d.draw(bs);
            }
            g2d.dispose();
            image = img;
        }
        this.previewIcon = new ImageIcon(image);
        this.repaint();
    }

    private Shape getGlanceShape() {
        Dimension ps = this.getPreferredSize();
        if (this.round > 0) {
            return new RoundRectangle2D.Double(this.shadeWidth, this.shadeWidth, ps.width - this.shadeWidth * 2, (ps.height - this.shadeWidth * 2) / 2, this.round * 2, this.round * 2);
        }
        return new Rectangle(this.shadeWidth, this.shadeWidth, ps.width - this.shadeWidth * 2, (ps.height - this.shadeWidth * 2) / 2);
    }

    private Shape getBorderShape() {
        return this.getBorderShape(0, 0);
    }

    private Shape getBorderShape(int x, int y) {
        Dimension ps = this.getPreferredSize();
        if (this.round > 0) {
            return new RoundRectangle2D.Double(x + this.shadeWidth, y + this.shadeWidth, ps.width - this.shadeWidth * 2 - 1, ps.height - this.shadeWidth * 2 - 1, this.round * 2, this.round * 2);
        }
        return new Rectangle(x + this.shadeWidth, y + this.shadeWidth, ps.width - this.shadeWidth * 2 - 1, ps.height - this.shadeWidth * 2 - 1);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.previewIcon != null) {
            Point location = this.getPreviewLocation();
            g.drawImage(this.previewIcon.getImage(), location.x, location.y, null);
        }
    }

    private Point getPreviewLocation() {
        int width = this.previewIcon.getIconWidth();
        int height = this.previewIcon.getIconHeight();
        int x = this.horizontalAlignment == 2 ? 0 : (this.horizontalAlignment == 4 ? this.getWidth() - width : this.getWidth() / 2 - width / 2);
        int y = this.verticalAlignment == 1 ? 0 : (this.verticalAlignment == 3 ? this.getHeight() - height : this.getHeight() / 2 - height / 2);
        return new Point(x, y);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.icon != null) {
            return new Dimension(this.shadeWidth * 2 + this.icon.getIconWidth(), this.shadeWidth * 2 + this.icon.getIconHeight());
        }
        return new Dimension(0, 0);
    }

    @Override
    public Shape provideShape() {
        Point location = this.getPreviewLocation();
        return this.getBorderShape(location.x, location.y);
    }
}

