/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector.info;

import com.alee.extended.inspector.info.ComponentInfo;
import com.alee.utils.SwingUtils;
import com.alee.utils.xml.InsetsConverter;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class AbstractComponentInfo<T extends Component>
implements ComponentInfo<T> {
    public static final ImageIcon frameType = new ImageIcon(AbstractComponentInfo.class.getResource("icons/frame.png"));
    public static final ImageIcon dialogType = new ImageIcon(AbstractComponentInfo.class.getResource("icons/dialog.png"));
    public static final ImageIcon windowType = new ImageIcon(AbstractComponentInfo.class.getResource("icons/window.png"));
    public static final ImageIcon layeredPaneType = new ImageIcon(AbstractComponentInfo.class.getResource("icons/layeredpane.png"));
    public static final ImageIcon glassPaneType = new ImageIcon(AbstractComponentInfo.class.getResource("icons/glasspane.png"));
    public static final ImageIcon unknownType = new ImageIcon(AbstractComponentInfo.class.getResource("icons/unknown.png"));
    protected static final String visibleColor = "black";
    protected static final String visibleAwtColor = "165,145,70";
    protected static final String hiddenColor = "180,180,180";
    protected static final String styleIdColor = "30,110,30";
    protected static final String marginColor = "190,190,0";
    protected static final String paddingColor = "0,150,70";

    protected String getTitleColor(T component) {
        return ((Component)component).isShowing() ? (component instanceof JComponent ? visibleColor : visibleAwtColor) : hiddenColor;
    }

    protected String renderInsets(Insets insets, String color) {
        if (!SwingUtils.isEmpty(insets)) {
            return " [ {" + InsetsConverter.insetsToString((Insets)insets) + ":b;c(" + color + ")} ]";
        }
        return "";
    }
}

