/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class BreadcrumbLayout
extends AbstractLayoutManager {
    private int overlap;

    public BreadcrumbLayout() {
        this(0);
    }

    public BreadcrumbLayout(int overlap) {
        this.overlap = overlap;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public void setOverlap(int overlap) {
        this.overlap = overlap;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension maxSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Dimension ps = parent.getComponent(i).getPreferredSize();
            maxSize.width = maxSize.width + (ps.width - (i < parent.getComponentCount() - 1 ? this.overlap : 0));
            maxSize.height = Math.max(maxSize.height, insets.top + ps.height + insets.bottom);
        }
        return maxSize;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        if (parent.getComponentOrientation().isLeftToRight()) {
            int x = insets.left;
            for (Component component : parent.getComponents()) {
                Dimension ps = component.getPreferredSize();
                component.setBounds(x, insets.top, ps.width, parent.getHeight() - insets.top - insets.bottom);
                x += ps.width - this.overlap;
            }
        } else {
            int x = parent.getWidth() - insets.right;
            for (Component component : parent.getComponents()) {
                Dimension ps = component.getPreferredSize();
                component.setBounds(x - ps.width, insets.top, ps.width, parent.getHeight() - insets.top - insets.bottom);
                x += this.overlap - ps.width;
            }
        }
    }
}

