/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.optionpane;

import com.alee.extended.image.WebImage;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.layout.TableLayout;
import com.alee.extended.panel.CenterPanel;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.optionpane.WebOptionPaneUI;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebDialog;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;

public class WebExtendedOptionPane
extends WebDialog {
    public static final ImageIcon INFORMATION_ICON = new ImageIcon(WebExtendedOptionPane.class.getResource("icons/information.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(WebExtendedOptionPane.class.getResource("icons/warning.png"));
    public static final ImageIcon ERROR_ICON = new ImageIcon(WebExtendedOptionPane.class.getResource("icons/error.png"));
    public static final ImageIcon QUESTION_ICON = new ImageIcon(WebExtendedOptionPane.class.getResource("icons/question.png"));
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 64;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private final Component parentComponent;
    private int result;
    private final WebPanel container;
    private final WebPanel controls;
    private final WebPanel centered;
    private final WebPanel buttons;
    private WebButton yes;
    private WebButton no;
    private WebButton ok;
    private WebButton cancel;
    private Component specialComponent = null;

    public WebExtendedOptionPane(Component parentComponent, Object message, Object special, String title, int optionType, int messageType) {
        super(SwingUtils.getWindowAncestor((Component)parentComponent), title);
        this.setIconImages(this.getDialogIcons(messageType));
        this.setLayout(new BorderLayout());
        this.parentComponent = parentComponent;
        this.container = new WebPanel((LayoutManager)new BorderLayout(15, 15), new Component[0]);
        this.container.setMargin(15, 15, 8, 15);
        this.add((Component)this.container, "Center");
        ImageIcon typeIcon = this.getLargeIcon(messageType);
        if (typeIcon != null) {
            WebImage image = new WebImage(typeIcon);
            image.setVerticalAlignment(1);
            this.container.add((Component)new CenterPanel(image, false, true), (Object)"West");
        }
        this.setContent(message, false);
        this.controls = new WebPanel((LayoutManager)new BorderLayout(15, 15), new Component[0]);
        this.container.add((Component)this.controls, (Object)"South");
        this.centered = new WebPanel();
        this.controls.add((Component)this.centered, (Object)"Center");
        this.buttons = new WebPanel((LayoutManager)new HorizontalFlowLayout(5, false), new Component[0]);
        this.setSpecialComponent(special);
        if (optionType == 0 || optionType == 1) {
            this.yes = this.createControlButton("weblaf.optionpane.yes");
            this.yes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebExtendedOptionPane.this.closeDialog(0);
                }
            });
            this.buttons.add((Component)this.yes);
        }
        if (optionType == 0 || optionType == 1) {
            this.no = this.createControlButton("weblaf.optionpane.no");
            this.no.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebExtendedOptionPane.this.closeDialog(1);
                }
            });
            this.buttons.add((Component)this.no);
        }
        if (optionType == 2) {
            this.ok = this.createControlButton("weblaf.optionpane.ok");
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebExtendedOptionPane.this.closeDialog(0);
                }
            });
            this.buttons.add((Component)this.ok);
        }
        if (optionType == 1 || optionType == 2) {
            this.cancel = this.createControlButton("weblaf.optionpane.cancel");
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebExtendedOptionPane.this.closeDialog(2);
                }
            });
            this.buttons.add((Component)this.cancel);
        }
        SwingUtils.equalizeComponentsWidth(Arrays.asList("text"), this.buttons.getComponents());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(SwingUtils.getWindowAncestor((Component)parentComponent));
    }

    protected ImageIcon getLargeIcon(int messageType) {
        return WebOptionPaneUI.getTypeIcon(messageType);
    }

    public void clickYes() {
        this.yes.doClick();
    }

    public void clickNo() {
        this.no.doClick();
    }

    public void clickOk() {
        this.ok.doClick();
    }

    public void clickCancel() {
        this.cancel.doClick();
    }

    public void setContent(Object message) {
        this.setContent(message, true);
    }

    public void setSpecialComponent(Object special) {
        if (this.specialComponent != null) {
            this.controls.remove(this.specialComponent);
            this.specialComponent = null;
        }
        if (special != null) {
            this.specialComponent = special instanceof Component ? (Component)special : new WebLabel(special.toString());
            this.controls.add(this.specialComponent, (Object)"West");
        }
        this.updateCentered();
    }

    private void updateCentered() {
        this.centered.removeAll();
        if (this.specialComponent == null) {
            this.centered.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0}, {-2.0}}));
        } else {
            this.centered.setLayout(new TableLayout(new double[][]{{-1.0, -2.0}, {-2.0}}));
        }
        this.centered.add((Component)this.buttons, (Object)"1,0");
    }

    private void setContent(Object message, boolean updateWindow) {
        if (message != null) {
            if (message instanceof Component) {
                this.container.add((Component)message, (Object)"Center");
            } else {
                this.container.add((Component)new WebLabel(message.toString()), (Object)"Center");
            }
        }
        if (updateWindow) {
            this.pack();
            this.setLocationRelativeTo(SwingUtils.getWindowAncestor((Component)this.parentComponent));
        }
    }

    private List<Image> getDialogIcons(int messageType) {
        Image small = null;
        switch (messageType) {
            case 64: {
                small = ERROR_ICON.getImage();
                break;
            }
            case 1: {
                small = INFORMATION_ICON.getImage();
                break;
            }
            case 2: {
                small = WARNING_ICON.getImage();
                break;
            }
            case 3: {
                small = QUESTION_ICON.getImage();
            }
        }
        ImageIcon bi = WebOptionPaneUI.getTypeIcon(messageType);
        Image big = bi != null ? bi.getImage() : null;
        return CollectionUtils.asList((Object[])new Image[]{small, big});
    }

    private void closeDialog(int result) {
        this.result = result;
        this.dispose();
    }

    private WebButton createControlButton(String key) {
        WebButton cancel = new WebButton(key);
        cancel.setMinimumSize(new Dimension(70, 0));
        return cancel;
    }

    public int getResult() {
        return this.result;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -1;
            this.buttons.getComponents()[0].requestFocusInWindow();
        }
        super.setVisible(b);
    }

    public static WebExtendedOptionPane showConfirmDialog(Component parentComponent, Object message) {
        return WebExtendedOptionPane.showConfirmDialog(parentComponent, message, null);
    }

    public static WebExtendedOptionPane showConfirmDialog(Component parentComponent, Object message, Object special) {
        return WebExtendedOptionPane.showConfirmDialog(parentComponent, message, special, LanguageManager.get((String)"weblaf.optionpane.title"));
    }

    public static WebExtendedOptionPane showConfirmDialog(Component parentComponent, Object message, Object special, String title) {
        return WebExtendedOptionPane.showConfirmDialog(parentComponent, message, special, title, 0);
    }

    public static WebExtendedOptionPane showConfirmDialog(Component parentComponent, Object message, Object special, String title, int optionType) {
        return WebExtendedOptionPane.showConfirmDialog(parentComponent, message, special, title, optionType, 3);
    }

    public static WebExtendedOptionPane showConfirmDialog(Component parentComponent, Object message, Object special, String title, int optionType, int messageType) {
        WebExtendedOptionPane confirmDialog = new WebExtendedOptionPane(parentComponent, message, special, title, optionType, messageType);
        confirmDialog.setVisible(true);
        return confirmDialog;
    }
}

