/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.statusbar.MemoryBarListener;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.style.StyleId;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.FileUtils;
import com.alee.utils.swing.ComponentUpdater;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class WebMemoryBar
extends WebButton {
    public static final String THREAD_NAME = "WebMemoryBar.updater";
    protected boolean allowGcAction = true;
    protected boolean showTooltip = true;
    protected int tooltipDelay = 1000;
    protected boolean showMaximumMemory = false;
    protected long usedMemory = 0L;
    protected long allocatedMemory = 0L;
    protected long maxMemory = 0L;
    protected int refreshRate = 1000;
    protected ComponentUpdater updater = null;
    private WebCustomTooltip tooltip;
    private final WebLabel tooltipLabel;

    public WebMemoryBar() {
        this(StyleId.memorybar);
    }

    public WebMemoryBar(StyleId id) {
        super(id);
        this.setFocusable(true);
        ImageIcon icon = new ImageIcon(WebMemoryBar.class.getResource("icons/memory.png"));
        this.tooltipLabel = new WebLabel(StyleId.memorybarTooltip.at(this), (Icon)icon);
        this.updateTooltip();
        this.updateMemory();
        this.updater = ComponentUpdater.install((JComponent)this, THREAD_NAME, (long)this.refreshRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebMemoryBar.this.updateMemory();
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebMemoryBar.this.gc();
            }
        });
    }

    public void gc() {
        if (this.allowGcAction) {
            this.fireGcCalled();
            System.gc();
            this.updateMemory();
            this.fireGcCompleted();
        }
    }

    protected void updateMemory() {
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.usedMemory = mu.getUsed();
        this.allocatedMemory = mu.getCommitted();
        this.maxMemory = mu.getMax();
        this.setText(this.getMemoryBarText());
        if (this.showTooltip) {
            this.tooltipLabel.setText(this.getMemoryBarTooltipText());
            this.tooltip.updateLocation();
        }
        this.repaint();
    }

    protected String getMemoryBarText() {
        long total = this.showMaximumMemory ? this.maxMemory : this.allocatedMemory;
        return FileUtils.getFileSizeString((long)this.usedMemory, (int)this.getDigits(this.usedMemory)) + " " + LanguageManager.get((String)"weblaf.ex.memorybar.of") + " " + FileUtils.getFileSizeString((long)total, (int)this.getDigits(total));
    }

    protected String getMemoryBarTooltipText() {
        return "<html>" + LanguageManager.get((String)"weblaf.ex.memorybar.alloc") + " <b>" + FileUtils.getFileSizeString((long)this.allocatedMemory, (int)this.getDigits(this.allocatedMemory)) + "</b> " + LanguageManager.get((String)"weblaf.ex.memorybar.used") + " <b>" + FileUtils.getFileSizeString((long)this.usedMemory, (int)this.getDigits(this.usedMemory)) + this.getMaximumText() + "</b></html>";
    }

    private String getMaximumText() {
        if (this.showMaximumMemory) {
            return "</b> " + LanguageManager.get((String)"weblaf.ex.memorybar.max") + " <b>" + FileUtils.getFileSizeString((long)this.maxMemory, (int)this.getDigits(this.maxMemory));
        }
        return "";
    }

    private int getDigits(long size) {
        return size < 0x40000000L ? 0 : 2;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
        this.updater.setDelay(refreshRate);
    }

    public boolean isAllowGcAction() {
        return this.allowGcAction;
    }

    public void setAllowGcAction(boolean allowGcAction) {
        this.allowGcAction = allowGcAction;
    }

    public boolean isShowTooltip() {
        return this.showTooltip;
    }

    public void setShowTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
        this.updateTooltip();
    }

    private void updateTooltip() {
        if (this.showTooltip) {
            this.tooltip = TooltipManager.setTooltip((Component)this, (JComponent)this.tooltipLabel, this.tooltipDelay);
        } else {
            TooltipManager.removeTooltips(this.tooltipLabel);
        }
    }

    public long getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public Icon getMemoryIcon() {
        return this.tooltipLabel.getIcon();
    }

    public void setMemoryIcon(Icon memoryIcon) {
        this.tooltipLabel.setIcon(memoryIcon);
    }

    public int getTooltipDelay() {
        return this.tooltipDelay;
    }

    public void setTooltipDelay(int tooltipDelay) {
        this.tooltipDelay = tooltipDelay;
    }

    public boolean isShowMaximumMemory() {
        return this.showMaximumMemory;
    }

    public void setShowMaximumMemory(boolean showMaximumMemory) {
        this.showMaximumMemory = showMaximumMemory;
    }

    public void addMemoryBarListener(MemoryBarListener listener) {
        this.listenerList.add(MemoryBarListener.class, listener);
    }

    public void removeMemoryBarListener(MemoryBarListener listener) {
        this.listenerList.remove(MemoryBarListener.class, listener);
    }

    public void fireGcCalled() {
        for (MemoryBarListener listener : (MemoryBarListener[])this.listenerList.getListeners(MemoryBarListener.class)) {
            listener.gcCalled();
        }
    }

    public void fireGcCompleted() {
        for (MemoryBarListener listener : (MemoryBarListener[])this.listenerList.getListeners(MemoryBarListener.class)) {
            listener.gcCompleted();
        }
    }
}

