/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.style;

import com.alee.extended.button.SplitButtonAdapter;
import com.alee.extended.button.WebSplitButton;
import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.extended.label.CustomStyle;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.magnifier.MagnifierGlass;
import com.alee.extended.panel.CenterPanel;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.statusbar.WebMemoryBar;
import com.alee.extended.statusbar.WebStatusBar;
import com.alee.extended.style.CodeLinkGenerator;
import com.alee.extended.syntax.SyntaxPreset;
import com.alee.extended.syntax.WebSyntaxArea;
import com.alee.extended.syntax.WebSyntaxScrollPane;
import com.alee.extended.tree.WebFileTree;
import com.alee.extended.window.PopOverLocation;
import com.alee.extended.window.WebPopOver;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.laf.colorchooser.WebColorChooser;
import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.filechooser.WebFileChooser;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.WebList;
import com.alee.laf.menu.WebCheckBoxMenuItem;
import com.alee.laf.menu.WebMenu;
import com.alee.laf.menu.WebMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.progressbar.WebProgressBar;
import com.alee.laf.radiobutton.WebRadioButton;
import com.alee.laf.rootpane.WebFrame;
import com.alee.laf.scroll.WebScrollBar;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.slider.WebSlider;
import com.alee.laf.spinner.WebSpinner;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.laf.table.WebTable;
import com.alee.laf.text.WebPasswordField;
import com.alee.laf.text.WebTextArea;
import com.alee.laf.text.WebTextField;
import com.alee.laf.text.WebTextPane;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.log.Log;
import com.alee.managers.style.ChildStyleId;
import com.alee.managers.style.CustomSkin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.style.data.SkinInfo;
import com.alee.managers.style.data.SkinInfoConverter;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.skin.web.WebSkin;
import com.alee.utils.CompareUtils;
import com.alee.utils.ExceptionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.DocumentChangeListener;
import com.alee.utils.swing.DocumentEventRunnable;
import com.alee.utils.swing.IntDocumentChangeListener;
import com.alee.utils.swing.IntTextDocument;
import com.alee.utils.swing.KeyEventRunnable;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import com.alee.utils.swing.WebTimer;
import com.alee.utils.text.LoremIpsum;
import com.alee.utils.xml.ResourceFile;
import com.alee.utils.xml.ResourceLocation;
import com.thoughtworks.xstream.converters.ConversionException;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public class StyleEditor
extends WebFrame {
    protected static final ImageIcon magnifierIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/magnifier.png"));
    protected static final ImageIcon boundsIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/bounds.png"));
    protected static final ImageIcon disabledIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/disabled.png"));
    protected static final ImageIcon orientationIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/orientation.png"));
    protected static final ImageIcon brushIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/brush.png"));
    protected static final ImageIcon locateIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/locate.png"));
    protected static final ImageIcon info = new ImageIcon(StyleEditor.class.getResource("icons/status/info.png"));
    protected static final ImageIcon ok = new ImageIcon(StyleEditor.class.getResource("icons/status/ok.png"));
    protected static final ImageIcon error = new ImageIcon(StyleEditor.class.getResource("icons/status/error.png"));
    protected static final ImageIcon tabIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/tab.png"));
    protected static final BufferedImage magnifier = ImageUtils.getBufferedImage((ImageIcon)new ImageIcon(StyleEditor.class.getResource("icons/editor/magnifierImage.png")));
    protected static final ImageIcon completeStackTraceIcon = new ImageIcon(StyleEditor.class.getResource("icons/status/completeStackTrace.png"));
    protected static final String COMPONENT_TYPE_KEY = "component.type.key";
    protected static final String SINGLE_PREVIEW_KEY = "single.preview.key";
    protected static final String STYLE_ID_KEY = "style.id.key";
    protected WebPanel container;
    protected WebSplitPane split;
    protected WebPanel previewContainer;
    protected WebToolBar toolBar;
    protected WebScrollPane previewScroll;
    protected WebPanel previewPanel;
    protected WebPanel editorsContainer;
    protected WebTabbedPane editorTabs;
    protected WebStatusBar statusBar;
    protected WebLabel statusMessage;
    protected final List<JComponent> previewComponents = new ArrayList<JComponent>();
    protected final List<WebPanel> boundsPanels = new ArrayList<WebPanel>();
    private final MagnifierGlass magnifierGlass = new MagnifierGlass(4);
    protected int updateDelay = 500;
    protected ComponentOrientation orientation = WebLookAndFeel.getOrientation();
    protected boolean enabled = true;
    protected boolean locate = true;
    protected boolean brush = false;
    protected boolean completeStackTrace = false;
    protected final ResourceFile baseSkinFile;
    protected List<WebSyntaxArea> editors;
    protected Throwable lastException = null;

    public StyleEditor(ResourceFile skin) {
        super(StyleId.styleeditor, "Style editor");
        this.setIconImages(WebLookAndFeel.getImages());
        this.baseSkinFile = skin;
        this.container = new WebPanel();
        this.getContentPane().add((Component)this.container, "Center");
        this.split = new WebSplitPane(StyleId.styleeditorSplit.at(this), 1, true);
        this.split.setDividerLocation(350);
        this.split.setDividerSize(8);
        this.split.setDrawDividerBorder(true);
        this.split.setOneTouchExpandable(true);
        this.container.add((Component)this.split, (Object)"Center");
        this.previewContainer = new WebPanel(StyleId.styleeditorPreview.at(this.split), new BorderLayout(), new Component[0]);
        this.split.setLeftComponent(this.previewContainer);
        this.editorsContainer = new WebPanel(StyleId.styleeditorEditors.at(this.split), new BorderLayout(), new Component[0]);
        this.split.setRightComponent(this.editorsContainer);
        this.createPreviewToolbar();
        this.createPreviewPanel();
        this.createEditors();
        this.createStatusBar();
        this.setDefaultCloseOperation(3);
        this.setSize(1200, 800);
        this.setLocationRelativeTo(null);
    }

    protected void createPreviewToolbar() {
        this.toolBar = new WebToolBar(StyleId.styleeditorPreviewToolbar.at(this.previewContainer));
        this.previewContainer.add((Component)this.toolBar, (Object)"North");
        StyleId toolId = StyleId.styleeditorPreviewTool.at(this.toolBar);
        final WebSplitButton magnifierButton = new WebSplitButton(toolId, "4x", (Icon)magnifierIcon);
        magnifierButton.addSplitButtonListener(new SplitButtonAdapter(){

            @Override
            public void buttonClicked(ActionEvent e) {
                StyleEditor.this.magnifierGlass.displayOrDispose(StyleEditor.this);
            }
        });
        this.toolBar.add((Component)magnifierButton);
        WebPopupMenu menu = new WebPopupMenu();
        for (int i = 2; i <= 6; ++i) {
            final int factor = i;
            WebMenuItem menuItem = new WebMenuItem(i + "x zoom");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    magnifierButton.setText(factor + "x");
                    StyleEditor.this.magnifierGlass.setZoomFactor(factor);
                    StyleEditor.this.magnifierGlass.display(StyleEditor.this);
                }
            });
            menu.add(menuItem);
        }
        magnifierButton.setPopupMenu(menu);
        final WebToggleButton boundsButton = new WebToggleButton(toolId, (Icon)boundsIcon);
        boundsButton.setToolTip(boundsIcon, "Show/hide component bounds");
        boundsButton.addHotkey(Hotkey.ALT_W);
        boundsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WebPanel boundsPanel : StyleEditor.this.boundsPanels) {
                    JComponent singlePreview = (JComponent)boundsPanel.getClientProperty(StyleEditor.SINGLE_PREVIEW_KEY);
                    boundsPanel.setStyleId(boundsButton.isSelected() ? StyleId.styleeditorPreviewSingleDashed.at(singlePreview) : StyleId.styleeditorPreviewSingleEmpty.at(singlePreview));
                }
            }
        });
        this.toolBar.add((Component)boundsButton);
        WebToggleButton disabledButton = new WebToggleButton(toolId, (Icon)disabledIcon);
        disabledButton.setToolTip(disabledIcon, "Disable/enable components");
        disabledButton.addHotkey(Hotkey.ALT_D);
        disabledButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditor.this.enabled = !StyleEditor.this.enabled;
                StyleEditor.this.applyViewEnabledState();
            }
        });
        this.toolBar.add((Component)disabledButton);
        WebToggleButton orientationButton = new WebToggleButton(toolId, (Icon)orientationIcon, !this.orientation.isLeftToRight());
        orientationButton.setToolTip(orientationIcon, "Change components orientation");
        orientationButton.addHotkey(Hotkey.ALT_R);
        orientationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditor.this.orientation = StyleEditor.this.orientation.isLeftToRight() ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
                StyleEditor.this.applyViewOrientation();
            }
        });
        this.toolBar.add((Component)orientationButton);
        this.toolBar.addSeparator();
        final WebToggleButton brushButton = new WebToggleButton(toolId, (Icon)brushIcon, this.brush);
        brushButton.setToolTip(brushIcon, "Apply component style ID");
        brushButton.addHotkey(Hotkey.ALT_S);
        brushButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditor.this.brush = true;
                Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                    @Override
                    public void eventDispatched(AWTEvent event) {
                        MouseEvent e = (MouseEvent)event;
                        if (e.getButton() == 1 && e.getID() == 501) {
                            StyleEditor.this.brush = false;
                            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                            brushButton.setSelected(false);
                            Component c = e.getComponent();
                            Point click = e.getLocationOnScreen();
                            Point cloc = c.getLocationOnScreen();
                            Component actual = SwingUtils.getTopComponentAt(c, click.x - cloc.x, click.y - cloc.y);
                            System.out.println(actual);
                        }
                    }
                }, 16L);
            }
        });
        this.toolBar.add((Component)brushButton);
        final WebToggleButton locateViewButton = new WebToggleButton(toolId, (Icon)locateIcon, this.locate);
        locateViewButton.setToolTip(locateIcon, "Locate component view when navigating XML");
        locateViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditor.this.locate = locateViewButton.isSelected();
                StyleEditor.this.locateView();
            }
        });
        this.toolBar.addToEnd(locateViewButton);
    }

    protected void createPreviewPanel() {
        this.previewScroll = new WebScrollPane(StyleId.styleeditorPreviewScroll.at(this.previewContainer));
        this.previewScroll.getVerticalScrollBar().setUnitIncrement(15);
        this.previewContainer.add((Component)this.previewScroll, (Object)"Center");
        VerticalFlowLayout layout = new VerticalFlowLayout(0, 0, 15, true, false);
        this.previewPanel = new WebPanel(StyleId.styleeditorPreviewPane.at(this.previewScroll), layout, new Component[0]);
        this.previewScroll.setViewportView(this.previewPanel);
        WebLabel label = new WebLabel("Just a label", (Icon)WebLookAndFeel.getIcon(16));
        this.addViewComponent("Label", label, label, true);
        String styledText = "{Simple styled label:b;c(128,128,0);u}\nwith {hard:b} line breaks\nacross the text";
        WebStyledLabel styledLabel = new WebStyledLabel("{Simple styled label:b;c(128,128,0);u}\nwith {hard:b} line breaks\nacross the text", new Object[0]);
        styledLabel.addStyleRange(new StyleRange(1, 3, 2, new CustomStyle[0]));
        this.addViewComponent("Styled label", styledLabel, styledLabel, true);
        WebButton button = new WebButton("Simple button", (Icon)WebLookAndFeel.getIcon(16));
        this.addViewComponent("Button", button, button, true);
        WebButton iconButton = new WebButton(WebLookAndFeel.getIcon(24));
        this.addViewComponent("Icon button", iconButton, iconButton, true);
        WebToggleButton toggleButton = new WebToggleButton("Toggle me", (Icon)WebLookAndFeel.getIcon(16));
        this.addViewComponent("Toggle button", toggleButton, toggleButton, true);
        WebToggleButton iconToggleButton = new WebToggleButton(WebLookAndFeel.getIcon(24));
        this.addViewComponent("Icon toggle button", iconToggleButton, iconToggleButton, true);
        WebCheckBox checkBox = new WebCheckBox("Check me");
        this.addViewComponent("Checkbox", checkBox, checkBox, true);
        WebTristateCheckBox tristateCheckBox = new WebTristateCheckBox("Check me more");
        this.addViewComponent("Tristate checkbox", tristateCheckBox, tristateCheckBox, true);
        WebRadioButton radioButton1 = new WebRadioButton("Radio button 1");
        WebRadioButton radioButton2 = new WebRadioButton("Radio button 2");
        WebRadioButton radioButton3 = new WebRadioButton("Radio button 3");
        SwingUtils.groupButtons(radioButton1, radioButton2, radioButton3);
        GroupPanel radioGroup = new GroupPanel(false, radioButton1, radioButton2, radioButton3);
        this.addViewComponent("Radio button", radioGroup, radioGroup, true);
        WebScrollBar hsb = new WebScrollBar(0, 45, 10, 0, 100);
        this.addViewComponent("Horizontal scroll bar", hsb, hsb, false);
        WebScrollBar vsb = new WebScrollBar(1, 45, 10, 0, 100).setPreferredHeight(100);
        this.addViewComponent("Vertical scroll bar", vsb, vsb, true);
        WebTextArea textArea = new WebTextArea();
        textArea.setRows(5);
        LoremIpsum loremIpsum = new LoremIpsum();
        textArea.setText(loremIpsum.getParagraphs(5));
        WebScrollPane sp = new WebScrollPane(textArea);
        sp.setPreferredWidth(0);
        this.addViewComponent("Scroll pane", sp, sp, false);
        WebTextPane textPane = new WebTextPane(StyleId.textpaneDecorated);
        textPane.setText(loremIpsum.getWords(5) + "\n" + loremIpsum.getWords(5, 5));
        this.addViewComponent("Text pane", textPane, textPane, true);
        Object[] d = new String[]{"Mikle Garin", "Joe Phillips", "Lilly Stewart", "Alex Jackson", "Joshua Martin", "Mark Einsberg", "Alice Manson", "Nancy Drew", "John Linderman", "Trisha Mathew", "Annae Mendy", "Wendy Anderson", "Alex Kurovski"};
        WebComboBox cb = new WebComboBox(d);
        this.addViewComponent("Combo box", cb, cb, true);
        WebSlider slider = new WebSlider();
        this.addViewComponent("Slider", slider, slider, true);
        WebSpinner spinner = new WebSpinner();
        this.addViewComponent("Spinner", spinner, spinner, true);
        WebProgressBar progress = new WebProgressBar();
        progress.setValue(33);
        this.addViewComponent("Progress bar", progress, progress, true);
        WebList wl = new WebList(d);
        WebScrollPane wlScroll = new WebScrollPane(wl);
        wlScroll.setPreferredSize(new Dimension(200, 150));
        this.addViewComponent("List", wlScroll, wl, false);
        WebFileTree homeFileTree = new WebFileTree(FileUtils.getUserHomePath());
        homeFileTree.setAutoExpandSelectedNode(false);
        homeFileTree.setShowsRootHandles(true);
        homeFileTree.setSelectionStyle(TreeSelectionStyle.group);
        WebScrollPane homeFileTreeScroll = new WebScrollPane(homeFileTree);
        homeFileTreeScroll.setPreferredSize(new Dimension(200, 150));
        this.addViewComponent("Tree", homeFileTreeScroll, homeFileTree, false);
        final WebPopupMenu popupMenu = new WebPopupMenu();
        popupMenu.add(new WebCheckBoxMenuItem("Check item", (Icon)WebLookAndFeel.getIcon(16)));
        popupMenu.addSeparator();
        popupMenu.add(new WebMenuItem("Item 1", (Icon)WebLookAndFeel.getIcon(16)));
        popupMenu.add(new WebMenuItem("Item 2"));
        popupMenu.add((Component)new WebMenuItem("Item 3"), Hotkey.ALT_F4);
        popupMenu.addSeparator();
        WebMenu menu = new WebMenu("Sub-menu", (Icon)WebLookAndFeel.getIcon(16));
        menu.add(new WebMenuItem("Item 1", (Icon)WebLookAndFeel.getIcon(16)));
        menu.add(new WebMenuItem("Item 2", Hotkey.CTRL_X));
        menu.add(new WebMenuItem("Item 3"));
        popupMenu.add(menu);
        WebButton popupButton = new WebButton("Show popup menu", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.showBelowMiddle((WebButton)e.getSource());
            }
        });
        this.addViewComponent("Popup menu", popupButton, popupMenu, true);
        WebTextField textField = new WebTextField("Some text...");
        this.addViewComponent("Text field", textField, textField, false);
        WebPasswordField passwordField = new WebPasswordField();
        passwordField.setInputPrompt("Enter the password...");
        this.addViewComponent("Password field", passwordField, passwordField, false);
        Object[] headers = new String[]{"Header 1", "Header 2", "Header 3", "Header 4", "Header 5", "Header 6"};
        Object[][] data = new String[][]{{"1", "2", "3", "4", "5", "6"}, {"7", "8", "9", "10", "11", "12"}, {"13", "14", "15", "16", "17", "18"}, {"19", "20", "21", "22", "23", "24"}, {"25", "26", "27", "28", "29", "30"}, {"31", "32", "33", "34", "35", "36"}, {"37", "38", "39", "40", "41", "42"}, {"43", "44", "45", "46", "47", "48"}, {"49", "50", "51", "52", "53", "54"}};
        WebTable table = new WebTable(data, headers);
        table.setEditable(true);
        table.setAutoResizeMode(0);
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(true);
        table.setPreferredScrollableViewportSize(new Dimension(200, 100));
        WebScrollPane tableScroll = new WebScrollPane(table);
        this.addViewComponent("Table", tableScroll, table, false);
        final WebFrame wf = new WebFrame(StyleId.frameDecorated, "Decorated frame");
        wf.setSize(400, 200);
        WebButton wfb = new WebButton("frame", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                wf.center();
                wf.setVisible(true);
            }
        });
        this.addViewComponent("Decorated frame", wfb, wf.getRootPane(), true);
        final WebColorChooser wcc = new WebColorChooser();
        WebButton wccb = new WebButton("color chooser", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dlg = WebColorChooser.createDialog((Component)e.getSource(), "Title", true, wcc, null, null);
                dlg.setVisible(true);
            }
        });
        this.addViewComponent("Color chooser", wccb, wcc, true);
        final WebFileChooser wfc = new WebFileChooser();
        WebButton wfcb = new WebButton("file chooser", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                wfc.showDialog((Component)e.getSource(), "Okay");
            }
        });
        this.addViewComponent("File chooser", wfcb, wfc, true);
        final WebOptionPane wop = new WebOptionPane(loremIpsum.getWords(5), 1);
        WebButton wopb = new WebButton("option pane", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dlg = wop.createDialog((Component)e.getSource(), "Title");
                dlg.setVisible(true);
            }
        });
        this.addViewComponent("Option pane", wopb, wop, true);
    }

    protected void addViewComponent(String title, JComponent displayedView, JComponent view, boolean center) {
        this.addViewComponent(title, null, displayedView, view, center);
    }

    protected void addViewComponent(String title, StyleId styleId, JComponent displayedView, JComponent view, boolean center) {
        StyleableComponent type = StyleableComponent.get(view);
        StyleId singleId = StyleId.styleeditorPreviewSingle.at(this.previewPanel);
        WebPanel singlePreview = new WebPanel(singleId, new BorderLayout(0, 0), new Component[0]);
        ChildStyleId titleId = StyleId.styleeditorPreviewSingleTitle;
        WebLabel titleLabel = new WebLabel(titleId.at(singlePreview), title, type.getIcon(), 10, new Object[0]);
        singlePreview.add((Component)titleLabel, (Object)"North");
        StyleId emptyId = StyleId.styleeditorPreviewSingleEmpty.at(singlePreview);
        WebPanel boundsPanel = new WebPanel(emptyId, (Component)displayedView);
        boundsPanel.putClientProperty(SINGLE_PREVIEW_KEY, singlePreview);
        this.boundsPanels.add(boundsPanel);
        StyleId viewId = StyleId.styleeditorPreviewSingleShade.at(singlePreview);
        final WebPanel viewPanel = new WebPanel(viewId, (Component)(center ? new CenterPanel(boundsPanel) : boundsPanel));
        singlePreview.add((Component)viewPanel, (Object)"Center");
        singlePreview.putClientProperty(COMPONENT_TYPE_KEY, (Object)type);
        if (styleId != null) {
            singlePreview.putClientProperty(STYLE_ID_KEY, styleId);
        } else if (view instanceof Styleable) {
            singlePreview.putClientProperty(STYLE_ID_KEY, ((Styleable)((Object)view)).getStyleId());
        }
        titleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                viewPanel.setVisible(!viewPanel.isVisible());
                StyleEditor.this.previewPanel.revalidate();
                StyleEditor.this.previewPanel.repaint();
            }
        });
        this.previewPanel.add((Component)singlePreview);
        this.previewComponents.add(view);
    }

    protected void createStatusBar() {
        this.statusBar = new WebStatusBar(StyleId.styleeditorStatus.at(this));
        this.container.add((Component)this.statusBar, (Object)"South");
        ImageIcon updateIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/update.png"));
        StyleId labelId = StyleId.styleeditorStatusLabel.at(this.statusBar);
        WebLabel delayLabel = new WebLabel(labelId, "Skin update delay:", updateIcon);
        this.statusBar.add(delayLabel);
        StyleId delayId = StyleId.styleeditorStatusDelay.at(this.statusBar);
        WebTextField delayField = new WebTextField(delayId, new IntTextDocument(), "" + this.updateDelay, 3);
        delayField.setHorizontalAlignment(0);
        delayField.getDocument().addDocumentListener(new IntDocumentChangeListener(){

            @Override
            public void documentChanged(Integer newValue, DocumentEvent e) {
                int n = StyleEditor.this.updateDelay = newValue != null ? newValue : StyleEditor.this.updateDelay;
                if (StyleEditor.this.updateDelay < 0) {
                    StyleEditor.this.updateDelay = 0;
                }
            }
        });
        this.statusBar.add(delayField);
        this.statusBar.add(new WebLabel(labelId, "ms"));
        this.statusBar.addSeparator();
        this.statusMessage = new WebLabel(labelId, "Edit XML at the right side and see UI changes at the left side!", info);
        this.statusMessage.onMousePress(MouseButton.left, new MouseEventRunnable(){

            @Override
            public void run(MouseEvent e) {
                if (StyleEditor.this.lastException != null) {
                    String stack = ExceptionUtils.getStackTrace((Throwable)StyleEditor.this.lastException);
                    String text = stack.replaceAll("\t", "         ");
                    TooltipManager.showOneTimeTooltip((Component)StyleEditor.this.statusMessage, null, text, TooltipWay.up);
                }
            }
        });
        this.statusBar.add(this.statusMessage);
        StyleId statusToggleId = StyleId.styleeditorStatusToggle.at(this.statusBar);
        final WebToggleButton completeStackTraceButton = new WebToggleButton(statusToggleId, (Icon)completeStackTraceIcon, this.completeStackTrace);
        completeStackTraceButton.setToolTip(completeStackTraceIcon, "Output complete style parsing stack trace");
        completeStackTraceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditor.this.completeStackTrace = completeStackTraceButton.isSelected();
            }
        });
        this.statusBar.addToEnd(completeStackTraceButton);
        this.statusBar.addToEnd(new WebMemoryBar().setPreferredWidth(200));
    }

    protected void createEditors() {
        this.editorTabs = new WebTabbedPane(StyleId.styleeditorEditorsTabs.at(this.editorsContainer));
        this.editorsContainer.add((Component)this.editorTabs, (Object)"Center");
        ArrayList<String> xmlContent = new ArrayList<String>();
        final ArrayList<String> xmlNames = new ArrayList<String>();
        ArrayList<ResourceFile> xmlFiles = new ArrayList<ResourceFile>();
        this.loadSkinSources(xmlContent, xmlNames, xmlFiles);
        int numTabs = xmlContent.size();
        this.editors = new ArrayList<WebSyntaxArea>(numTabs);
        ArrayList<String> sortedNames = new ArrayList<String>(numTabs);
        for (int i = 0; i < xmlContent.size(); ++i) {
            int j;
            WebPanel tabContent = new WebPanel();
            tabContent.add((Component)new TabContentSeparator(), (Object)"North");
            tabContent.add(this.createSingleXmlEditor((String)xmlContent.get(i), (ResourceFile)xmlFiles.get(i)), (Object)"Center");
            String name = (String)xmlNames.get(i);
            for (j = 0; j < i && ((String)sortedNames.get(j)).compareTo(name) <= 0; ++j) {
            }
            this.editorTabs.insertTab(name, null, tabContent, null, j);
            sortedNames.add(j, name);
            this.editorTabs.setIconAt(i, tabIcon);
        }
        HotkeyManager.registerHotkey(Hotkey.CTRL_N, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                final WebPopOver popOver = new WebPopOver(StyleEditor.this);
                popOver.setCloseOnFocusLoss(true);
                final WebTextField searchField = new WebTextField(25);
                searchField.setInputPrompt("Jump to file...");
                popOver.add(searchField);
                searchField.getDocument().addDocumentListener(new DocumentChangeListener(){

                    @Override
                    public void documentChanged(DocumentEvent e) {
                        String text = searchField.getText().toLowerCase(Locale.ROOT);
                        if (!TextUtils.isEmpty((String)text)) {
                            for (String name : xmlNames) {
                                if (!name.toLowerCase(Locale.ROOT).contains(text)) continue;
                                StyleEditor.this.editorTabs.setSelectedIndex(xmlNames.indexOf(name));
                                break;
                            }
                        }
                    }
                });
                KeyEventRunnable closeRunnable = new KeyEventRunnable(){

                    @Override
                    public void run(KeyEvent e) {
                        popOver.dispose();
                        StyleEditor.this.editors.get(StyleEditor.this.editorTabs.getSelectedIndex()).requestFocusInWindow();
                    }
                };
                searchField.onKeyPress(Hotkey.ENTER, closeRunnable);
                searchField.onKeyPress(Hotkey.ESCAPE, closeRunnable);
                popOver.show(PopOverLocation.center);
            }
        });
    }

    protected Component createSingleXmlEditor(String xml, final ResourceFile xmlFile) {
        final WebSyntaxArea xmlEditor = new WebSyntaxArea(xml, SyntaxPreset.xml);
        xmlEditor.applyPresets(SyntaxPreset.base);
        xmlEditor.applyPresets(SyntaxPreset.margin);
        xmlEditor.applyPresets(SyntaxPreset.size);
        xmlEditor.applyPresets(SyntaxPreset.historyLimit);
        xmlEditor.setCaretPosition(0);
        xmlEditor.setHyperlinksEnabled(true);
        xmlEditor.setLinkGenerator(new CodeLinkGenerator((Component)((Object)xmlEditor)));
        HotkeyManager.registerHotkey((Component)((Object)xmlEditor), (JComponent)((Object)xmlEditor), Hotkey.CTRL_SHIFT_Z, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                xmlEditor.undoLastAction();
            }
        });
        WebSyntaxScrollPane xmlEditorScroll = new WebSyntaxScrollPane(StyleId.syntaxareaScrollUndecorated, xmlEditor);
        xmlEditor.onChange(new DocumentEventRunnable(){
            private final WebTimer updateTimer;
            {
                this.updateTimer = new WebTimer((long)StyleEditor.this.updateDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SkinInfoConverter.addCustomResource(xmlFile.getClassName(), xmlFile.getSource(), xmlEditor.getText());
                        StyleEditor.this.applySkin();
                    }
                }).setRepeats(false);
            }

            @Override
            public void run(DocumentEvent e) {
                this.updateTimer.restart((long)StyleEditor.this.updateDelay);
            }
        });
        xmlEditor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                StyleEditor.this.locateView();
            }
        });
        this.editors.add(xmlEditor);
        return xmlEditorScroll;
    }

    protected void loadSkinSources(List<String> xmlContent, List<String> xmlNames, List<ResourceFile> xmlFiles) {
        ArrayList<ResourceFile> resources = new ArrayList<ResourceFile>();
        resources.add(this.baseSkinFile);
        while (resources.size() > 0) {
            try {
                this.loadFirstResource(resources, xmlContent, xmlNames, xmlFiles);
            }
            catch (IOException e) {
                Log.error((Object)this, (Throwable)e);
            }
        }
    }

    protected void applySkin() {
        try {
            long time = System.currentTimeMillis();
            StyleManager.setSkin(new CustomSkin((SkinInfo)XmlUtils.fromXML((String)this.editors.get(0).getText())));
            this.applyViewOrientation();
            this.previewPanel.revalidate();
            time = System.currentTimeMillis() - time;
            this.statusMessage.setIcon(ok);
            this.statusMessage.setText("Style updated successfully within " + time + " ms");
            this.statusMessage.setCursor(Cursor.getDefaultCursor());
            this.lastException = null;
        }
        catch (ConversionException ex) {
            if (this.completeStackTrace) {
                Log.error((Object)this, (Throwable)ex);
            } else {
                Log.error((Object)this, (String)"Fix syntax problems within the XML to update styling");
            }
            this.statusMessage.setIcon(error);
            this.statusMessage.setText("Fix syntax problems within the XML to update styling");
            this.statusMessage.setCursor(Cursor.getPredefinedCursor(12));
            this.lastException = ex;
        }
        catch (Throwable ex) {
            if (this.completeStackTrace) {
                Log.error((Object)this, (Throwable)ex);
            } else {
                Log.error((Object)this, (String)"Unable to update skin due to internal issues");
            }
            this.statusMessage.setIcon(error);
            this.statusMessage.setText("Unable to update skin due to internal issues");
            this.statusMessage.setCursor(Cursor.getPredefinedCursor(12));
            this.lastException = ex;
        }
    }

    protected void applyViewOrientation() {
        this.previewPanel.applyComponentOrientation(this.orientation);
        for (JComponent component : this.previewComponents) {
            component.applyComponentOrientation(this.orientation);
        }
    }

    protected void applyViewEnabledState() {
        for (JComponent component : this.previewComponents) {
            SwingUtils.setEnabledRecursively(component, this.enabled);
        }
    }

    protected void locateView() {
        if (!this.locate) {
            return;
        }
        WebSyntaxArea syntaxArea = this.editors.get(this.editorTabs.getSelectedIndex());
        String xml = syntaxArea.getText();
        Source xmlSource = new Source((CharSequence)xml);
        xmlSource.setLogger(null);
        xmlSource.fullSequentialParse();
        StartTag tag = xmlSource.getPreviousStartTag(syntaxArea.getCaretPosition(), "style");
        if (tag != null) {
            String type = tag.getAttributeValue("type");
            String id = tag.getAttributeValue("id");
            this.locateView(this.previewPanel, type, id);
        }
    }

    protected boolean locateView(Container container, String type, String id) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            JComponent jc;
            StyleableComponent sc;
            Component component = container.getComponent(i);
            if (component instanceof JComponent && (sc = (StyleableComponent)((Object)(jc = (JComponent)component).getClientProperty(COMPONENT_TYPE_KEY))) != null && sc == StyleableComponent.valueOf(type)) {
                StyleId sid;
                StyleId styleId = (StyleId)jc.getClientProperty(STYLE_ID_KEY);
                StyleId styleId2 = sid = styleId == null ? sc.getDefaultStyleId() : styleId;
                if (CompareUtils.equals((Object)sid.getCompleteId(), (Object[])new Object[]{id})) {
                    Dimension visible = this.previewPanel.getVisibleRect().getSize();
                    Rectangle bounds = SwingUtils.getRelativeBounds(component, this.previewPanel);
                    if (visible.height > bounds.height) {
                        int y = bounds.y + bounds.height / 2 - visible.height / 2;
                        this.previewPanel.scrollRectToVisible(new Rectangle(0, y, visible.width, visible.height));
                    } else {
                        this.previewPanel.scrollRectToVisible(new Rectangle(0, bounds.y, visible.width, visible.height));
                    }
                    return true;
                }
            }
            if (!(component instanceof Container) || !this.locateView((Container)component, type, id)) continue;
            return true;
        }
        return false;
    }

    protected void loadFirstResource(List<ResourceFile> resources, List<String> xmlContent, List<String> xmlNames, List<ResourceFile> xmlFiles) throws IOException {
        ResourceFile rf = resources.get(0);
        Source xmlSource = new Source(ReflectUtils.getClassSafely((String)rf.getClassName()).getResource(rf.getSource()));
        xmlSource.setLogger(null);
        xmlSource.fullSequentialParse();
        Element baseClassTag = xmlSource.getFirstElement("class");
        String baseClass = baseClassTag != null ? baseClassTag.getContent().toString() : null;
        for (Element includeTag : xmlSource.getAllElements("include")) {
            String includeClass = includeTag.getAttributeValue("nearClass");
            String finalClass = includeClass != null ? includeClass : baseClass;
            String src = includeTag.getContent().toString();
            resources.add(new ResourceFile(ResourceLocation.nearClass, src, finalClass));
        }
        xmlContent.add(xmlSource.toString());
        xmlNames.add(new File(rf.getSource()).getName());
        xmlFiles.add(rf);
        resources.remove(0);
    }

    public static void main(String[] args) {
        Class<WebSkin> skinClass = WebSkin.class;
        WebLookAndFeel.install(skinClass);
        ResourceFile skin = new ResourceFile(ResourceLocation.nearClass, "resources/skin.xml", skinClass);
        StyleEditor styleEditor = new StyleEditor(skin);
        styleEditor.setVisible(true);
    }

    protected class TabContentSeparator
    extends JComponent {
        protected TabContentSeparator() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(new Color(237, 237, 237));
            g.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
            g.setColor(StyleConstants.darkBorderColor);
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 4);
        }
    }
}

