/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.extended.window.IPopOverPainter;
import com.alee.extended.window.PopOverAdapter;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverCloseListener;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.PopOverEventMethods;
import com.alee.extended.window.PopOverEventRunnable;
import com.alee.extended.window.PopOverListener;
import com.alee.extended.window.PopOverLocation;
import com.alee.laf.rootpane.WebDialog;
import com.alee.managers.style.StyleId;
import com.alee.painter.Painter;
import com.alee.utils.EventUtils;
import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.event.EventListenerList;

public class WebPopOver
extends WebDialog
implements PopOverEventMethods {
    public static final String POPOVER_INSTANCE = "popover.instance";
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean movable = true;

    public WebPopOver() {
        super(StyleId.popover);
    }

    public WebPopOver(Frame owner) {
        super(StyleId.popover, owner);
    }

    public WebPopOver(Frame owner, String title) {
        super(StyleId.popover, owner, title);
    }

    public WebPopOver(Dialog owner) {
        super(StyleId.popover, owner);
    }

    public WebPopOver(Dialog owner, String title) {
        super(StyleId.popover, owner, title);
    }

    public WebPopOver(Component owner) {
        super(StyleId.popover, owner);
    }

    public WebPopOver(Component owner, String title) {
        super(StyleId.popover, owner, title);
    }

    public WebPopOver(Window owner) {
        super(StyleId.popover, owner);
    }

    public WebPopOver(Window owner, String title) {
        super(StyleId.popover, owner, title);
    }

    public WebPopOver(StyleId id) {
        super(id);
    }

    public WebPopOver(StyleId id, Frame owner) {
        super(id, owner);
    }

    public WebPopOver(StyleId id, Frame owner, String title) {
        super(id, owner, title);
    }

    public WebPopOver(StyleId id, Dialog owner) {
        super(id, owner);
    }

    public WebPopOver(StyleId id, Dialog owner, String title) {
        super(id, owner, title);
    }

    public WebPopOver(StyleId id, Component owner) {
        super(id, owner);
    }

    public WebPopOver(StyleId id, Component owner, String title) {
        super(id, owner, title);
    }

    public WebPopOver(StyleId id, Window owner) {
        super(id, owner);
    }

    public WebPopOver(StyleId id, Window owner, String title) {
        super(id, owner, title);
    }

    @Override
    protected void initialize(StyleId id) {
        this.getRootPane().putClientProperty(POPOVER_INSTANCE, this);
        this.getRootPane().setWindowDecorationStyle(0);
        this.setUndecorated(true);
        this.setWindowOpaque(false);
        super.initialize(id);
        PopOverCloseListener closeListener = new PopOverCloseListener(){

            @Override
            public void popOverClosed() {
                WebPopOver.this.fireClosed();
            }
        };
        this.addComponentListener(closeListener);
        this.addWindowListener(closeListener);
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public WebPopOver show(PopOverLocation location) {
        this.preOpen();
        IPopOverPainter painter = this.getPainter();
        if (painter != null) {
            painter.configure(this, location);
        }
        this.setVisible(true);
        this.postOpen();
        return this;
    }

    public WebPopOver show(Point location) {
        return this.show(location.x, location.y);
    }

    public WebPopOver show(int x, int y) {
        this.preOpen();
        IPopOverPainter painter = this.getPainter();
        if (painter != null) {
            painter.configure(this, x, y);
        }
        this.setVisible(true);
        this.postOpen();
        return this;
    }

    public WebPopOver show(Component invoker) {
        return this.show(invoker, PopOverDirection.down);
    }

    public WebPopOver show(Component invoker, PopOverDirection direction) {
        return this.show(invoker, direction, PopOverAlignment.centered);
    }

    public WebPopOver show(Component invoker, PopOverDirection direction, PopOverAlignment alignment) {
        return this.show(invoker, null, direction, alignment);
    }

    public WebPopOver show(Component invoker, int x, int y) {
        return this.show(invoker, x, y, PopOverDirection.down);
    }

    public WebPopOver show(Component invoker, int x, int y, PopOverDirection direction) {
        return this.show(invoker, x, y, direction, PopOverAlignment.centered);
    }

    public WebPopOver show(Component invoker, int x, int y, PopOverDirection direction, PopOverAlignment alignment) {
        return this.show(invoker, x, y, 0, 0, direction, alignment);
    }

    public WebPopOver show(Component invoker, int x, int y, int w, int h) {
        return this.show(invoker, x, y, w, h, PopOverDirection.down);
    }

    public WebPopOver show(Component invoker, int x, int y, int w, int h, PopOverDirection direction) {
        return this.show(invoker, x, y, w, h, direction, PopOverAlignment.centered);
    }

    public WebPopOver show(Component invoker, int x, int y, int w, int h, PopOverDirection direction, PopOverAlignment alignment) {
        final Rectangle bounds = new Rectangle(x, y, w, h);
        return this.show(invoker, new DataProvider<Rectangle>(){

            public Rectangle provide() {
                return bounds;
            }
        }, direction, alignment);
    }

    public WebPopOver show(Component invoker, DataProvider<Rectangle> boundsProvider) {
        return this.show(invoker, boundsProvider, PopOverDirection.down);
    }

    public WebPopOver show(Component invoker, DataProvider<Rectangle> boundsProvider, PopOverDirection direction) {
        return this.show(invoker, boundsProvider, direction, PopOverAlignment.centered);
    }

    public WebPopOver show(Component invoker, DataProvider<Rectangle> boundsProvider, PopOverDirection direction, PopOverAlignment alignment) {
        this.preOpen();
        IPopOverPainter painter = this.getPainter();
        if (painter != null) {
            painter.configure(this, invoker, boundsProvider, direction, alignment);
        }
        this.setVisible(true);
        this.postOpen();
        return this;
    }

    protected IPopOverPainter getPainter() {
        Painter painter = this.getWebUI().getPainter();
        return painter instanceof IPopOverPainter ? (IPopOverPainter)painter : null;
    }

    protected void preOpen() {
        this.fireOpening();
        if (this.isShowing()) {
            this.fireReopened();
        }
    }

    protected void postOpen() {
        this.fireOpened();
    }

    public void addPopOverListener(PopOverListener listener) {
        this.listenerList.add(PopOverListener.class, listener);
    }

    public void removePopOverListener(PopOverListener listener) {
        this.listenerList.remove(PopOverListener.class, listener);
    }

    public void fireOpening() {
        for (PopOverListener listener : (PopOverListener[])this.listenerList.getListeners(PopOverListener.class)) {
            listener.opening(this);
        }
    }

    public void fireOpened() {
        for (PopOverListener listener : (PopOverListener[])this.listenerList.getListeners(PopOverListener.class)) {
            listener.opened(this);
        }
    }

    public void fireReopened() {
        for (PopOverListener listener : (PopOverListener[])this.listenerList.getListeners(PopOverListener.class)) {
            listener.reopened(this);
        }
    }

    public void fireDetached() {
        for (PopOverListener listener : (PopOverListener[])this.listenerList.getListeners(PopOverListener.class)) {
            listener.detached(this);
        }
    }

    public void fireClosed() {
        for (PopOverListener listener : (PopOverListener[])this.listenerList.getListeners(PopOverListener.class)) {
            listener.closed(this);
        }
    }

    @Override
    public PopOverAdapter onOpen(PopOverEventRunnable runnable) {
        return EventUtils.onOpen(this, runnable);
    }

    @Override
    public PopOverAdapter onReopen(PopOverEventRunnable runnable) {
        return EventUtils.onReopen(this, runnable);
    }

    @Override
    public PopOverAdapter onDetach(PopOverEventRunnable runnable) {
        return EventUtils.onDetach(this, runnable);
    }

    @Override
    public PopOverAdapter onClose(PopOverEventRunnable runnable) {
        return EventUtils.onClose(this, runnable);
    }
}

