/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class WindowResizeAdapter
extends MouseAdapter
implements SwingConstants {
    private boolean resizing = false;
    private int prevX = -1;
    private int prevY = -1;
    private int resizeSide = 0;

    public static void install(Component component, int resizeSide) {
        WindowResizeAdapter wra = new WindowResizeAdapter(resizeSide);
        component.addMouseListener(wra);
        component.addMouseMotionListener(wra);
    }

    public WindowResizeAdapter(int resizeSide) {
        this.resizeSide = resizeSide;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.resizing = true;
        }
        this.prevX = e.getXOnScreen();
        this.prevY = e.getYOnScreen();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.prevX != -1 && this.prevY != -1 && this.resizing) {
            boolean undecorated;
            Dimension dim;
            Window w = SwingUtils.getWindowAncestor((Component)e.getComponent());
            Rectangle rect = w.getBounds();
            if (w instanceof JDialog) {
                dim = ((JDialog)w).getRootPane().getMinimumSize();
                undecorated = ((JDialog)w).isUndecorated();
            } else if (w instanceof JFrame) {
                dim = ((JFrame)w).getRootPane().getMinimumSize();
                undecorated = ((JFrame)w).isUndecorated();
            } else if (w instanceof JWindow) {
                dim = ((JWindow)w).getRootPane().getMinimumSize();
                undecorated = true;
            } else {
                dim = w.getMinimumSize();
                undecorated = true;
            }
            int xInc = e.getXOnScreen() - this.prevX;
            int yInc = e.getYOnScreen() - this.prevY;
            if (undecorated) {
                if (this.resizeSide == 8 || this.resizeSide == 7 || this.resizeSide == 6) {
                    if (rect.width - xInc < dim.width) {
                        xInc = 0;
                    }
                } else if ((this.resizeSide == 2 || this.resizeSide == 3 || this.resizeSide == 4) && rect.width + xInc < dim.width) {
                    xInc = 0;
                }
                if (this.resizeSide == 8 || this.resizeSide == 1 || this.resizeSide == 2) {
                    if (rect.height - yInc < dim.height) {
                        yInc = 0;
                    }
                } else if ((this.resizeSide == 6 || this.resizeSide == 5 || this.resizeSide == 4) && rect.height + yInc < dim.height) {
                    yInc = 0;
                }
            }
            if (xInc != 0 || yInc != 0) {
                if (this.resizeSide == 8) {
                    w.setBounds(rect.x + xInc, rect.y + yInc, rect.width - xInc, rect.height - yInc);
                } else if (this.resizeSide == 1) {
                    w.setBounds(rect.x, rect.y + yInc, rect.width, rect.height - yInc);
                } else if (this.resizeSide == 2) {
                    w.setBounds(rect.x, rect.y + yInc, rect.width + xInc, rect.height - yInc);
                } else if (this.resizeSide == 7) {
                    w.setBounds(rect.x + xInc, rect.y, rect.width - xInc, rect.height);
                } else if (this.resizeSide == 3) {
                    w.setBounds(rect.x, rect.y, rect.width + xInc, rect.height);
                } else if (this.resizeSide == 6) {
                    w.setBounds(rect.x + xInc, rect.y, rect.width - xInc, rect.height + yInc);
                } else if (this.resizeSide == 5) {
                    w.setBounds(rect.x, rect.y, rect.width, rect.height + yInc);
                } else if (this.resizeSide == 4) {
                    w.setBounds(rect.x, rect.y, rect.width + xInc, rect.height + yInc);
                }
                this.prevX = e.getXOnScreen();
                this.prevY = e.getYOnScreen();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resizing = false;
    }
}

