/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.button.WebButton;
import com.alee.laf.combobox.AdaptiveComboBoxPainter;
import com.alee.laf.combobox.ComboBoxPainter;
import com.alee.laf.combobox.IComboBoxPainter;
import com.alee.laf.combobox.WebComboBoxCellRenderer;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.ImageUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WebComboBoxUI
extends BasicComboBoxUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    public static ImageIcon EXPAND_ICON = new ImageIcon(WebComboBoxUI.class.getResource("icons/arrow.png"));
    public static ImageIcon COLLAPSE_ICON = ImageUtils.rotateImage180((ImageIcon)EXPAND_ICON);
    protected static ListCellRenderer DEFAULT_RENDERER;
    protected ImageIcon expandIcon;
    protected ImageIcon collapseIcon;
    protected Boolean mouseWheelScrollingEnabled;
    protected Boolean widerPopupAllowed;
    @DefaultPainter(value=ComboBoxPainter.class)
    protected IComboBoxPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;
    protected Dimension cachedDisplaySize = new Dimension(0, 0);
    protected JSeparator separator;

    public static ComponentUI createUI(JComponent c) {
        return new WebComboBoxUI();
    }

    protected static ListCellRenderer getDefaultListCellRenderer() {
        if (DEFAULT_RENDERER == null) {
            DEFAULT_RENDERER = new WebComboBoxCellRenderer();
        }
        return DEFAULT_RENDERER;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.comboBox);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.comboBox);
        super.uninstallUI(c);
    }

    @Override
    protected void installComponents() {
        this.comboBox.removeAll();
        this.comboBox.setLayout(this.createLayoutManager());
        this.addArrowButton();
        this.addSeparator();
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    @Override
    protected void uninstallComponents() {
        this.removeArrowButton();
        this.removeSeparator();
        this.removeEditor();
        this.comboBox.removeAll();
    }

    protected void addArrowButton() {
        this.arrowButton = this.createArrowButton();
        this.configureArrowButton();
        this.comboBox.add(this.arrowButton);
    }

    protected void removeArrowButton() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
            this.comboBox.remove(this.arrowButton);
            this.arrowButton = null;
        }
    }

    protected void addSeparator() {
        this.separator = new WebSeparator(StyleId.comboboxSeparator.at(this.comboBox));
        this.comboBox.add(this.separator);
    }

    protected void removeSeparator() {
        if (this.separator != null) {
            this.comboBox.remove(this.separator);
            this.separator = null;
        }
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.comboBox);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.comboBox, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.comboBox, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        this.comboBox.hidePopup();
        PainterSupport.setPainter(this.comboBox, new DataRunnable<IComboBoxPainter>(){

            public void run(IComboBoxPainter newPainter) {
                WebComboBoxUI.this.painter = newPainter;
            }
        }, this.painter, painter, IComboBoxPainter.class, AdaptiveComboBoxPainter.class);
    }

    protected ListCellRenderer createRenderer() {
        return new WebComboBoxCellRenderer.UIResource();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor editor = super.createEditor();
        Component e = editor.getEditorComponent();
        e.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                WebComboBoxUI.this.comboBox.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                WebComboBoxUI.this.comboBox.repaint();
            }
        });
        if (e instanceof JTextField) {
            StyleId.comboboxEditor.at(this.comboBox).set((JTextField)e);
        }
        return editor;
    }

    @Override
    protected JButton createArrowButton() {
        this.arrowButton = new WebButton(StyleId.comboboxArrowButton.at(this.comboBox), (Icon)this.getExpandIcon()){

            @Override
            public void setFocusable(boolean focusable) {
                super.setFocusable(false);
            }
        };
        this.arrowButton.setName("ComboBox.arrowButton");
        return this.arrowButton;
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){

            protected JList createList() {
                JList<Object> list = super.createList();
                return list;
            }

            @Override
            protected JScrollPane createScroller() {
                WebScrollPane scroll = new WebScrollPane(StyleId.comboboxPopupScrollPane.at(this.comboBox), this.list);
                scroll.setHorizontalScrollBar(null);
                StyleId.comboboxPopupList.at(scroll).set(this.list);
                return scroll;
            }

            @Override
            protected void configurePopup() {
                this.setOpaque(false);
                this.setDoubleBuffered(true);
                this.setFocusable(false);
                this.setLayout(new BoxLayout(this, 1));
                this.add(this.scroller);
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        WebComboBoxUI.this.arrowButton.setIcon(WebComboBoxUI.this.getCollapseIcon());
                        comboBox.repaint();
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        WebComboBoxUI.this.arrowButton.setIcon(WebComboBoxUI.this.getExpandIcon());
                        comboBox.repaint();
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                        WebComboBoxUI.this.arrowButton.setIcon(WebComboBoxUI.this.getExpandIcon());
                    }
                });
            }

            @Override
            public void show() {
                this.comboBox.firePopupMenuWillBecomeVisible();
                this.setListSelection(this.comboBox.getSelectedIndex());
                Point location = this.getPopupLocation();
                this.show(this.comboBox, location.x, location.y);
            }

            private void setListSelection(int selectedIndex) {
                if (selectedIndex == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectedIndex(selectedIndex);
                    this.list.ensureIndexIsVisible(selectedIndex);
                }
            }

            private Point getPopupLocation() {
                Dimension comboSize = this.comboBox.getSize();
                if (WebComboBoxUI.this.isWiderPopupAllowed()) {
                    Dimension prefSize = this.comboBox.getPreferredSize();
                    if (prefSize.width > comboSize.width) {
                        comboSize.width = prefSize.width;
                    }
                }
                comboSize.setSize(comboSize.width - 2, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, comboSize.width, comboSize.height);
                Dimension scrollSize = popupBounds.getSize();
                this.scroller.setMaximumSize(scrollSize);
                this.scroller.setPreferredSize(scrollSize);
                this.scroller.setMinimumSize(scrollSize);
                this.list.revalidate();
                return popupBounds.getLocation();
            }
        };
    }

    public boolean isComboboxCellEditor() {
        if (this.comboBox != null) {
            Object cellEditor = this.comboBox.getClientProperty("JComboBox.isTableCellEditor");
            return cellEditor != null && (Boolean)cellEditor != false;
        }
        return false;
    }

    public void setEditorColumns(int columns) {
        if (this.editor instanceof JTextField) {
            ((JTextField)this.editor).setColumns(columns);
        }
    }

    public ImageIcon getExpandIcon() {
        return this.expandIcon != null ? this.expandIcon : EXPAND_ICON;
    }

    public void setExpandIcon(ImageIcon expandIcon) {
        this.expandIcon = expandIcon;
        if (this.arrowButton != null && !this.isPopupVisible(this.comboBox)) {
            this.arrowButton.setIcon(this.getExpandIcon());
        }
    }

    public ImageIcon getCollapseIcon() {
        return this.collapseIcon != null ? this.collapseIcon : COLLAPSE_ICON;
    }

    public void setCollapseIcon(ImageIcon collapseIcon) {
        this.collapseIcon = collapseIcon;
        if (this.arrowButton != null && this.isPopupVisible(this.comboBox)) {
            this.arrowButton.setIcon(this.getCollapseIcon());
        }
    }

    public boolean isMouseWheelScrollingEnabled() {
        return this.mouseWheelScrollingEnabled == null || this.mouseWheelScrollingEnabled != false;
    }

    public void setMouseWheelScrollingEnabled(boolean enabled) {
        this.mouseWheelScrollingEnabled = enabled;
    }

    public boolean isWiderPopupAllowed() {
        return this.widerPopupAllowed != null && this.widerPopupAllowed != false;
    }

    public void setWiderPopupAllowed(boolean allowed) {
        this.widerPopupAllowed = allowed;
    }

    public JList getListBox() {
        return this.listBox;
    }

    public void pinMinimumSizeDirty() {
        this.isMinimumSizeDirty = true;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.prepareToPaint(this.currentValuePane);
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new WebComboBoxLayout();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        size.height += insets.top + insets.bottom;
        size.width += insets.left + insets.right;
        if (this.arrowButton != null) {
            size.width += this.arrowButton.getPreferredSize().width;
            if (this.separator != null) {
                size.width += this.separator.getPreferredSize().width;
            }
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    @Override
    protected Dimension getDefaultSize() {
        return this.getSizeForComponent(WebComboBoxUI.getDefaultListCellRenderer().getListCellRendererComponent(this.listBox, " ", -1, false, false));
    }

    @Override
    protected Dimension getSizeForComponent(Component c) {
        this.currentValuePane.add(c);
        c.setFont(this.comboBox.getFont());
        Dimension d = c.getPreferredSize();
        this.currentValuePane.remove(c);
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter, true);
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        return this.getValueBounds();
    }

    public Rectangle getValueBounds() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        boolean ltr = this.comboBox.getComponentOrientation().isLeftToRight();
        int side = 0;
        if (this.arrowButton != null) {
            side += this.arrowButton.getPreferredSize().width;
            if (this.separator != null) {
                side += this.separator.getPreferredSize().width;
            }
        }
        return new Rectangle(ltr ? i.left : i.left + side, i.top, width - i.left - i.right - side, height - i.top - i.bottom);
    }

    public Rectangle getSeparatorBounds() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        boolean ltr = this.comboBox.getComponentOrientation().isLeftToRight();
        int sep = this.separator.getPreferredSize().width;
        int button = 0;
        if (this.arrowButton != null) {
            button += this.arrowButton.getPreferredSize().width;
        }
        return new Rectangle(ltr ? width - i.right - button - sep : i.left + button, i.top, sep, height - i.top - i.bottom);
    }

    public Rectangle getArrowButtonBounds() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        boolean ltr = this.comboBox.getComponentOrientation().isLeftToRight();
        int button = this.arrowButton.getPreferredSize().width;
        return new Rectangle(ltr ? width - i.right - button : i.left, i.top, button, height - i.top - i.bottom);
    }

    protected class WebComboBoxLayout
    extends AbstractLayoutManager {
        protected WebComboBoxLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (WebComboBoxUI.this.arrowButton != null) {
                WebComboBoxUI.this.arrowButton.setBounds(WebComboBoxUI.this.getArrowButtonBounds());
                if (WebComboBoxUI.this.separator != null) {
                    WebComboBoxUI.this.separator.setBounds(WebComboBoxUI.this.getSeparatorBounds());
                }
            }
            if (WebComboBoxUI.this.editor != null) {
                WebComboBoxUI.this.editor.setBounds(WebComboBoxUI.this.getValueBounds());
            }
        }
    }
}

