/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.splitpane.AdaptiveSplitPanePainter;
import com.alee.laf.splitpane.ISplitPanePainter;
import com.alee.laf.splitpane.SplitPanePainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class WebSplitPaneUI
extends BasicSplitPaneUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=SplitPanePainter.class)
    protected ISplitPanePainter painter;
    protected Color dragDividerColor;
    protected Color dividerBorderColor;
    protected boolean drawDividerBorder;
    protected Insets margin = null;
    protected Insets padding = null;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebSplitPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.splitPane);
        LookAndFeel.installProperty(this.splitPane, "opaque", Boolean.FALSE);
        this.splitPane.setDividerSize(6);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.splitPane);
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.splitPane);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.splitPane, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.splitPane, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.splitPane, new DataRunnable<ISplitPanePainter>(){

            public void run(ISplitPanePainter newPainter) {
                WebSplitPaneUI.this.painter = newPainter;
            }
        }, this.painter, painter, ISplitPanePainter.class, AdaptiveSplitPanePainter.class);
    }

    public Color getDragDividerColor() {
        return this.dragDividerColor;
    }

    public void setDragDividerColor(Color dragDividerColor) {
        this.dragDividerColor = dragDividerColor;
    }

    public boolean isDrawDividerBorder() {
        return this.drawDividerBorder;
    }

    public void setDrawDividerBorder(boolean draw) {
        this.drawDividerBorder = draw;
    }

    public Color getDividerBorderColor() {
        return this.dividerBorderColor;
    }

    public void setDividerBorderColor(Color color) {
        this.dividerBorderColor = color;
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new BasicSplitPaneDivider(this){
            protected final Border border;
            protected final Color color;
            protected final Color[] gradient;
            {
                this.border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
                this.color = new Color(158, 158, 158);
                this.gradient = new Color[]{StyleConstants.transparent, this.color, this.color, StyleConstants.transparent};
            }

            @Override
            public Border getBorder() {
                return this.border;
            }

            @Override
            protected JButton createLeftOneTouchButton() {
                boolean hor = this.orientation == 1;
                ImageIcon icon = WebSplitPaneUI.this.getOneTouchIcon(true, hor);
                WebButton iconWebButton = new WebButton(StyleId.splitpaneOneTouchLeftButton.at(this.splitPane), (Icon)icon);
                iconWebButton.setCursor(Cursor.getDefaultCursor());
                iconWebButton.setPreferredSize(WebSplitPaneUI.this.getOneTouchButtonSize(hor));
                return iconWebButton;
            }

            @Override
            protected JButton createRightOneTouchButton() {
                boolean hor = this.orientation == 1;
                ImageIcon icon = WebSplitPaneUI.this.getOneTouchIcon(false, hor);
                WebButton iconWebButton = new WebButton(StyleId.splitpaneOneTouchRightButton.at(this.splitPane), (Icon)icon);
                iconWebButton.setCursor(Cursor.getDefaultCursor());
                iconWebButton.setPreferredSize(WebSplitPaneUI.this.getOneTouchButtonSize(hor));
                return iconWebButton;
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
                if (this.orientation == 1) {
                    int startY = this.getHeight() / 2 - 35;
                    int endY = this.getHeight() / 2 + 35;
                    g2d.setPaint(new LinearGradientPaint(0.0f, startY, 0.0f, endY, new float[]{0.0f, 0.25f, 0.75f, 1.0f}, this.gradient));
                    for (int i = startY; i < endY; i += 5) {
                        g2d.fillRect(this.getWidth() / 2 - 1, i - 1, 2, 2);
                    }
                    if (WebSplitPaneUI.this.drawDividerBorder) {
                        g2d.setPaint(WebSplitPaneUI.this.dividerBorderColor);
                        g2d.drawLine(0, 0, 0, this.getHeight() - 1);
                        g2d.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
                    }
                } else {
                    int startX = this.getWidth() / 2 - 35;
                    int endX = this.getWidth() / 2 + 35;
                    g2d.setPaint(new LinearGradientPaint(startX, 0.0f, endX, 0.0f, new float[]{0.0f, 0.25f, 0.75f, 1.0f}, this.gradient));
                    for (int i = startX; i < endX; i += 5) {
                        g2d.fillRect(i - 1, this.getHeight() / 2 - 1, 2, 2);
                    }
                    if (WebSplitPaneUI.this.drawDividerBorder) {
                        g2d.setPaint(WebSplitPaneUI.this.dividerBorderColor);
                        g2d.drawLine(0, 0, this.getWidth() - 1, 0);
                        g2d.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
                    }
                }
                super.paint(g);
                GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                if (e.getSource() == this.splitPane && e.getPropertyName().equals("orientation")) {
                    boolean hor;
                    boolean bl = hor = this.orientation == 1;
                    if (this.leftButton != null) {
                        this.leftButton.setIcon(WebSplitPaneUI.this.getOneTouchIcon(true, hor));
                        this.leftButton.setPreferredSize(WebSplitPaneUI.this.getOneTouchButtonSize(hor));
                    }
                    if (this.rightButton != null) {
                        this.rightButton.setIcon(WebSplitPaneUI.this.getOneTouchIcon(false, hor));
                        this.rightButton.setPreferredSize(WebSplitPaneUI.this.getOneTouchButtonSize(hor));
                    }
                }
            }
        };
    }

    protected ImageIcon getOneTouchIcon(boolean leading, boolean horizontal) {
        String name = horizontal ? (leading ? "left" : "right") : (leading ? "up" : "down");
        return ImageUtils.getImageIcon((URL)WebSplitPaneUI.class.getResource("icons/" + name + ".png"), (boolean)true);
    }

    protected Dimension getOneTouchButtonSize(boolean horizontal) {
        return new Dimension(horizontal ? 6 : 7, horizontal ? 7 : 6);
    }

    @Override
    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            @Override
            public void paint(Graphics g) {
                if (!WebSplitPaneUI.this.isContinuousLayout() && WebSplitPaneUI.this.getLastDragLocation() != -1) {
                    Dimension size = WebSplitPaneUI.this.splitPane.getSize();
                    g.setColor(WebSplitPaneUI.this.dragDividerColor);
                    if (WebSplitPaneUI.this.getOrientation() == 1) {
                        g.fillRect(0, 0, WebSplitPaneUI.this.dividerSize - 1, size.height - 1);
                    } else {
                        g.fillRect(0, 0, size.width - 1, WebSplitPaneUI.this.dividerSize - 1);
                    }
                }
            }
        };
    }

    @Override
    public void finishedPaintingChildren(JSplitPane jc, Graphics g) {
        if (jc == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            Dimension size = this.splitPane.getSize();
            g.setColor(this.dragDividerColor);
            if (this.getOrientation() == 1) {
                g.fillRect(this.getLastDragLocation(), 0, this.dividerSize - 1, size.height - 1);
            } else {
                g.fillRect(0, this.getLastDragLocation(), size.width - 1, this.dividerSize - 1);
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            super.paint(g, c);
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

