/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.extended.tree.WebCheckBoxTree;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.AdaptiveTreePainter;
import com.alee.laf.tree.ITreePainter;
import com.alee.laf.tree.TreePainter;
import com.alee.laf.tree.TreePathHoverBehavior;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.laf.tree.WebTreeCellRenderer;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.ImageUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class WebTreeUI
extends BasicTreeUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    public static ImageIcon EXPAND_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/expand.png"));
    public static ImageIcon COLLAPSE_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/collapse.png"));
    public static ImageIcon DISABLED_EXPAND_ICON = ImageUtils.createDisabledCopy((ImageIcon)EXPAND_ICON);
    public static ImageIcon DISABLED_COLLAPSE_ICON = ImageUtils.createDisabledCopy((ImageIcon)COLLAPSE_ICON);
    public static ImageIcon ROOT_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/root.png"));
    public static ImageIcon CLOSED_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/closed.png"));
    public static ImageIcon OPEN_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/open.png"));
    public static ImageIcon LEAF_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/leaf.png"));
    protected TreeSelectionStyle selectionStyle;
    protected boolean expandSelected;
    protected boolean selectOnHover;
    @DefaultPainter(value=TreePainter.class)
    protected ITreePainter painter;
    protected TreePathHoverBehavior hoverNodeTracker;
    protected Insets margin = null;
    protected Insets padding = null;
    protected int hoverRow = -1;

    public static ComponentUI createUI(JComponent c) {
        return new WebTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (!WebLookAndFeel.isInstalled()) {
            this.setRightChildIndent(12);
            this.setLeftChildIndent(12);
        }
        this.tree.setRowHeight(-1);
        this.tree.setDropMode(DropMode.ON);
        this.tree.setVisibleRowCount(10);
        this.tree.setInvokesStopCellEditing(true);
        this.hoverNodeTracker = new TreePathHoverBehavior(this.tree, true){

            @Override
            public void hoverChanged(TreePath previous, TreePath current) {
                ToolTipProvider<? extends WebTree> provider;
                int previousRow = WebTreeUI.this.hoverRow;
                int n = WebTreeUI.this.hoverRow = current != null ? WebTreeUI.this.tree.getRowForPath(current) : -1;
                if (WebTreeUI.this.selectOnHover) {
                    if (current != null) {
                        WebTreeUI.this.tree.setSelectionPath(current);
                    } else {
                        WebTreeUI.this.tree.clearSelection();
                    }
                }
                if (WebTreeUI.this.painter != null && WebTreeUI.this.painter.isHoverDecorationSupported()) {
                    this.repaintRow(previousRow);
                    this.repaintRow(WebTreeUI.this.hoverRow);
                }
                if ((provider = WebTreeUI.this.getToolTipProvider()) != null) {
                    provider.hoverCellChanged((WebTree)WebTreeUI.this.tree, previousRow, 0, WebTreeUI.this.hoverRow, 0);
                }
                if (WebTreeUI.this.tree instanceof WebTree) {
                    DefaultMutableTreeNode p = previous != null ? (DefaultMutableTreeNode)previous.getLastPathComponent() : null;
                    DefaultMutableTreeNode c = current != null ? (DefaultMutableTreeNode)current.getLastPathComponent() : null;
                    ((WebTree)WebTreeUI.this.tree).fireHoverChanged(p, c);
                }
            }

            private void repaintRow(int row) {
                Rectangle rowBounds;
                if (row != -1 && (rowBounds = WebTreeUI.this.getFullRowBounds(row)) != null) {
                    WebTreeUI.this.tree.repaint(rowBounds);
                }
            }
        };
        this.hoverNodeTracker.install();
        StyleManager.installSkin(this.tree);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.tree);
        this.hoverNodeTracker.uninstall();
        this.hoverNodeTracker = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.tree);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.tree, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.tree, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.tree, new DataRunnable<ITreePainter>(){

            public void run(ITreePainter newPainter) {
                WebTreeUI.this.painter = newPainter;
            }
        }, this.painter, painter, ITreePainter.class, AdaptiveTreePainter.class);
    }

    public int getHoverRow() {
        return this.hoverRow;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.prepareToPaint(this.drawingCache, this.currentCellRenderer);
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    public int getRowForPoint(Point point) {
        return this.getRowForPoint(point, this.isFullLineSelection());
    }

    public int getRowForPoint(Point point, boolean countFullRow) {
        Enumeration<TreePath> visiblePaths;
        if (this.tree != null && (visiblePaths = this.getVisiblePaths()) != null) {
            while (visiblePaths.hasMoreElements()) {
                TreePath treePath = visiblePaths.nextElement();
                Rectangle bounds = this.getFullPathBounds(treePath, countFullRow);
                if (bounds == null || !bounds.contains(point)) continue;
                return this.getRowForPath(this.tree, treePath);
            }
        }
        return -1;
    }

    public Rectangle getRowBounds(int row) {
        return this.getRowBounds(row, this.isFullLineSelection());
    }

    public Rectangle getRowBounds(int row, boolean countFullRow) {
        return countFullRow ? this.getFullRowBounds(row) : this.getPathBounds(this.tree, this.getPathForRow(this.tree, row));
    }

    public Rectangle getFullRowBounds(int row) {
        return this.getFullPathBounds(this.getPathForRow(this.tree, row));
    }

    public Rectangle getFullPathBounds(TreePath path, boolean countFullRow) {
        return countFullRow ? this.getFullPathBounds(path) : this.getPathBounds(this.tree, path);
    }

    private Rectangle getFullPathBounds(TreePath path) {
        Rectangle b = this.getPathBounds(this.tree, path);
        if (b != null) {
            Insets insets = this.tree.getInsets();
            b.x = insets.left;
            b.width = this.tree.getWidth() - insets.left - insets.right;
        }
        return b;
    }

    public Enumeration<TreePath> getVisiblePaths() {
        if (this.tree.isShowing()) {
            Rectangle paintBounds = this.tree.getVisibleRect();
            TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
            if (initialPath != null) {
                return this.treeState.getVisiblePathsFrom(initialPath);
            }
        }
        return null;
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        return new WebTreeCellEditor();
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WebTreeCellRenderer();
    }

    @Override
    protected void selectPathForEvent(TreePath path, MouseEvent e) {
        if (!this.isLocationInCheckBoxControl(path, e.getX(), e.getY())) {
            super.selectPathForEvent(path, e);
        }
    }

    public boolean isLocationInCheckBoxControl(TreePath path, int x, int y) {
        if (this.tree instanceof WebCheckBoxTree) {
            WebCheckBoxTree checkBoxTree = (WebCheckBoxTree)this.tree;
            if (checkBoxTree.isCheckingByUserEnabled()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (checkBoxTree.isCheckBoxVisible(node) && checkBoxTree.isCheckBoxEnabled(node)) {
                    Rectangle checkBoxBounds = checkBoxTree.getCheckBoxBounds(path);
                    return checkBoxBounds != null && checkBoxBounds.contains(x, y);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    protected ToolTipProvider<? extends WebTree> getToolTipProvider() {
        return this.tree instanceof WebTree ? ((WebTree)this.tree).getToolTipProvider() : null;
    }

    @Override
    public Icon getExpandedIcon() {
        return this.tree.isEnabled() ? COLLAPSE_ICON : DISABLED_COLLAPSE_ICON;
    }

    @Override
    public Icon getCollapsedIcon() {
        return this.tree.isEnabled() ? EXPAND_ICON : DISABLED_EXPAND_ICON;
    }

    public CellRendererPane getCellRendererPane() {
        return this.rendererPane;
    }

    public AbstractLayoutCache getTreeState() {
        return this.treeState;
    }

    public TreeSelectionStyle getSelectionStyle() {
        return this.selectionStyle;
    }

    public void setSelectionStyle(TreeSelectionStyle style) {
        this.selectionStyle = style;
    }

    public boolean isExpandSelected() {
        return this.expandSelected;
    }

    public void setExpandSelected(boolean expandSelected) {
        this.expandSelected = expandSelected;
    }

    public boolean isSelectOnHover() {
        return this.selectOnHover;
    }

    public void setSelectOnHover(boolean select) {
        this.selectOnHover = select;
    }

    protected boolean isFullLineSelection() {
        return this.selectionStyle == TreeSelectionStyle.line;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

