/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.api.IconSupport;
import com.alee.api.TitleSupport;
import com.alee.managers.log.Log;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfoConverter;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

@XStreamAlias(value="skin")
@XStreamConverter(value=SkinInfoConverter.class)
public final class SkinInfo
implements IconSupport,
TitleSupport,
Serializable {
    private String id;
    private Icon icon;
    private String title;
    private String description;
    private String author;
    private String supportedSystems;
    @XStreamAlias(value="class")
    private String skinClass;
    @XStreamImplicit
    private List<ComponentStyle> styles;
    private transient Map<StyleableComponent, Map<String, ComponentStyle>> stylesCache;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Icon getIcon() {
        return this.icon != null ? this.icon : this.getDefaultIcon();
    }

    protected Icon getDefaultIcon() {
        Class skinClass = ReflectUtils.getClassSafely((String)this.getSkinClass());
        URL resource = skinClass != null ? skinClass.getResource("icons/icon.png") : null;
        return resource != null ? new ImageIcon(resource) : null;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSupportedSystems() {
        return this.supportedSystems;
    }

    public List<String> getSupportedSystemsList() {
        return TextUtils.stringToList((String)this.supportedSystems, (String)",");
    }

    public void setSupportedSystems(String supportedSystems) {
        this.supportedSystems = supportedSystems;
    }

    public void setSupportedSystems(List<String> supportedSystems) {
        this.supportedSystems = TextUtils.listToString(supportedSystems, (String)",");
    }

    public String getSkinClass() {
        return this.skinClass;
    }

    public void setSkinClass(String skinClass) {
        this.skinClass = skinClass;
    }

    public List<ComponentStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(List<ComponentStyle> styles) {
        this.styles = styles;
    }

    public Map<StyleableComponent, Map<String, ComponentStyle>> getStylesCache() {
        return this.stylesCache;
    }

    public void setStylesCache(Map<StyleableComponent, Map<String, ComponentStyle>> stylesCache) {
        this.stylesCache = stylesCache;
    }

    public ComponentStyle getStyle(JComponent component, StyleableComponent type) {
        Map<String, ComponentStyle> componentStyles = this.stylesCache.get((Object)type);
        if (componentStyles != null) {
            String styleId = StyleId.getCompleteId(component);
            ComponentStyle style = componentStyles.get(styleId);
            if (style != null) {
                return style;
            }
            String warn = "Unable to find style for ID \"%s\" for component: %s";
            Log.warn((Object)this, (String)String.format("Unable to find style for ID \"%s\" for component: %s", styleId, component.getClass().getName()));
            String defaultStyleId = type.getDefaultStyleId().getCompleteId();
            ComponentStyle defaultStyle = componentStyles.get(defaultStyleId);
            if (defaultStyle != null) {
                return defaultStyle;
            }
            String error = "Unable to find default style for ID \"%s\" for component: %s";
            throw new StyleException(String.format("Unable to find default style for ID \"%s\" for component: %s", defaultStyleId, component.getClass().getName()));
        }
        String error = "Skin \"%s\" doesn't support component type: %s";
        throw new StyleException(String.format("Skin \"%s\" doesn't support component type: %s", this.getTitle(), type.name()));
    }
}

