/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.api.Mergeable;
import com.alee.laf.grouping.GroupingLayout;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.PainterShapeProvider;
import com.alee.painter.AbstractPainter;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.MergeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.AbstractHoverBehavior;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractDecorationPainter<E extends JComponent, U extends ComponentUI, D extends IDecoration<E, D>>
extends AbstractPainter<E, U>
implements PainterShapeProvider<E> {
    public static final String DECORATION_STATES_PROPERTY = "decorationStates";
    protected List<D> decorations;
    protected transient FocusTracker focusStateTracker;
    protected transient AbstractHoverBehavior<E> hoverStateTracker;
    protected transient HierarchyListener hierarchyTracker;
    protected transient ContainerListener neighboursTracker;
    protected transient List<String> states;
    protected transient Map<String, D> decorationCache;
    protected transient boolean focused = false;
    protected transient boolean hover = false;
    protected transient Container ancestor;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.states = this.collectDecorationStates();
        this.installFocusListener();
        this.installHoverListener();
        this.installHierarchyListener();
    }

    @Override
    public void uninstall(E c, U ui) {
        this.uninstallHierarchyListener();
        this.uninstallHoverListener();
        this.uninstallFocusListener();
        this.decorationCache = null;
        this.states = null;
        super.uninstall(c, ui);
    }

    @Override
    protected void propertyChange(String property, Object oldValue, Object newValue) {
        super.propertyChange(property, oldValue, newValue);
        if (this.isSettingsUpdateAllowed()) {
            if (CompareUtils.equals((Object)property, (Object[])new Object[]{"enabled"}) && (this.usesState("enabled") || this.usesState("disabled"))) {
                this.updateDecorationState();
            }
            if (CompareUtils.equals((Object)property, (Object[])new Object[]{DECORATION_STATES_PROPERTY})) {
                this.updateDecorationState();
            }
        }
    }

    protected void installFocusListener() {
        if (this.usesState("focused")) {
            this.focusStateTracker = new DefaultFocusTracker(){

                @Override
                public void focusChanged(boolean focused) {
                    AbstractDecorationPainter.this.focused = focused;
                    if (AbstractDecorationPainter.this.isSettingsUpdateAllowed()) {
                        AbstractDecorationPainter.this.updateDecorationState();
                    }
                }
            };
            FocusManager.addFocusTracker(this.component, this.focusStateTracker);
        }
    }

    protected void uninstallFocusListener() {
        if (this.focusStateTracker != null) {
            FocusManager.removeFocusTracker(this.focusStateTracker);
            this.focusStateTracker = null;
        }
    }

    protected boolean isFocused() {
        return this.focused;
    }

    protected void installHoverListener() {
        if (this.usesState("hover")) {
            this.hoverStateTracker = new AbstractHoverBehavior<E>(this.component, false){

                @Override
                public void hoverChanged(boolean hover) {
                    AbstractDecorationPainter.this.hover = hover;
                    if (AbstractDecorationPainter.this.isSettingsUpdateAllowed()) {
                        AbstractDecorationPainter.this.updateDecorationState();
                    }
                }
            };
            this.hoverStateTracker.install();
        }
    }

    protected void uninstallHoverListener() {
        if (this.hoverStateTracker != null) {
            this.hoverStateTracker.uninstall();
            this.hoverStateTracker = null;
        }
    }

    protected void installHierarchyListener() {
        this.neighboursTracker = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (AbstractDecorationPainter.this.ancestor != null && AbstractDecorationPainter.this.ancestor.getLayout() instanceof GroupingLayout && e.getChild() != AbstractDecorationPainter.this.component) {
                    AbstractDecorationPainter.this.updateBorder();
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (AbstractDecorationPainter.this.ancestor != null && AbstractDecorationPainter.this.ancestor.getLayout() instanceof GroupingLayout && e.getChild() != AbstractDecorationPainter.this.component) {
                    AbstractDecorationPainter.this.updateBorder();
                }
            }
        };
        this.hierarchyTracker = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 1L) == 1L) {
                    if (AbstractDecorationPainter.this.ancestor != null) {
                        AbstractDecorationPainter.this.ancestor.removeContainerListener(AbstractDecorationPainter.this.neighboursTracker);
                    }
                    AbstractDecorationPainter.this.ancestor = AbstractDecorationPainter.this.component.getParent();
                    if (AbstractDecorationPainter.this.ancestor != null) {
                        AbstractDecorationPainter.this.ancestor.addContainerListener(AbstractDecorationPainter.this.neighboursTracker);
                        AbstractDecorationPainter.this.updateBorder();
                    }
                }
            }
        };
        this.component.addHierarchyListener(this.hierarchyTracker);
    }

    protected void uninstallHierarchyListener() {
        this.component.removeHierarchyListener(this.hierarchyTracker);
        this.hierarchyTracker = null;
        if (this.ancestor != null) {
            this.ancestor.removeContainerListener(this.neighboursTracker);
            this.ancestor = null;
        }
        this.neighboursTracker = null;
    }

    protected boolean isHover() {
        return this.hover;
    }

    protected List<SectionPainter<E, U>> getSectionPainters() {
        return null;
    }

    protected final List<SectionPainter<E, U>> asList(SectionPainter<E, U> ... sections) {
        ArrayList<SectionPainter<E, U>> list = null;
        if (sections != null) {
            for (SectionPainter<E, U> section : sections) {
                if (section == null) continue;
                if (list == null) {
                    list = new ArrayList<SectionPainter<E, U>>(sections.length);
                }
                list.add(section);
            }
        }
        return list;
    }

    protected boolean isEnabled() {
        return this.component != null && this.component.isEnabled();
    }

    protected final List<String> collectDecorationStates() {
        List<String> componentStates;
        List<String> uiStates;
        List<String> states = this.getDecorationStates();
        if (this.ui instanceof Stateful && !CollectionUtils.isEmpty(uiStates = ((Stateful)((Object)this.ui)).getStates())) {
            states.addAll(uiStates);
        }
        if (this.component instanceof Stateful && !CollectionUtils.isEmpty(componentStates = ((Stateful)((Object)this.component)).getStates())) {
            states.addAll(componentStates);
        }
        Collections.sort(states);
        return states;
    }

    protected List<String> getDecorationStates() {
        ArrayList<String> states = new ArrayList<String>();
        states.add(SystemUtils.getShortOsName());
        states.add(this.isEnabled() ? "enabled" : "disabled");
        if (this.isFocused()) {
            states.add("focused");
        }
        if (this.isHover()) {
            states.add("hover");
        }
        return states;
    }

    protected boolean usesState(String state) {
        List<SectionPainter<E, U>> sectionPainters;
        boolean usesState = this.usesState(this.decorations, state);
        if (!usesState && !CollectionUtils.isEmpty(sectionPainters = this.getSectionPainters())) {
            for (SectionPainter<E, U> section : sectionPainters) {
                if (!(section instanceof AbstractDecorationPainter) || !this.usesState(((AbstractDecorationPainter)((Object)section)).decorations, state)) continue;
                usesState = true;
                break;
            }
        }
        return usesState;
    }

    protected final boolean usesState(List<D> decorations, String state) {
        if (!CollectionUtils.isEmpty(decorations)) {
            for (IDecoration decoration : decorations) {
                List<String> states = decoration.getStates();
                if (states == null || !states.contains(state)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<D> getDecorations(List<String> forStates) {
        if (!CollectionUtils.isEmpty(this.decorations)) {
            ArrayList<IDecoration> d = new ArrayList<IDecoration>(1);
            for (IDecoration decoration : this.decorations) {
                List<String> states = decoration.getStates();
                if (!CollectionUtils.isEmpty(states)) {
                    boolean containsAll = true;
                    for (String state : states) {
                        if (!CollectionUtils.isEmpty(forStates) && forStates.contains(state)) continue;
                        containsAll = false;
                        break;
                    }
                    if (!containsAll) continue;
                    d.add(decoration);
                    continue;
                }
                d.add(decoration);
            }
            return d;
        }
        return null;
    }

    protected D getDecoration() {
        if (!CollectionUtils.isEmpty(this.decorations)) {
            String key = TextUtils.listToString(this.states, (String)",");
            if (this.decorationCache == null) {
                this.decorationCache = new HashMap<String, D>(this.decorations.size());
            }
            if (!this.decorationCache.containsKey(key)) {
                IDecoration decoration;
                List<D> decorations = this.getDecorations(this.states);
                if (CollectionUtils.isEmpty(decorations)) {
                    decoration = null;
                } else if (decorations.size() == 1) {
                    decoration = (IDecoration)MergeUtils.clone(decorations.get(0));
                } else {
                    decoration = (IDecoration)MergeUtils.clone(decorations.get(0));
                    for (int i = 1; i < decorations.size(); ++i) {
                        decoration.merge((Mergeable)decorations.get(i));
                    }
                }
                if (decoration != null) {
                    decoration.setSection(this.isSectionPainter());
                }
                this.decorationCache.put(key, decoration);
            }
            return (D)((IDecoration)this.decorationCache.get(key));
        }
        return null;
    }

    protected void updateDecorationState() {
        List<String> states = this.collectDecorationStates();
        if (!CollectionUtils.equals(this.states, states)) {
            this.states = states;
            List<SectionPainter<E, U>> sectionPainters = this.getSectionPainters();
            if (!CollectionUtils.isEmpty(sectionPainters)) {
                for (SectionPainter<E, U> section : sectionPainters) {
                    if (!(section instanceof AbstractDecorationPainter)) continue;
                    ((AbstractDecorationPainter)((Object)section)).updateDecorationState();
                }
            }
            if (this.isSettingsUpdateAllowed()) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    public boolean isDecorated() {
        D decoration = this.getDecoration();
        return decoration != null && decoration.isVisible();
    }

    @Override
    public Insets getBorders() {
        D decoration = this.getDecoration();
        return decoration != null ? decoration.getBorderInsets((JComponent)this.component) : null;
    }

    @Override
    public Shape provideShape(E component, Rectangle bounds) {
        D decoration = this.getDecoration();
        return decoration != null ? decoration.provideShape(component, bounds) : bounds;
    }

    @Override
    public Boolean isOpaque() {
        D decoration = this.getDecoration();
        return decoration != null ? this.isOpaqueDecorated() : this.isOpaqueUndecorated();
    }

    protected Boolean isOpaqueDecorated() {
        return false;
    }

    protected Boolean isOpaqueUndecorated() {
        return null;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        D decoration;
        Rectangle b = this.adjustBounds(bounds);
        if (this.isPlainBackgroundPaintAllowed(c)) {
            g2d.setPaint(((Component)c).getBackground());
            g2d.fill(this.isSectionPainter() ? b : Bounds.component.of((Component)c, b));
        }
        if (this.isDecorationPaintAllowed(decoration = this.getDecoration())) {
            decoration.paint(g2d, this.isSectionPainter() ? Bounds.margin.of((JComponent)c, (IDecoration)decoration, b) : Bounds.margin.of((Component)c, b), c);
        }
        this.paintContent(g2d, b, c, ui);
    }

    protected Rectangle adjustBounds(Rectangle bounds) {
        return bounds;
    }

    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
    }

    protected boolean isPlainBackgroundPaintAllowed(E c) {
        return ((JComponent)c).isOpaque();
    }

    protected boolean isDecorationPaintAllowed(D decoration) {
        return decoration != null && decoration.isVisible();
    }

    @Override
    public Dimension getPreferredSize() {
        return SwingUtils.max(this.getDecorationSize(), super.getPreferredSize());
    }

    protected Dimension getDecorationSize() {
        D decoration = this.getDecoration();
        return decoration != null ? decoration.getPreferredSize() : null;
    }
}

