/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.lexical_db;

import edu.cmu.lti.jawjaw.db.SynlinkDAO;
import edu.cmu.lti.jawjaw.db.SynsetDAO;
import edu.cmu.lti.jawjaw.db.SynsetDefDAO;
import edu.cmu.lti.jawjaw.pobj.Lang;
import edu.cmu.lti.jawjaw.pobj.Link;
import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.jawjaw.pobj.Synlink;
import edu.cmu.lti.jawjaw.pobj.Synset;
import edu.cmu.lti.jawjaw.pobj.SynsetDef;
import edu.cmu.lti.jawjaw.util.WordNetUtil;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.util.PorterStemmer;
import edu.cmu.lti.ws4j.util.WS4JConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NictWordNet
implements ILexicalDatabase {
    private static ConcurrentMap<String, List<String>> cache;
    private static PorterStemmer stemmer;

    public Collection<Concept> getAllConcepts(String word, String posText) {
        POS pos = POS.valueOf((String)posText);
        List synsets = WordNetUtil.wordToSynsets((String)word, (POS)pos);
        ArrayList<Concept> synsetStrings = new ArrayList<Concept>(synsets.size());
        for (Synset synset : synsets) {
            synsetStrings.add(new Concept(synset.getSynset(), POS.valueOf((String)pos.toString())));
        }
        return synsetStrings;
    }

    public Collection<String> getHypernyms(String synset) {
        List links = SynlinkDAO.findSynlinksBySynsetAndLink((String)synset, (Link)Link.hype);
        ArrayList<String> hypernyms = new ArrayList<String>();
        for (Synlink link : links) {
            hypernyms.add(link.getSynset2());
        }
        return hypernyms;
    }

    public Concept getMostFrequentConcept(String word, String pos) {
        Collection<Concept> concepts = this.getAllConcepts(word, pos);
        return concepts.size() > 0 ? concepts.iterator().next() : null;
    }

    public Concept findSynsetBySynset(String synset) {
        return null;
    }

    public String conceptToString(String synset) {
        return null;
    }

    public List<String> getGloss(Concept synset, String linkString) {
        List cachedObj;
        String key = synset + " " + linkString;
        if (WS4JConfiguration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return this.clone(cachedObj);
        }
        ArrayList<String> linkedSynsets = new ArrayList<String>();
        Link link = null;
        try {
            link = Link.valueOf((String)linkString);
            if (link.equals((Object)Link.mero)) {
                linkedSynsets.addAll(this.linkToSynsets(synset.getSynset(), Link.mmem));
                linkedSynsets.addAll(this.linkToSynsets(synset.getSynset(), Link.msub));
                linkedSynsets.addAll(this.linkToSynsets(synset.getSynset(), Link.mprt));
            } else if (link.equals((Object)Link.holo)) {
                linkedSynsets.addAll(this.linkToSynsets(synset.getSynset(), Link.hmem));
                linkedSynsets.addAll(this.linkToSynsets(synset.getSynset(), Link.hsub));
                linkedSynsets.addAll(this.linkToSynsets(synset.getSynset(), Link.hprt));
            } else if (link.equals((Object)Link.syns)) {
                linkedSynsets.add(synset.getSynset());
            } else {
                linkedSynsets.addAll(this.linkToSynsets(synset.getSynset(), link));
            }
        }
        catch (IllegalArgumentException e) {
            linkedSynsets.add(synset.getSynset());
        }
        ArrayList<String> glosses = new ArrayList<String>(linkedSynsets.size());
        for (String linkedSynset : linkedSynsets) {
            String gloss = null;
            if (Link.syns.equals((Object)link)) {
                gloss = synset.getName();
                if (gloss == null) {
                    gloss = SynsetDAO.findSynsetBySynset((String)linkedSynset).getName();
                }
            } else {
                SynsetDef synsetDef = SynsetDefDAO.findSynsetDefBySynsetAndLang((String)linkedSynset, (Lang)Lang.eng);
                gloss = WordNetUtil.getGloss((SynsetDef)synsetDef);
            }
            if (gloss == null) continue;
            gloss = gloss.replaceAll("[.;:,?!(){}\"`$%@<>]", " ");
            gloss = gloss.replaceAll("&", " and ");
            gloss = gloss.replaceAll("_", " ");
            gloss = gloss.replaceAll("[ ]+", " ");
            gloss = gloss.replaceAll("(?<!\\w)'", " ");
            gloss = gloss.replaceAll("'(?!\\w)", " ");
            gloss = gloss.replaceAll("--", " ");
            gloss = gloss.toLowerCase();
            if (WS4JConfiguration.getInstance().useStem()) {
                gloss = stemmer.stemSentence(gloss);
            }
            glosses.add(gloss);
        }
        if (WS4JConfiguration.getInstance().useCache()) {
            if (cache.size() >= WS4JConfiguration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (glosses != null) {
                cache.put(key, this.clone(glosses));
            }
        }
        return glosses;
    }

    private List<String> clone(List<String> original) {
        return new ArrayList<String>(original);
    }

    private List<String> linkToSynsets(String synset, Link link) {
        ArrayList<String> linkedSynsets = new ArrayList<String>();
        List synlinks = SynlinkDAO.findSynlinksBySynsetAndLink((String)synset, (Link)link);
        for (Synlink synlink : synlinks) {
            linkedSynsets.add(synlink.getSynset2());
        }
        return linkedSynsets;
    }

    static {
        if (WS4JConfiguration.getInstance().useCache()) {
            cache = new ConcurrentHashMap<String, List<String>>(WS4JConfiguration.getInstance().getMaxCacheSize());
        }
        if (WS4JConfiguration.getInstance().useStem()) {
            stemmer = new PorterStemmer();
        }
    }
}

