/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.jawjaw.util.Configuration;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.util.DepthFinder;
import edu.cmu.lti.ws4j.util.MatrixCalculator;
import edu.cmu.lti.ws4j.util.PathFinder;
import edu.cmu.lti.ws4j.util.WS4JConfiguration;
import edu.cmu.lti.ws4j.util.WordSimilarityCalculator;
import java.util.List;

public abstract class RelatednessCalculator {
    private static final WS4JConfiguration c = WS4JConfiguration.getInstance();
    public static final boolean enableCache = c.useCache();
    public static final boolean enableTrace = c.useTrace();
    protected static final String illegalSynset = "Synset is null.";
    protected static final String identicalSynset = "Synsets are identical.";
    protected ILexicalDatabase db;
    protected PathFinder pathFinder;
    protected DepthFinder depthFinder;
    public static final boolean useRootNode = true;
    private WordSimilarityCalculator wordSimilarity = new WordSimilarityCalculator();

    public RelatednessCalculator(ILexicalDatabase db) {
        this.db = db;
        this.pathFinder = new PathFinder(db);
        this.depthFinder = new DepthFinder(db);
    }

    protected abstract Relatedness calcRelatedness(Concept var1, Concept var2);

    public abstract List<POS[]> getPOSPairs();

    public Relatedness calcRelatednessOfSynset(Concept synset1, Concept synset2) {
        long t0 = System.currentTimeMillis();
        Relatedness r = this.calcRelatedness(synset1, synset2);
        long t1 = System.currentTimeMillis();
        r.appendTrace("Process done in = " + (double)(t1 - t0) / 1000.0 + " sec (cache: " + (Configuration.getInstance().useCache() ? "enabled" : "disabled") + ").\n");
        return r;
    }

    public double calcRelatednessOfWords(String word1, String word2) {
        return this.wordSimilarity.calcRelatednessOfWords(word1, word2, this);
    }

    public double[][] getSimilarityMatrix(String[] words1, String[] words2) {
        return MatrixCalculator.getSimilarityMatrix(words1, words2, this);
    }

    public double[][] getNormalizedSimilarityMatrix(String[] words1, String[] words2) {
        return MatrixCalculator.getNormalizedSimilarityMatrix(words1, words2, this);
    }

    public ILexicalDatabase getDB() {
        return this.db;
    }
}

