/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.impl;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.Traverser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class HirstStOnge
extends RelatednessCalculator {
    protected static double min = 0.0;
    protected static double max = 16.0;
    private static List<POS[]> posPairs = new ArrayList<POS[]>(){
        {
            this.add(new POS[]{POS.n, POS.n});
            this.add(new POS[]{POS.v, POS.v});
            this.add(new POS[]{POS.a, POS.a});
            this.add(new POS[]{POS.r, POS.r});
        }
    };

    public HirstStOnge(ILexicalDatabase db) {
        super(db);
    }

    @Override
    protected Relatedness calcRelatedness(Concept synset1, Concept synset2) {
        boolean inUpOrDown;
        boolean inHorizon;
        StringBuilder tracer = new StringBuilder();
        if (synset1 == null || synset2 == null) {
            return new Relatedness(min, null, "Synset is null.");
        }
        if (synset1.getSynset().equals(synset2.getSynset())) {
            return new Relatedness(max, "Synsets are identical.", null);
        }
        Set<String> horizontal1 = Traverser.getHorizontalSynsets(synset1.getSynset());
        Set<String> horizontal2 = Traverser.getHorizontalSynsets(synset2.getSynset());
        boolean bl = inHorizon = horizontal2.contains(synset1.getSynset()) || horizontal1.contains(synset2.getSynset());
        if (inHorizon) {
            return new Relatedness(max);
        }
        Set<String> upward2 = Traverser.getUpwardSynsets(synset2.getSynset());
        Set<String> downward2 = Traverser.getDownwardSynsets(synset2.getSynset());
        if (enableTrace) {
            tracer.append("Horizontal Links of " + synset1.getSynset() + ": " + horizontal1 + "\n");
            tracer.append("Horizontal Links of " + synset2.getSynset() + ": " + horizontal1 + "\n");
            tracer.append("Upward Links of " + synset2.getSynset() + ": " + upward2 + "\n");
            tracer.append("Downward Links of " + synset2.getSynset() + ": " + downward2 + "\n");
        }
        boolean contained = Traverser.contained(synset1, synset2);
        boolean bl2 = inUpOrDown = upward2.contains(synset1.getSynset()) || downward2.contains(synset1.getSynset());
        if (contained && inUpOrDown) {
            tracer.append("Strong Rel (Compound Word Match).\n");
            return new Relatedness(max, tracer.toString(), null);
        }
        MedStrong medStrong = new MedStrong();
        int score = medStrong.medStrong(0, 0, 0, synset1.getSynset(), synset1.getSynset(), synset2.getSynset());
        return new Relatedness(score, tracer.toString(), null);
    }

    @Override
    public List<POS[]> getPOSPairs() {
        return posPairs;
    }

    private static class MedStrong {
        private MedStrong() {
        }

        public int medStrong(int state, int distance, int chdir, String from, String path, String endSynset) {
            Set<String> downward;
            if (from.equals(endSynset) && distance > 1) {
                return 8 - distance - chdir;
            }
            if (distance >= 5) {
                return 0;
            }
            Set<String> horizontal = state != 4 || state != 7 ? Traverser.getHorizontalSynsets(from) : null;
            Set<String> upward = state == 0 || state == 1 ? Traverser.getUpwardSynsets(from) : null;
            Set<String> set = downward = state != 6 ? Traverser.getDownwardSynsets(from) : null;
            if (state == 0) {
                int retU = this.findU(upward, 1, distance, 0, path, endSynset);
                int retD = this.findD(downward, 2, distance, 0, path, endSynset);
                int retH = this.findH(horizontal, 3, distance, 0, path, endSynset);
                if (retU > retD && retU > retH) {
                    return retU;
                }
                if (retD > retH) {
                    return retD;
                }
                return retH;
            }
            if (state == 1) {
                int retU = this.findU(upward, 1, distance, 0, path, endSynset);
                int retD = this.findD(downward, 4, distance, 1, path, endSynset);
                int retH = this.findH(horizontal, 5, distance, 1, path, endSynset);
                if (retU > retD && retU > retH) {
                    return retU;
                }
                if (retD > retH) {
                    return retD;
                }
                return retH;
            }
            if (state == 2) {
                int retH;
                int retD = this.findD(downward, 2, distance, 0, path, endSynset);
                return retD > (retH = this.findH(horizontal, 6, distance, 0, path, endSynset)) ? retD : retH;
            }
            if (state == 3) {
                int retH;
                int retD = this.findD(downward, 7, distance, 0, path, endSynset);
                return retD > (retH = this.findH(horizontal, 3, distance, 0, path, endSynset)) ? retD : retH;
            }
            if (state == 4) {
                int retD = this.findD(downward, 4, distance, 1, path, endSynset);
                return retD;
            }
            if (state == 5) {
                int retH;
                int retD = this.findD(downward, 4, distance, 2, path, endSynset);
                return retD > (retH = this.findH(horizontal, 5, distance, 1, path, endSynset)) ? retD : retH;
            }
            if (state == 6) {
                int retH = this.findH(horizontal, 6, distance, 1, path, endSynset);
                return retH;
            }
            if (state == 7) {
                int retD = this.findD(downward, 7, distance, 1, path, endSynset);
                return retD;
            }
            return 0;
        }

        private int findD(Set<String> downward, int state, int distance, int chdir, String path, String endSynset) {
            return this.find(downward, state, distance, chdir, path, endSynset, "D");
        }

        private int findU(Set<String> upward, int state, int distance, int chdir, String path, String endSynset) {
            return this.find(upward, state, distance, chdir, path, endSynset, "U");
        }

        private int findH(Set<String> horizontal, int state, int distance, int chdir, String path, String endSynset) {
            return this.find(horizontal, state, distance, chdir, path, endSynset, "H");
        }

        private int find(Set<String> synsetGroup, int state, int distance, int chdir, String path, String endSynset, String abbreviation) {
            int ret = 0;
            for (String synset : synsetGroup) {
                int retT = this.medStrong(state, distance + 1, chdir, synset, path + " [" + abbreviation + "] " + synset, endSynset);
                if (retT <= ret) continue;
                ret = retT;
            }
            return ret;
        }
    }
}

