/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.impl;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.ICFinder;
import edu.cmu.lti.ws4j.util.PathFinder;
import java.util.ArrayList;
import java.util.List;

public class JiangConrath
extends RelatednessCalculator {
    protected static double min = 0.0;
    protected static double max = Double.MAX_VALUE;
    private static List<POS[]> posPairs = new ArrayList<POS[]>(){
        {
            this.add(new POS[]{POS.n, POS.n});
            this.add(new POS[]{POS.v, POS.v});
        }
    };

    public JiangConrath(ILexicalDatabase db) {
        super(db);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Relatedness calcRelatedness(Concept synset1, Concept synset2) {
        StringBuilder tracer = new StringBuilder();
        if (synset1 == null || synset2 == null) {
            return new Relatedness(min, null, "Synset is null.");
        }
        StringBuilder subTracer = enableTrace ? new StringBuilder() : null;
        List<PathFinder.Subsumer> lcsList = ICFinder.getInstance().getLCSbyIC(this.pathFinder, synset1, synset2, subTracer);
        if (lcsList.size() == 0) {
            return new Relatedness(min, tracer.toString(), null);
        }
        if (enableTrace) {
            tracer.append(subTracer.toString());
            for (PathFinder.Subsumer lcs : lcsList) {
                tracer.append("Lowest Common Subsumer(s): ");
                tracer.append(this.db.conceptToString(lcs.subsumer.getSynset()) + " (IC=" + lcs.ic + ")\n");
            }
        }
        PathFinder.Subsumer subsumer = lcsList.get(0);
        String lcsSynset = subsumer.subsumer.getSynset();
        double lcsIc = subsumer.ic;
        Concept rootSynset = this.pathFinder.getRoot(lcsSynset);
        rootSynset.setPos(subsumer.subsumer.getPos());
        int rootFreq = ICFinder.getInstance().getFrequency(rootSynset);
        if (rootFreq <= 0) {
            return new Relatedness(min, tracer.toString(), null);
        }
        double ic1 = ICFinder.getInstance().ic(this.pathFinder, synset1);
        double ic2 = ICFinder.getInstance().ic(this.pathFinder, synset2);
        if (enableTrace) {
            tracer.append("Concept1: " + this.db.conceptToString(synset1.getSynset()) + " (IC=" + ic1 + ")\n");
            tracer.append("Concept2: " + this.db.conceptToString(synset2.getSynset()) + " (IC=" + ic2 + ")\n");
        }
        double distance = 0.0;
        if (!(ic1 > 0.0) || !(ic2 > 0.0)) {
            return new Relatedness(min, tracer.toString(), null);
        }
        distance = ic1 + ic2 - 2.0 * lcsIc;
        double score = 0.0;
        if (distance == 0.0) {
            if (!((double)rootFreq > 0.01)) return new Relatedness(min, tracer.toString(), null);
            score = 1.0 / -Math.log(((double)rootFreq - 0.01) / (double)rootFreq);
            return new Relatedness(score, tracer.toString(), null);
        } else {
            score = 1.0 / distance;
        }
        return new Relatedness(score, tracer.toString(), null);
    }

    @Override
    public List<POS[]> getPOSPairs() {
        return posPairs;
    }
}

