/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.impl;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.PathFinder;
import java.util.ArrayList;
import java.util.List;

public class LeacockChodorow
extends RelatednessCalculator {
    protected static double min = 0.0;
    protected static double max = Double.MAX_VALUE;
    private static List<POS[]> posPairs = new ArrayList<POS[]>(){
        {
            this.add(new POS[]{POS.n, POS.n});
            this.add(new POS[]{POS.v, POS.v});
        }
    };

    public LeacockChodorow(ILexicalDatabase db) {
        super(db);
    }

    @Override
    protected Relatedness calcRelatedness(Concept synset1, Concept synset2) {
        StringBuilder tracer = new StringBuilder();
        if (synset1 == null || synset2 == null) {
            return new Relatedness(min, null, "Synset is null.");
        }
        StringBuilder subTracer = enableTrace ? new StringBuilder() : null;
        List<PathFinder.Subsumer> lcsList = this.pathFinder.getLCSByPath(synset1, synset2, subTracer);
        if (lcsList.size() == 0) {
            return new Relatedness(min);
        }
        int maxDepth = 1;
        if (synset1.getPos().equals((Object)POS.n)) {
            maxDepth = 20;
        } else if (synset1.getPos().equals((Object)POS.v)) {
            maxDepth = 14;
        }
        int length = lcsList.get((int)0).length;
        double score = -Math.log((double)length / (double)(2 * maxDepth));
        if (enableTrace) {
            tracer.append(subTracer.toString());
            for (PathFinder.Subsumer lcs : lcsList) {
                tracer.append("Lowest Common Subsumer(s): ");
                tracer.append(this.db.conceptToString(lcs.subsumer.getSynset()) + " (Length=" + lcs.length + ")\n");
            }
        }
        return new Relatedness(score, tracer.toString(), null);
    }

    @Override
    public List<POS[]> getPOSPairs() {
        return posPairs;
    }
}

