/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.impl;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.GlossFinder;
import edu.cmu.lti.ws4j.util.OverlapFinder;
import edu.cmu.lti.ws4j.util.WS4JConfiguration;
import java.util.ArrayList;
import java.util.List;

public class Lesk
extends RelatednessCalculator {
    protected static double min = 0.0;
    protected static double max = Double.MAX_VALUE;
    private GlossFinder glossFinder;
    private static List<POS[]> posPairs = new ArrayList<POS[]>(){
        {
            this.add(new POS[]{POS.n, POS.n});
            this.add(new POS[]{POS.v, POS.v});
            this.add(new POS[]{POS.a, POS.a});
            this.add(new POS[]{POS.r, POS.r});
            this.add(new POS[]{POS.n, POS.v});
            this.add(new POS[]{POS.v, POS.n});
        }
    };
    private StringBuilder overlapLog;
    private StringBuilder overlapLogMax;

    public Lesk(ILexicalDatabase db) {
        super(db);
        this.glossFinder = new GlossFinder(db);
    }

    @Override
    protected Relatedness calcRelatedness(Concept synset1, Concept synset2) {
        if (synset1 == null || synset2 == null) {
            return new Relatedness(min);
        }
        StringBuilder tracer = new StringBuilder();
        List<GlossFinder.SuperGloss> glosses = this.glossFinder.getSuperGlosses(synset1, synset2);
        int score = 0;
        for (int i = 0; i < glosses.size(); ++i) {
            GlossFinder.SuperGloss sg = glosses.get(i);
            double functionsScore = this.calcFromSuperGloss(sg.gloss1, sg.gloss2);
            functionsScore *= glosses.get((int)i).weight;
            if (enableTrace && functionsScore > 0.0) {
                tracer.append("Functions: " + sg.link1.trim() + " - " + sg.link2.trim() + " : " + functionsScore + "\n");
                tracer.append(this.overlapLogMax + "\n\n");
            }
            score = (int)((double)score + functionsScore);
        }
        return new Relatedness(score, tracer.toString(), null);
    }

    private double calcFromSuperGloss(List<String> glosses1, List<String> glosses2) {
        double max = 0.0;
        this.overlapLogMax = new StringBuilder();
        for (String gloss1 : glosses1) {
            for (String gloss2 : glosses2) {
                double score = this.calcFromSuperGloss(gloss1, gloss2);
                if (!(max < score)) continue;
                this.overlapLogMax = this.overlapLog;
                max = score;
            }
        }
        return max;
    }

    private double calcFromSuperGloss(String gloss1, String gloss2) {
        OverlapFinder.Overlaps overlaps = OverlapFinder.getOverlaps(gloss1, gloss2);
        double functionsScore = 0.0;
        if (enableTrace) {
            this.overlapLog = new StringBuilder("Overlaps: ");
        }
        for (String key : overlaps.overlapsHash.keySet()) {
            String[] tempArray = key.split("\\s+");
            int value = tempArray.length * tempArray.length * (Integer)overlaps.overlapsHash.get(key);
            functionsScore += (double)value;
            if (!enableTrace) continue;
            this.overlapLog.append(overlaps.overlapsHash.get(key) + " x \"" + key + "\" ");
        }
        if (enableTrace) {
            this.overlapLog = new StringBuilder("\n");
        }
        if (WS4JConfiguration.getInstance().useLeskNomalizer()) {
            int denominator = overlaps.length1 + overlaps.length2;
            if (denominator > 0) {
                functionsScore /= (double)denominator;
            }
            if (enableTrace) {
                this.overlapLog.append("Normalized by dividing the score with " + overlaps.length1 + " and " + overlaps.length2 + "\n");
            }
        }
        return functionsScore;
    }

    @Override
    public List<POS[]> getPOSPairs() {
        return posPairs;
    }
}

