/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.impl;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.ICFinder;
import edu.cmu.lti.ws4j.util.PathFinder;
import java.util.ArrayList;
import java.util.List;

public class Lin
extends RelatednessCalculator {
    protected static double min = 0.0;
    protected static double max = 1.0;
    private static List<POS[]> posPairs = new ArrayList<POS[]>(){
        {
            this.add(new POS[]{POS.n, POS.n});
            this.add(new POS[]{POS.v, POS.v});
        }
    };

    public Lin(ILexicalDatabase db) {
        super(db);
    }

    @Override
    protected Relatedness calcRelatedness(Concept synset1, Concept synset2) {
        double score;
        StringBuilder tracer = new StringBuilder();
        if (synset1 == null || synset2 == null) {
            return new Relatedness(min, null, "Synset is null.");
        }
        if (synset1.getSynset().equals(synset2.getSynset())) {
            return new Relatedness(max, "Synsets are identical.", null);
        }
        StringBuilder subTracer = enableTrace ? new StringBuilder() : null;
        List<PathFinder.Subsumer> lcsList = ICFinder.getInstance().getLCSbyIC(this.pathFinder, synset1, synset2, subTracer);
        if (lcsList.size() == 0) {
            return new Relatedness(min, tracer.toString(), null);
        }
        double ic1 = ICFinder.getInstance().ic(this.pathFinder, synset1);
        double ic2 = ICFinder.getInstance().ic(this.pathFinder, synset2);
        double d = score = ic1 > 0.0 && ic2 > 0.0 ? 2.0 * lcsList.get((int)0).ic / (ic1 + ic2) : 0.0;
        if (enableTrace) {
            tracer.append(subTracer.toString());
            for (PathFinder.Subsumer lcs : lcsList) {
                tracer.append("Lowest Common Subsumer(s): ");
                tracer.append(this.db.conceptToString(lcs.subsumer.getSynset()) + " (IC=" + lcs.ic + ")\n");
            }
            tracer.append("Concept1: " + this.db.conceptToString(synset1.getSynset()) + " (IC=" + ic1 + ")\n");
            tracer.append("Concept2: " + this.db.conceptToString(synset2.getSynset()) + " (IC=" + ic2 + ")\n");
        }
        return new Relatedness(score, tracer.toString(), null);
    }

    @Override
    public List<POS[]> getPOSPairs() {
        return posPairs;
    }
}

