/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.impl;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.PathFinder;
import java.util.ArrayList;
import java.util.List;

public class Path
extends RelatednessCalculator {
    protected static double min = 0.0;
    protected static double max = 1.0;
    private static List<POS[]> posPairs = new ArrayList<POS[]>(){
        {
            this.add(new POS[]{POS.n, POS.n});
            this.add(new POS[]{POS.v, POS.v});
        }
    };

    public Path(ILexicalDatabase db) {
        super(db);
    }

    @Override
    protected Relatedness calcRelatedness(Concept synset1, Concept synset2) {
        StringBuilder tracer = new StringBuilder();
        if (synset1 == null || synset2 == null) {
            return new Relatedness(min, null, "Synset is null.");
        }
        if (synset1.getSynset().equals(synset2.getSynset())) {
            return new Relatedness(max, "Synsets are identical.", null);
        }
        StringBuilder subTracer = enableTrace ? new StringBuilder() : null;
        List<PathFinder.Subsumer> shortestPaths = this.pathFinder.getShortestPaths(synset1, synset2, subTracer);
        if (shortestPaths.size() == 0) {
            return new Relatedness(min);
        }
        PathFinder.Subsumer path = shortestPaths.get(0);
        int dist = path.length;
        double score = dist > 0 ? 1.0 / (double)dist : -1.0;
        if (enableTrace) {
            tracer.append(subTracer.toString());
            tracer.append("Shortest path: " + path + "\n");
            tracer.append("Path length = " + dist + "\n");
        }
        return new Relatedness(score, tracer.toString(), null);
    }

    @Override
    public List<POS[]> getPOSPairs() {
        return posPairs;
    }
}

