/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.impl;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.ICFinder;
import edu.cmu.lti.ws4j.util.PathFinder;
import java.util.ArrayList;
import java.util.List;

public class Resnik
extends RelatednessCalculator {
    protected static double min = 0.0;
    protected static double max = Double.MAX_VALUE;
    private static List<POS[]> posPairs = new ArrayList<POS[]>(){
        {
            this.add(new POS[]{POS.n, POS.n});
            this.add(new POS[]{POS.v, POS.v});
        }
    };

    public Resnik(ILexicalDatabase db) {
        super(db);
    }

    @Override
    protected Relatedness calcRelatedness(Concept synset1, Concept synset2) {
        StringBuilder tracer = new StringBuilder();
        if (synset1 == null || synset2 == null) {
            return new Relatedness(min, null, "Synset is null.");
        }
        StringBuilder subTracer = enableTrace ? new StringBuilder() : null;
        List<PathFinder.Subsumer> lcsList = ICFinder.getInstance().getLCSbyIC(this.pathFinder, synset1, synset2, subTracer);
        if (lcsList.size() == 0) {
            return new Relatedness(min, tracer.toString(), null);
        }
        if (enableTrace) {
            tracer.append(subTracer.toString());
            for (PathFinder.Subsumer lcs : lcsList) {
                tracer.append("Lowest Common Subsumer(s): ");
                tracer.append(this.db.conceptToString(lcs.subsumer.getSynset()) + " (IC=" + lcs.ic + ")\n");
            }
        }
        PathFinder.Subsumer subsumer = lcsList.get(0);
        double score = subsumer.ic;
        return new Relatedness(score, tracer.toString(), null);
    }

    @Override
    public List<POS[]> getPOSPairs() {
        return posPairs;
    }
}

