/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.impl;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.DepthFinder;
import java.util.ArrayList;
import java.util.List;

public class WuPalmer
extends RelatednessCalculator {
    protected static double min = 0.0;
    protected static double max = 1.0;
    private static List<POS[]> posPairs = new ArrayList<POS[]>(){
        {
            this.add(new POS[]{POS.n, POS.n});
            this.add(new POS[]{POS.v, POS.v});
        }
    };

    public WuPalmer(ILexicalDatabase db) {
        super(db);
    }

    @Override
    protected Relatedness calcRelatedness(Concept synset1, Concept synset2) {
        StringBuilder tracer = new StringBuilder();
        if (synset1 == null || synset2 == null) {
            return new Relatedness(min, null, "Synset is null.");
        }
        if (synset1.getSynset().equals(synset2.getSynset())) {
            return new Relatedness(max, "Synsets are identical.", null);
        }
        StringBuilder subTracer = enableTrace ? new StringBuilder() : null;
        List<DepthFinder.Depth> lcsList = this.depthFinder.getRelatedness(synset1, synset2, subTracer);
        if (lcsList.size() == 0) {
            return new Relatedness(min);
        }
        int depth = lcsList.get((int)0).depth;
        int depth1 = this.depthFinder.getShortestDepth(synset1);
        int depth2 = this.depthFinder.getShortestDepth(synset2);
        double score = 0.0;
        if (depth1 > 0 && depth2 > 0) {
            score = (double)(2 * depth) / (double)(depth1 + depth2);
        }
        if (enableTrace) {
            tracer.append(subTracer.toString());
            for (DepthFinder.Depth lcs : lcsList) {
                tracer.append("Lowest Common Subsumer(s): ");
                tracer.append(this.db.conceptToString(lcs.leaf) + " (Depth=" + lcs.depth + ")\n");
            }
            tracer.append("Depth1( " + this.db.conceptToString(synset1.getSynset()) + " ) = " + depth1 + "\n");
            tracer.append("Depth2( " + this.db.conceptToString(synset2.getSynset()) + " ) = " + depth2 + "\n");
        }
        return new Relatedness(score, tracer.toString(), null);
    }

    @Override
    public List<POS[]> getPOSPairs() {
        return posPairs;
    }
}

