/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.util.PathFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class DepthFinder {
    private PathFinder pathFinder;

    public DepthFinder(ILexicalDatabase db) {
        this.pathFinder = new PathFinder(db);
    }

    public List<Depth> getRelatedness(Concept synset1, Concept synset2, StringBuilder tracer) {
        List<PathFinder.Subsumer> paths = this.pathFinder.getAllPaths(synset1, synset2, tracer);
        if (paths == null || paths.size() == 0) {
            return null;
        }
        ArrayList<Depth> depthList = new ArrayList<Depth>(paths.size());
        for (PathFinder.Subsumer subsumer : paths) {
            List<Depth> depths = this.getSynsetDepths(subsumer.subsumer.getSynset());
            if (depths == null || depths.size() == 0) {
                return null;
            }
            Depth depth = depths.get(0);
            depthList.add(depth);
        }
        ArrayList<Depth> toBeDeleted = new ArrayList<Depth>(depthList.size());
        for (Depth d : depthList) {
            if (((Depth)depthList.get((int)0)).depth == d.depth) continue;
            toBeDeleted.add(d);
        }
        depthList.removeAll(toBeDeleted);
        LinkedHashMap<Integer, Depth> linkedHashMap = new LinkedHashMap<Integer, Depth>(depthList.size());
        for (Depth d : depthList) {
            int key = d.toString().hashCode();
            linkedHashMap.put(key, d);
        }
        depthList = new ArrayList(linkedHashMap.values());
        return depthList;
    }

    public List<Depth> getSynsetDepths(String synset) {
        HashSet<String> history = new HashSet<String>();
        List<List<String>> hyperTrees = this.pathFinder.getHypernymTrees(synset, history);
        if (hyperTrees == null) {
            return null;
        }
        ArrayList<Depth> depths = new ArrayList<Depth>(hyperTrees.size());
        for (List<String> tree : hyperTrees) {
            Depth d = new Depth();
            d.depth = tree.size();
            d.root = tree.get(0);
            d.leaf = synset;
            depths.add(d);
        }
        Collections.sort(depths, new Comparator<Depth>(){

            @Override
            public int compare(Depth d1, Depth d2) {
                if (d1.depth > d2.depth) {
                    return 1;
                }
                if (d1.depth < d2.depth) {
                    return -1;
                }
                return 0;
            }
        });
        return depths;
    }

    public int getShortestDepth(Concept synset) {
        try {
            return this.getSynsetDepths((String)synset.getSynset()).get((int)0).depth;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static class Depth {
        public String leaf;
        public int depth;
        public String root;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            sb.append("\"depth\":\"" + this.depth + "\", ");
            sb.append("\"leaf\":\"" + this.leaf + "\", ");
            sb.append("\"root\":\"" + this.root + "\"");
            sb.append(" }");
            return sb.toString();
        }
    }
}

