/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import java.util.ArrayList;
import java.util.List;

public class GlossFinder {
    private static String[] pairs = new String[]{"    :    ", "    :hype", "    :hypo", "    :mero", "    :holo", "hype:    ", "hype:hype", "hype:hypo", "hype:mero", "hype:holo", "hypo:    ", "hypo:hype", "hypo:hypo", "hypo:mero", "hypo:holo", "mero:    ", "mero:hype", "mero:hypo", "mero:mero", "mero:holo", "syns:    ", "syns:hype", "syns:hypo", "syns:mero", "syns:holo"};
    private ILexicalDatabase db;

    public GlossFinder(ILexicalDatabase db) {
        this.db = db;
    }

    public List<SuperGloss> getSuperGlosses(Concept synset1, Concept synset2) {
        ArrayList<SuperGloss> glosses = new ArrayList<SuperGloss>(pairs.length);
        for (String pair : pairs) {
            String[] links = pair.split(":");
            SuperGloss sg = new SuperGloss();
            sg.gloss1 = (List)this.db.getGloss(synset1, links[0]);
            sg.gloss2 = (List)this.db.getGloss(synset2, links[1]);
            sg.link1 = links[0];
            sg.link2 = links[1];
            sg.weight = 1.0;
            glosses.add(sg);
        }
        return glosses;
    }

    public static class SuperGloss {
        public List<String> gloss1;
        public List<String> gloss2;
        public String link1;
        public String link2;
        public double weight;
    }
}

